/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.util.field.FieldItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormProcesser
extends CtrlProcesser {
    @Override
    public boolean isUseChild() {
        return false;
    }

    @Override
    public boolean isLoop() {
        return false;
    }

    @Override
    public boolean isSwitch() {
        return false;
    }

    @Override
    public boolean isInputCtrl() {
        return false;
    }

    @Override
    public boolean isActionCtrl() {
        return false;
    }

    @Override
    public boolean isGroupItem() {
        return false;
    }

    @Override
    public boolean isCheckCtrl() {
        return false;
    }

    @Override
    public boolean isFormatCtrl() {
        return false;
    }

    @Override
    public void setValue(Object data, FieldItem fieldItem) {
        if (data == null || !(data instanceof String)) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u308c\u305f\u5024\u306f\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093 String\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        fieldItem.setValue((String)data);
    }

    @Override
    public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {
        if (this.searchInputFileTag(list)) {
            ctrl.getOptionMap().put("method", "POST");
            ctrl.getOptionMap().put("enctype", "multipart/form-data");
        }
    }

    private boolean searchInputFileTag(List<HtmlParts> list) {
        if (list != null) {
            for (HtmlParts parts : list) {
                if (parts.getType() != HtmlPartsType.TAG) continue;
                if (parts.getTagName().equalsIgnoreCase("input") && parts.getOption().containsKey("type") && "file".equalsIgnoreCase(parts.getOption().get("type"))) {
                    return true;
                }
                if (parts.getChild() == null || !this.searchInputFileTag(parts.getChild())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag, Map<String, Object> workMap) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(ctrl.getTagName());
        sb.append(this.createFormOptionString(String.valueOf(ctrl.getName()) + loopSuffix, loopSuffix, ctrl.getOptionMap(), ctrl.isSuffix()));
        sb.append(">");
        sb.append("<input type=\"hidden\" name=\"__PIRKA__\" value=\"__PIRKA__FORM__\">");
        sb.append("<input type=\"hidden\" name=\"__PIRKA__INS__\" value=\"" + windowBaseData.getInstanceNo() + "\">");
        sb.append("<input type=\"hidden\" name=\"__PIRKA__SNO__\" value=\"" + windowBaseData.getSerialNo() + "\">");
        sb.append("<input type=\"hidden\" name=\"__PIRKA__A_SUBMIT__\" value=\"\">");
        return sb.toString();
    }

    protected String createFormOptionString(String name, String loopSuffix, Map<String, String> optionMap, boolean isSuffix) {
        StringBuilder sb = new StringBuilder();
        if (name != null && name.length() > 0) {
            sb.append(" name=\"");
            sb.append(name);
            sb.append("\"");
        }
        sb.append(" action=\"");
        String action = optionMap.get("action");
        if (action == null || action.length() <= 0) {
            sb.append(PirkaThreadMap.getEntryPointObjct().getUrlAlias());
        } else {
            sb.append(action);
        }
        sb.append("\"");
        for (String key : optionMap.keySet()) {
            if (key.equalsIgnoreCase("name") || key.equalsIgnoreCase("action")) continue;
            this.addOption(sb, optionMap, key, isSuffix, loopSuffix);
        }
        return sb.toString();
    }
}

