/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.kernel;

import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.app.OfflineEntryPoint;
import jp.oarts.pirka.core.kernel.ServletParam;

public class PirkaThreadMap
implements Serializable {
    private static final HashMap<Long, EntryPointIF> entryPointObjectMap = new HashMap();
    private static final HashMap<Long, ServletParam> servletParamMap = new HashMap();

    public static synchronized void setEntryPointObject(EntryPointIF entryPoint) {
        entryPointObjectMap.put(Thread.currentThread().getId(), entryPoint);
    }

    public static synchronized void removeEntryPointObject() {
        entryPointObjectMap.remove(Thread.currentThread().getId());
    }

    public static synchronized EntryPointIF getEntryPointObjct() {
        EntryPointIF entryPoint = entryPointObjectMap.get(Thread.currentThread().getId());
        if (entryPoint == null) {
            return OfflineEntryPoint.getInstance();
        }
        return entryPoint;
    }

    public static synchronized void setServletPartam(HttpServletRequest req, HttpServletResponse res, HttpSession session) {
        servletParamMap.put(Thread.currentThread().getId(), new ServletParam(req, res, session));
    }

    public static synchronized void setSession(HttpSession session) {
        ServletParam servletParam = servletParamMap.get(Thread.currentThread().getId());
        if (servletParam == null) {
            return;
        }
        servletParam.setSession(session);
    }

    public static synchronized void removeServletParam() {
        servletParamMap.remove(Thread.currentThread().getId());
    }

    public static synchronized HttpServletRequest getServletReq() {
        ServletParam servletParam = servletParamMap.get(Thread.currentThread().getId());
        if (servletParam == null) {
            return null;
        }
        return servletParam.getReq();
    }

    public static synchronized HttpServletResponse getServletRes() {
        ServletParam servletParam = servletParamMap.get(Thread.currentThread().getId());
        if (servletParam == null) {
            return null;
        }
        return servletParam.getRes();
    }

    public static synchronized HttpSession getSession() {
        ServletParam servletParam = servletParamMap.get(Thread.currentThread().getId());
        if (servletParam == null) {
            return null;
        }
        return servletParam.getSession();
    }
}

