/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.check;

import java.io.Serializable;
import jp.oarts.pirka.core.util.check.CheckAndTeller;
import jp.oarts.pirka.core.util.check.Checker;
import jp.oarts.pirka.core.util.check.PirkaMessage;

public class CheckerItem
implements Serializable {
    public static final int MODE_CHECKER = 1;
    public static final int MODE_CHECK_AND_TELLER = 2;
    public static final int MODE_BREAKER = 3;
    public static final int MODE_RETURNER = 4;
    public static final CheckerItem BREAKER = new CheckerItem(3);
    public static final CheckerItem RETURNER = new CheckerItem(4);
    private int mode;
    private String fieldName;
    private Checker[] checkers;
    private CheckAndTeller[] checkAndTellers;
    private String errorMessage;
    private PirkaMessage prikaMessage;

    private CheckerItem(int mode) {
        this.mode = mode;
    }

    public CheckerItem(String fieldName, Checker ... checkers) {
        this(fieldName, "", checkers);
    }

    public CheckerItem(String fieldName, String errorMessage, Checker ... checkers) {
        this.mode = 1;
        this.fieldName = this.getBaseName(fieldName);
        this.errorMessage = errorMessage;
        this.checkers = checkers;
        this.checkAndTellers = null;
        this.prikaMessage = null;
    }

    public CheckerItem(String fieldName, PirkaMessage prikaMessage, Checker ... checkers) {
        this.mode = 1;
        this.fieldName = this.getBaseName(fieldName);
        this.errorMessage = null;
        this.checkers = checkers;
        this.checkAndTellers = null;
        this.prikaMessage = prikaMessage;
    }

    public CheckerItem(CheckAndTeller ... checkAndTellers) {
        this.mode = 2;
        this.fieldName = null;
        this.errorMessage = null;
        this.checkers = null;
        this.checkAndTellers = checkAndTellers;
        this.prikaMessage = null;
    }

    private String getBaseName(String name) {
        int index = name.indexOf("$");
        if (index < 0) {
            return name;
        }
        return name.substring(0, index);
    }

    public CheckAndTeller[] getCheckAndTellers() {
        return this.checkAndTellers;
    }

    public Checker[] getCheckers() {
        return this.checkers;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getMode() {
        return this.mode;
    }

    public PirkaMessage getPrikaMessage() {
        return this.prikaMessage;
    }
}

