/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.util.check;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.util.check.CheckAndTeller;
import jp.oarts.pirka.core.util.check.Checker;
import jp.oarts.pirka.core.util.check.CheckerItem;
import jp.oarts.pirka.core.util.check.CheckerStocker;
import jp.oarts.pirka.core.util.check.PirkaCheckException;
import jp.oarts.pirka.core.util.field.FieldItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCheck
implements Serializable {
    int errorCount = 0;
    private boolean isReturn = false;

    public boolean isReturn() {
        return this.isReturn;
    }

    public int runCheck(CheckerStocker checkerStocker, Map<String, FieldItem> rootFieldMap, FieldMap fieldMap, ErrorMessageStocker errorMessageStocker) {
        HashMap<String, String> groupValueMap = new HashMap<String, String>();
        for (String fieldName : rootFieldMap.keySet()) {
            FieldItem fieldItem = rootFieldMap.get(fieldName);
            if (!fieldItem.getCtrl().getCtrlProcesser().isGroupItem()) continue;
            String baseFieldName = fieldItem.getCtrl().getBaseName();
            String suffixName = fieldName.substring(fieldItem.getCtrl().getName().length());
            String groupFieldName = String.valueOf(baseFieldName) + HtmlTools.changeSuffix(suffixName, fieldItem.getCtrl().getGroupLevel());
            if (!fieldItem.isChecked()) continue;
            groupValueMap.put(groupFieldName, (String)fieldItem.getValue());
        }
        int i = 0;
        while (i < checkerStocker.size()) {
            HashMap<String, Boolean> groupCheckedMap = new HashMap<String, Boolean>();
            CheckerItem checkerItem = checkerStocker.getCheckItem(i);
            if (checkerItem.getMode() == 1) {
                for (String fieldName : rootFieldMap.keySet()) {
                    int n;
                    FieldItem fieldItem = rootFieldMap.get(fieldName);
                    String baseFieldName = fieldItem.getCtrl().getBaseName();
                    String suffixName = fieldName.substring(fieldItem.getCtrl().getName().length());
                    if (!baseFieldName.equals(checkerItem.getFieldName())) continue;
                    if (!fieldItem.getCtrl().getCtrlProcesser().isGroupItem()) {
                        String value = (String)fieldItem.getValue();
                        try {
                            Checker[] checkerArray = checkerItem.getCheckers();
                            int n2 = 0;
                            n = checkerArray.length;
                            while (n2 < n) {
                                Checker checker = checkerArray[n2];
                                checker.check(value);
                                ++n2;
                            }
                        }
                        catch (PirkaCheckException e) {
                            ++this.errorCount;
                            fieldItem.setErrorFlag(true);
                            if (checkerItem.getPrikaMessage() == null) {
                                if (checkerItem.getErrorMessage() == null || checkerItem.getErrorMessage().length() <= 0) {
                                    errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), e.getMessage());
                                    continue;
                                }
                                errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getErrorMessage());
                                continue;
                            }
                            errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getPrikaMessage());
                        }
                        continue;
                    }
                    String groupFieldName = String.valueOf(baseFieldName) + HtmlTools.changeSuffix(suffixName, fieldItem.getCtrl().getGroupLevel());
                    if (!groupCheckedMap.containsKey(groupFieldName)) {
                        String value = "";
                        if (groupValueMap.containsKey(groupFieldName)) {
                            value = (String)groupValueMap.get(groupFieldName);
                        }
                        try {
                            Checker[] checkerArray = checkerItem.getCheckers();
                            n = 0;
                            int n3 = checkerArray.length;
                            while (n < n3) {
                                Checker checker = checkerArray[n];
                                checker.check(value);
                                ++n;
                            }
                            groupCheckedMap.put(groupFieldName, true);
                        }
                        catch (PirkaCheckException e) {
                            groupCheckedMap.put(groupFieldName, false);
                            ++this.errorCount;
                            fieldItem.setErrorFlag(true);
                            if (checkerItem.getPrikaMessage() == null) {
                                if (checkerItem.getErrorMessage() == null || checkerItem.getErrorMessage().length() <= 0) {
                                    errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), e.getMessage());
                                    continue;
                                }
                                errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getErrorMessage());
                                continue;
                            }
                            errorMessageStocker.addError(fieldItem.getCtrl().getOfficialFieldName(), checkerItem.getPrikaMessage());
                        }
                        continue;
                    }
                    if (((Boolean)groupCheckedMap.get(groupFieldName)).booleanValue()) continue;
                    ++this.errorCount;
                    fieldItem.setErrorFlag(true);
                }
            } else if (checkerItem.getMode() == 2) {
                CheckAndTeller[] checkAndTellerArray = checkerItem.getCheckAndTellers();
                int n = 0;
                int n4 = checkAndTellerArray.length;
                while (n < n4) {
                    CheckAndTeller checkAndTeller = checkAndTellerArray[n];
                    checkAndTeller.setFieldMap(fieldMap);
                    checkAndTeller.setErrorMessageStocker(errorMessageStocker);
                    if (!checkAndTeller.check()) {
                        ++this.errorCount;
                    }
                    ++n;
                }
            } else if (checkerItem.getMode() == 3) {
                if (this.errorCount > 0) {
                    return this.errorCount;
                }
            } else if (checkerItem.getMode() == 4 && this.errorCount > 0) {
                this.isReturn = true;
                return this.errorCount;
            }
            ++i;
        }
        return this.errorCount;
    }
}

