/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.app;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.kernel.PirkaUploadManager;
import jp.oarts.pirka.core.util.converter.ReqCharacterConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReqParser
implements Serializable {
    private static final String MULTIPPART_STRING = "multipart/form-data";
    private static final String CONTENT_DISPOSITION_HEAD = "content-disposition:";

    public static void parser(HttpServletRequest req, Map<String, String[]> reqMap, List<Long> fileNoList) throws IOException {
        EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
        ReqCharacterConverter charConverter = entryPoint.getReqCharacterConverter();
        String contentType = req.getContentType();
        if (contentType != null && contentType.toLowerCase().indexOf(MULTIPPART_STRING) >= 0) {
            ReqParser.multipartParser((InputStream)req.getInputStream(), reqMap, fileNoList, charConverter);
        } else {
            ReqParser.singleParser(req, reqMap, charConverter);
        }
    }

    private static void singleParser(HttpServletRequest req, Map<String, String[]> reqMap, ReqCharacterConverter charConverte) throws IOException {
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            name = charConverte.convertKanji(name);
            String[] values = req.getParameterValues(name);
            int i = 0;
            while (i < values.length) {
                values[i] = charConverte.convertKanji(values[i]);
                ++i;
            }
            reqMap.put(name, values);
        }
    }

    private static void multipartParser(InputStream sis, Map<String, String[]> reqMap, List<Long> fileNoList, ReqCharacterConverter charConverte) throws IOException {
        HashMap<String, List> paramMap = new HashMap<String, List>();
        FilterOutputStream bos = null;
        byte[] tempBuff = new byte[1024];
        byte[] tempValue = new byte[256];
        int tempValueOffset = 0;
        boolean bFileOut = false;
        long fileNo = 0L;
        try {
            try {
                try {
                    byte[] boundaryTemp = ReqParser.readByteLine(sis, tempBuff);
                    if (boundaryTemp.length <= 0) {
                        throw new EOFException("\u7d42\u7aef\u6587\u5b57\u30d1\u30bf\u30fc\u30f3\u7121\u3057");
                    }
                    byte[] boundary = new byte[boundaryTemp.length + 2];
                    System.arraycopy(boundaryTemp, 0, boundary, 2, boundaryTemp.length);
                    boundary[0] = 13;
                    boundary[1] = 10;
                    while (true) {
                        bFileOut = false;
                        String contentDisposition = ReqParser.readStringLine(sis, tempBuff, charConverte);
                        if (contentDisposition.length() <= CONTENT_DISPOSITION_HEAD.length()) {
                            throw new EOFException("CONTENT_DISPOSITION_HEAD\u9577\u30a8\u30e9\u30fc");
                        }
                        if (!contentDisposition.substring(0, CONTENT_DISPOSITION_HEAD.length()).toLowerCase().equals(CONTENT_DISPOSITION_HEAD)) {
                            throw new EOFException("CONTENT_DISPOSITION_HEAD\u30a8\u30e9\u30fc");
                        }
                        String name = "";
                        String filename = "";
                        StringTokenizer st = new StringTokenizer(contentDisposition = contentDisposition.substring(CONTENT_DISPOSITION_HEAD.length()).trim(), ";");
                        int count = st.countTokens();
                        if (count < 1) {
                            break;
                        }
                        int i = 0;
                        while (i < count) {
                            StringTokenizer st2 = new StringTokenizer(st.nextToken().trim(), "=");
                            if (st2.countTokens() == 2) {
                                String key = st2.nextToken().toLowerCase().trim();
                                String value = st2.nextToken();
                                if (key.equals("name")) {
                                    name = ReqParser.cutDC(value);
                                } else if (key.equals("filename")) {
                                    filename = ReqParser.cutDC(value);
                                }
                            }
                            ++i;
                        }
                        bFileOut = false;
                        bos = null;
                        if (!filename.equals("")) {
                            fileNo = PirkaUploadManager.getFileNo();
                            fileNoList.add(fileNo);
                            bos = new BufferedOutputStream(PirkaUploadManager.getOutputStream(fileNo));
                            bFileOut = true;
                        }
                        while (!ReqParser.readStringLine(sis, tempBuff, charConverte).equals("")) {
                        }
                        tempValueOffset = 0;
                        int offset = 0;
                        boolean length = false;
                        long outCount = 0L;
                        while (true) {
                            int readCount;
                            if ((readCount = sis.read(tempBuff, offset++, 1)) <= 0) {
                                throw new EOFException("\u30c7\u30fc\u30bf\u8aad\u307f\u53d6\u308a\u4e2d\u306bEOF");
                            }
                            if (offset < boundary.length) continue;
                            if (ReqParser.checkEnd(tempBuff, offset - boundary.length, boundary)) break;
                            if (bFileOut) {
                                if (bos != null) {
                                    ((BufferedOutputStream)bos).write(tempBuff, offset - boundary.length, 1);
                                    ++outCount;
                                }
                            } else if (tempValueOffset < tempValue.length) {
                                tempValue[tempValueOffset++] = tempBuff[offset - boundary.length];
                            } else {
                                byte[] t = tempValue;
                                tempValue = new byte[t.length + 100];
                                System.arraycopy(t, 0, tempValue, 0, t.length);
                                tempValue[tempValueOffset++] = tempBuff[offset - boundary.length];
                            }
                            if (offset < tempBuff.length) continue;
                            System.arraycopy(tempBuff, offset - boundary.length + 1, tempBuff, 0, boundary.length - 1);
                            offset = boundary.length - 1;
                        }
                        if (bFileOut) {
                            if (bos != null) {
                                ((BufferedOutputStream)bos).flush();
                                bos.close();
                                bos = null;
                            }
                            ReqParser.setParamNoConvertKanji(name, filename, paramMap);
                            ReqParser.setParamNoConvertKanji(name, "" + fileNo, paramMap);
                        } else {
                            byte[] tempByte = new byte[tempValueOffset];
                            System.arraycopy(tempValue, 0, tempByte, 0, tempValueOffset);
                            ReqParser.setParam(name, tempByte, paramMap, charConverte);
                        }
                        ReqParser.readStringLine(sis, tempBuff, charConverte);
                    }
                }
                catch (EOFException boundaryTemp) {
                }
                catch (IOException e) {
                    throw e;
                }
            }
            finally {
                sis.close();
            }
        }
        finally {
            if (bos != null) {
                bos.close();
                bos = null;
                throw new IOException("\u30de\u30eb\u30c1\u30d1\u30fc\u30b5\u30fc\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f \u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u304c\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
        }
        for (String key : paramMap.keySet()) {
            reqMap.put(key, ((List)paramMap.get(key)).toArray(new String[0]));
        }
    }

    private static byte[] readByteLine(InputStream is, byte[] tempBuff) throws IOException {
        int offset = 0;
        int mode = 0;
        while (offset < tempBuff.length && is.read(tempBuff, offset, 1) >= 1) {
            byte byteData;
            if ((byteData = tempBuff[offset++]) == 13) {
                mode = 1;
                continue;
            }
            if (byteData == 10 && mode == 1) {
                mode = 2;
                break;
            }
            mode = 0;
        }
        if ((offset -= mode) <= 0) {
            if (mode != 2) {
                throw new EOFException("eof");
            }
            return new byte[0];
        }
        byte[] buff = new byte[offset];
        System.arraycopy(tempBuff, 0, buff, 0, offset);
        return buff;
    }

    private static String readStringLine(InputStream is, byte[] tempBuff, ReqCharacterConverter charConverte) throws IOException {
        byte[] buff = ReqParser.readByteLine(is, tempBuff);
        if (buff == null) {
            return null;
        }
        return charConverte.convertKanji(buff);
    }

    private static boolean checkEnd(byte[] buff, int offset, byte[] checkData) {
        int i = 0;
        while (i < checkData.length) {
            if (buff[offset + i] != checkData[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String cutDC(String str) {
        if (str == null) {
            return null;
        }
        if (str.equals("\"\"")) {
            return "";
        }
        if (str.length() > 1 && str.substring(0, 1).equals("\"")) {
            str = str.substring(1);
        }
        if (str.length() > 1 && str.substring(str.length() - 1).equals("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private String cutFileName(String str) {
        if (str == null) {
            return null;
        }
        int idx = (str = ReqParser.cutDC(str)).lastIndexOf("\\");
        if (idx + 1 < str.length()) {
            str = str.substring(idx + 1);
        }
        if ((idx = str.lastIndexOf("/")) + 1 < str.length()) {
            str = str.substring(idx + 1);
        }
        return str;
    }

    private static void setParam(String key, byte[] value, HashMap<String, List> paramMap, ReqCharacterConverter charConverte) {
        LinkedList<String> paramList = paramMap.get(key);
        if (paramList == null) {
            paramList = new LinkedList<String>();
            paramMap.put(key, paramList);
        }
        paramList.add(charConverte.convertKanji(value));
    }

    private static void setParamNoConvertKanji(String key, String value, HashMap<String, List> paramMap) {
        LinkedList<String> paramList = paramMap.get(key);
        if (paramList == null) {
            paramList = new LinkedList<String>();
            paramMap.put(key, paramList);
        }
        paramList.add(value);
    }
}

