package jp.oarts.pirka.core.util.converter;

import java.io.Serializable;

/**
 * Ro[^[
 * 
 * @author ito
 * 
 */
public class Converter implements Serializable {

	/** ʃtB[h */
	String windowFieldName;

	/** DTOtB[h */
	String targetFieldName;

	/** f[^[Ro[^[ */
	DataConverter dataConverter;

	/**
	 * RXgN^
	 * 
	 * @param windowFieldName
	 *            ʃtB[h
	 * @param targetFieldName
	 *            DTOtB[h
	 */
	public Converter(String windowFieldName, String targetFieldName) {
		this(windowFieldName, targetFieldName, null);
	}

	/**
	 * RXgN^
	 * 
	 * @param windowFieldName
	 *            ʃtB[h
	 * @param dataConverter
	 *            f[^[Ro[^[
	 */
	public Converter(String windowFieldName, DataConverter dataConverter) {
		this(windowFieldName, windowFieldName, dataConverter);

	}

	/**
	 * RXgN^
	 * 
	 * @param windowFieldName
	 *            ʃtB[h
	 * @param targetFieldName
	 *            DTOtB[h
	 * @param dataConverter
	 *            f[^[Ro[^[
	 */
	public Converter(String windowFieldName, String targetFieldName, DataConverter dataConverter) {
		if (windowFieldName == null) {
			throw new RuntimeException("Ro[^[IuWFNgɂ͉ʃtB[hw肵Ă");
		}
		this.windowFieldName = windowFieldName;
		this.targetFieldName = targetFieldName;
		this.dataConverter = dataConverter;
	}

	/**
	 * ̕ύXKv̊mFs܂B
	 * 
	 * @return true=̕ύXKv
	 */
	public boolean isNameChange() {
		return !windowFieldName.equals(targetFieldName);
	}

	/**
	 * f[^̃Ro[gKv̊mFs܂B
	 * 
	 * @return true=vf[^̃Ro[g
	 */
	public boolean isDataConvert() {
		return !(dataConverter == null);
	}

	/**
	 * @return dataConverter ߂܂B
	 */
	public DataConverter getDataConverter() {
		return dataConverter;
	}

	/**
	 * @param dataConverter
	 *            ݒ肷 dataConverterB
	 */
	public void setDataConverter(DataConverter dataConverter) {
		this.dataConverter = dataConverter;
	}

	/**
	 * @return targetFieldName ߂܂B
	 */
	public String getTargetFieldName() {
		return targetFieldName;
	}

	/**
	 * @param targetFieldName
	 *            ݒ肷 targetFieldNameB
	 */
	public void setTargetFieldName(String targetFieldName) {
		this.targetFieldName = targetFieldName;
	}

	/**
	 * @return windowFieldName ߂܂B
	 */
	public String getWindowFieldName() {
		return windowFieldName;
	}

	/**
	 * @param windowFieldName
	 *            ݒ肷 windowFieldNameB
	 */
	public void setWindowFieldName(String windowFieldName) {
		if (windowFieldName == null) {
			throw new RuntimeException("Ro[^[IuWFNgɂ͉ʃtB[hw肵Ă");
		}
		this.windowFieldName = windowFieldName;
	}

}
