#!/usr/local/bin/ruby
#
#-----------------------------------------------------------
# Author:   Dice
# License:  NYSL 0.9982 (http://www.kmonos.net/nysl/)
# URL:      http://scl.littlestar.jp/pinkyblog/
#-----------------------------------------------------------

begin

	$SAFE = 1
	require 'blog'

	app = Rack::Builder.new{
		run BlogCaller.new
	}
	

	Rack::Handler::CGI.run(app)

	
rescue Exception

	$stdout.binmode
	
	res = ''
	lf = "\r\n"
	
	__FILE__.untaint
	nph = (File.basename(__FILE__) =~ /^nph\-/ ? true : false)
	
	if nph then
		res << "HTTP/1.1 500 Internal Server Error" << lf
	end
	res << "Content-Type: text/plain" << lf
	res << lf
	
	res << "nph = #{nph.inspect}" << lf
	res << lf
	res << "#{$!} (#{$!.class})" << lf
	res << $@.map{|x| "  #{x}"}.join(lf) << lf
	res << "ruby #{RUBY_VERSION} (#{RUBY_RELEASE_DATE}) [#{RUBY_PLATFORM}]" << lf
	if defined?(PinkyBlog::CORE_VERSION) then
		res << "Pinky:blog #{PinkyBlog::CORE_VERSION}" << lf
	else
		res << "Pinky:blog (system version is unidentified)" << lf
	end
	
	res << lf
	
	File.write('pinkyblog_error.log', res, 'wb')
	
	#$stdout = open('stdout', 'wb')
	$stdout.write(res)
end

