package org.phosphoresce.commons.database.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.exception.DatabaseConnectionException;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;

/**
 * f[^x[XZbVNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/05	Kitagawa		VK쐬
 *-->
 */
public class DatabaseSession {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** f[^x[XڑIuWFNg */
	private DatabaseConfig config;

	/** f[^x[XRlNVIuWFNg */
	private Connection connection;

	/**
	 * RXgN^<br>
	 * @param config f[^x[XڑIuWFNg
	 * @throws DatabaseSessionException Ƀf[^x[XRlNV擾łȂꍇɔ
	 */
	public DatabaseSession(DatabaseConfig config) throws DatabaseSessionException {
		super();
		if (config == null) {
			throw new DatabaseSessionException("null 'config' argument.");
		}
		this.config = config;
		this.connection = createConnection();

		log.trace("new database session created. [" + config.getJdbcUrl() + "]");
	}

	/**
	 * RXgN^<br>
	 * @throws DatabaseSessionException Ƀf[^x[XRlNV擾łȂꍇɔ
	 */
	private DatabaseSession() throws DatabaseSessionException {
		this(null);
	}

	/**
	 * f[^x[XڑɃf[^x[XRlNVIuWFNgVKɐ܂B<br>
	 * @return f[^x[XRlNVIuWFNg
	 * @throws DatabaseSessionException Ƀf[^x[XRlNV擾łȂꍇɔ
	 */
	private Connection createConnection() throws DatabaseSessionException {
		try {
			Class.forName(config.getJdbcDriver());
			Connection connection = DriverManager.getConnection(config.getJdbcUrl(), config.getJdbcUser(), config.getJdbcPassword());
			connection.setAutoCommit(config.isAutoCommit());

			log.trace("new database connection created.");

			return connection;
		} catch (Throwable throwable) {
			throw new DatabaseSessionException("failed to create new database connection.", throwable);
		}
	}

	/**
	 * f[^x[XRlNVIuWFNg擾܂B<br>
	 * @return f[^x[XRlNVIuWFNg
	 * @throws DatabaseConnectionException Ƀf[^x[XRlNV擾łȂꍇɔ
	 */
	public Connection getConnection() throws DatabaseSessionException {
		try {
			if (connection == null || connection.isClosed()) {
				connection = createConnection();
			}
			return connection;
		} catch (SQLException e) {
			throw new DatabaseSessionException("failed to get database connection", e);
		}
	}

	/**
	 * f[^x[XRlNVN[Y܂B<br>
	 * @throws DatabaseSessionException ɃZbVێRlNV邱ƂłȂꍇɔ
	 * @see java.sql.Connection#close()
	 */
	public void close() throws DatabaseSessionException {
		try {
			if (connection != null && !connection.isClosed()) {
				connection.close();
			}
			log.trace("database connection closed.");
		} catch (SQLException e) {
			throw new DatabaseSessionException("failed to close database connection.", e);
		}
	}

	/**
	 * f[^x[XRlNVR~bg܂B<br>
	 * @throws DatabaseSessionException ɃZbVێRlNVR~bg邱ƂłȂꍇɔ
	 * @see java.sql.Connection#commit()
	 */
	public void commit() throws DatabaseSessionException {
		try {
			if (connection != null && !connection.isClosed()) {
				connection.commit();
			}
			log.trace("database connection commited.");
		} catch (SQLException e) {
			throw new DatabaseSessionException("failed to commit database connection.", e);
		}
	}

	/**
	 * f[^x[XRlNV[obN܂B<br>
	 * @throws DatabaseSessionException ɃZbVێRlNV[obN邱ƂłȂꍇɔ
	 * @see java.sql.Connection#rollback()
	 */
	public void rollback() throws DatabaseSessionException {
		try {
			if (connection != null && !connection.isClosed()) {
				connection.rollback();
			}
			log.trace("database connection rollbacked.");
		} catch (SQLException e) {
			throw new DatabaseSessionException("failed to rollback database connection.", e);
		}
	}
}
