package org.phosphoresce.commons.database.core;

import java.sql.SQLException;

/**
 * R[hGgG[ێNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/05	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseError {

	/** G[sʒu */
	private int rowIndex = -1;

	/** G[Jʒu */
	private int columnIndex = -1;

	/** OIuWFNg */
	private Throwable exception = null;

	/**
	 * RXgN^<br>
	 * @param rowIndex G[sʒu
	 * @param columnIndex G[Jʒu
	 * @param exception OIuWFNg
	 */
	public DatabaseError(int rowIndex, int columnIndex, Throwable exception) {
		super();
		this.rowIndex = rowIndex;
		this.columnIndex = columnIndex;
		this.exception = exception;
	}

	/**
	 * RXgN^<br>
	 * @param rowIndex G[sʒu
	 * @param exception OIuWFNg
	 */
	public DatabaseError(int rowIndex, Throwable exception) {
		super();
		this.rowIndex = rowIndex;
		this.exception = exception;
	}

	/**
	 * RXgN^<br>
	 * @param exception OIuWFNg
	 */
	public DatabaseError(Throwable exception) {
		super();
		this.exception = exception;
	}

	/**
	 * RXgN^<br>
	 */
	private DatabaseError() {
	}

	/**
	 * G[bZ[W擾܂B<br>
	 * @return G[bZ[W
	 */
	public String getErrorMessage() {
		StringBuffer buffer = new StringBuffer();
		if (rowIndex >= 0) {
			buffer.append(rowIndex + 1);
			buffer.append(" row");
		}
		if (columnIndex >= 0) {
			buffer.append(" ");
			buffer.append(columnIndex + 1);
			buffer.append(" column");
		}
		if (columnIndex < 0 && rowIndex < 0) {
			buffer.append(" transaction");
		}
		buffer.append(" error : ");
		if (exception != null) {
			buffer.append(exception.getMessage());
		}
		return buffer.toString();
	}

	/**
	 * ێOIuWFNgSQLExceptionhNXłꍇɃx_[ŗL̃G[R[h擾܂B<br>
	 * @return x_[ŗL̃G[R[h
	 */
	public String getErrorCode() {
		if (exception instanceof SQLException) {
			return String.valueOf(((SQLException) exception).getErrorCode());
		} else {
			return "";
		}
	}

	/**
	 * ێOIuWFNgSQLExceptionhNXł邩肵܂B<br>
	 * @return ێOIuWFNgSQLExceptionhNXłꍇtrueԋp
	 */
	public boolean isSQLException() {
		return exception instanceof SQLException;
	}

	/**
	 * OIuWFNg擾܂B<br>
	 * @return OIuWFNg
	 */
	public Throwable getException() {
		return exception;
	}
}
