package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * sێNX<br>
 * <br>
 * NXResultSetւ̒ڎQƍXV͍sꂸAɓƗ𑀍삵܂B<br>
 * [U[ɂēIuWFNg}ꂽ^C~OŎg̃IuWFNgƓ̏ێJIuWFNg
 * R[hANZXNXɐVKɔ܂BAAg̃IuWFNgQƂR[hANZXɑ}ł͂܂B<br>
 * ܂łIuWFNg̓ev[gNXƂĂ̈ʒuÂłAResultSetƂ̈ˑ֌W͔܂B<br>
 * AA`݂̂ResultSetւ̎QƂsAÓ͂̏Ɣrs܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public final class ResultTemplateRow extends ResultAccessorAbstract {

	/** s`IuWFNg */
	private ResultRowDefinition definition;

	/** JIuWFNgXg */
	private List columns = new LinkedList();

	// Constructor

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @param definition `IuWFNg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	ResultTemplateRow(ResultSet resultSet, ResultRowDefinition definition) throws ResultSetAccessException, IllegalResultSetLocationIndexException,
			IllegalResultSetAdjustmentException {
		super(resultSet, ResultAccessorState.TEMPLATE, null);
		this.definition = definition;
		for (int i = 0; i <= definition.getColumnCount() - 1; i++) {
			columns.add(new ResultTemplateColumn(resultSet, this, definition.getColumnDefinition(i), i));
		}
		refreshResult();
	}

	// Accessor Interface Method

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * NX̓ev[gNXłׁA`݂̂̍XVs܂B<br>
	 * @param force `݂̂̍XVł邽߁AtOɊ֌WȂKXVs܂
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#refreshResult(boolean)
	 */
	protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		definition.refreshResult();
	}

	/**
	 * gێeResultSetɑ΂Ĕf܂B<br>
	 * NX̓ev[gNXłׁAResultSetւ̔f͍s邱Ƃ܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#updateResult()
	 */
	protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		//
	}

	// Public Method

	/**
	 * s`IuWFNg擾܂B<br>
	 * @return s`IuWFNg
	 */
	public ResultRowDefinition getDefinition() {
		return definition;
	}

	/**
	 * w肳ꂽJCfbNX̃J`IuWFNg擾܂B<br>
	 * @return s`IuWFNg
	 * @throws IllegalResultSetLocationIndexException sȃJCfbNXw肳ꂽꍇɔ
	 */
	public ResultColumnDefinition getColumnDefinition(int index) throws IllegalResultSetLocationIndexException {
		if (columns.size() - 1 < index || index < 0) {
			throw new IllegalResultSetLocationIndexException(index + " is illegal index");
		}
		return definition.getColumnDefinition(index);
	}

	/**
	 * w肳ꂽJ̃J`IuWFNg擾܂B<br>
	 * @return s`IuWFNg
	 * @throws IllegalResultSetLocationIndexException sȃJCfbNXw肳ꂽꍇɔ
	 */
	public ResultColumnDefinition getColumnDefinition(String name) throws IllegalResultSetLocationIndexException {
		return getColumnDefinition(definition.getColumnIndex(name));
	}

	/**
	 * w肳ꂽJCfbNX̃JIuWFNg擾܂B<br>
	 * @param index JCfbNX(0`)
	 * @return JIuWFNg
	 * @throws IllegalResultSetLocationIndexException sȃJCfbNXw肳ꂽꍇɔ
	 */
	public ResultTemplateColumn getColumn(int index) throws IllegalResultSetLocationIndexException {
		if (columns.size() - 1 < index || index < 0) {
			throw new IllegalResultSetLocationIndexException(index + " is illegal index");
		}
		return (ResultTemplateColumn) columns.get(index);
	}

	/**
	 * w肳ꂽJ̃JIuWFNg擾܂B<br>
	 * @param name J
	 * @return JIuWFNg
	 * @throws IllegalResultSetLocationIndexException w肳ꂽJsɑ݂Ȃꍇɔ
	 */
	public ResultTemplateColumn getColumn(String name) throws IllegalResultSetLocationIndexException {
		return getColumn(definition.getColumnIndex(name));
	}

	// Override Method

	/**
	 * NX𕶎ƂĒ񋟂܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("[");
		for (Iterator iterator = columns.iterator(); iterator.hasNext();) {
			buffer.append(iterator.next());
			if (iterator.hasNext()) {
				buffer.append(", ");
			}
		}
		buffer.append("]");
		return buffer.toString();
	}
}
