package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * R[hGgANZXNXۃNX<br>
 * <br>
 * NX͊e탌R[hGgTuNXɂ鋤ʂ̃C^tF[XyуtB[h񋟂܂B<br>
 * eGgTuNX͂pāATuNXɓ܂B<br>
 * <br>
 * ܂AʂKvɉēnꂽANZXXi[NXɑ΂āAe폈A܂͏ԕύXʒmA
 * ʂ̃NXɁA̕ύXɂe폈̃gK[񋟂s܂B<br>
 * 
 * @see org.phosphoresce.commons.database.accessor.ResultAccessor
 * @see org.phosphoresce.commons.database.accessor.ResultAccessorListener
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/09	Kitagawa		VK쐬
 *-->
 */
public abstract class ResultAccessorAbstract implements ResultAccessor {

	/** K[IuWFNg */
	protected Log log = LogFactory.getLog(this.getClass());

	/** ResultSetIuWFNg */
	protected ResultSet resultSet = null;

	/** R[hANZbTԃIuWFNg */
	protected ResultAccessorState state = null;

	/** ԊǗXi[IuWFNg */
	protected ResultAccessorListener listener = null;

	/** G[IuWFNg */
	protected DatabaseError error = null;

	// Constuctor

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @param state ԊǗXi[IuWFNg
	 * @param listener ԊǗXi[IuWFNg
	 * @throws ResultSetAccessException sResultSetIuWFNgw肵ꍇɔ
	 */
	protected ResultAccessorAbstract(ResultSet resultSet, ResultAccessorState state, ResultAccessorListener listener) throws ResultSetAccessException {
		if (resultSet == null) {
			throw new ResultSetAccessException("null 'resultSet' argument.");
		}
		if (state == null) {
			throw new ResultSetAccessException("null 'state' argument.");
		}
		this.resultSet = resultSet;
		this.listener = listener;
		this.state = state;
		this.error = null;
	}

	/**
	 * RXgN^<br>
	 * @throws ResultSetAccessException sResultSetIuWFNgw肵ꍇɔ
	 */
	private ResultAccessorAbstract() throws ResultSetAccessException {
		this(null, null, null);
	}

	// Public Method

	/**
	 * R[hANZbTԃIuWFNg擾܂B<br>
	 * @return R[hANZbTԃIuWFNg
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessor#getState()
	 */
	public final ResultAccessorState getState() {
		return state;
	}

	/**
	 * G[IuWFNgێ邩肵܂B<br>
	 * @return G[IuWFNgێꍇtrueԋp
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessor#hasError()
	 */
	public final boolean hasError() {
		return error != null;
	}

	/**
	 * G[IuWFNg擾܂B<br>
	 * @return G[IuWFNg
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessor#getError()
	 */
	public final DatabaseError getError() {
		return error;
	}

	// Accessor Method

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * ݁AύXsĂeׂ͂ĔjAResultSet̏ōXV܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	protected final void refreshResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		refreshResult(false);
	}

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * @param force 󋵂Ɋւ炸IɍXVꍇtruewAG[̏ꍇɓ̏󋵂ɂĂ͍XVsȂꍇfalsewB̓͋ۃNX݌vɂĈقȂ܂B
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	protected abstract void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException;

	/**
	 * gێeResultSetɑ΂Ĕf܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	protected abstract void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException;

	// Protected Method

	/**
	 * w肳ꂽsʒu(ResultSetdlɔA1`)ɃJ[\ړ܂B<br>
	 * @param rowIndex sʒu(1`)
	 * @throws ResultSetAccessException ɃJ[\ړsȂꍇɔ
	 */
	protected final void moveCurser(int rowIndex) throws ResultSetAccessException {
		try {
			if (rowIndex == 0) {
				resultSet.beforeFirst();
			} else {
				resultSet.absolute(rowIndex);
			}
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to move cursor.", e);
		}
	}

	/**
	 * ݃ANeBuResultSetIuWFNg̍sʒu擾܂B<br>
	 * @return ݃ANeBuResultSetIuWFNg̍sʒu
	 * @throws ResultSetAccessException ɃJ[\ړsȂꍇɔ
	 */
	protected final int getResultSetRowIndex() throws ResultSetAccessException {
		try {
			return resultSet.getRow();
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to get ResultSet row index.", e);
		}
	}

	/**
	 * ԊǗXi[IuWFNgLł邩肵܂B<br>
	 * @return ԊǗXi[IuWFNgLłꍇtrueԋp
	 */
	protected final boolean validateStateListener() {
		return listener != null;
	}
}
