/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class AxisRecord
extends Record {
    public static final short sid = 4125;
    private short field_1_axisType;
    public static final short AXIS_TYPE_CATEGORY_OR_X_AXIS = 0;
    public static final short AXIS_TYPE_VALUE_AXIS = 1;
    public static final short AXIS_TYPE_SERIES_AXIS = 2;
    private int field_2_reserved1;
    private int field_3_reserved2;
    private int field_4_reserved3;
    private int field_5_reserved4;

    public AxisRecord() {
    }

    public AxisRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public AxisRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 4125) {
            throw new RecordFormatException("Not a Axis record");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        int pos = 0;
        this.field_1_axisType = LittleEndian.getShort(data, pos + 0 + offset);
        this.field_2_reserved1 = LittleEndian.getInt(data, pos + 2 + offset);
        this.field_3_reserved2 = LittleEndian.getInt(data, pos + 6 + offset);
        this.field_4_reserved3 = LittleEndian.getInt(data, pos + 10 + offset);
        this.field_5_reserved4 = LittleEndian.getInt(data, pos + 14 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AXIS]\n");
        buffer.append("    .axisType             = ").append("0x").append(HexDump.toHex(this.getAxisType())).append(" (").append(this.getAxisType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved1            = ").append("0x").append(HexDump.toHex(this.getReserved1())).append(" (").append(this.getReserved1()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved2            = ").append("0x").append(HexDump.toHex(this.getReserved2())).append(" (").append(this.getReserved2()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved3            = ").append("0x").append(HexDump.toHex(this.getReserved3())).append(" (").append(this.getReserved3()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved4            = ").append("0x").append(HexDump.toHex(this.getReserved4())).append(" (").append(this.getReserved4()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/AXIS]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4125);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_axisType);
        LittleEndian.putInt(data, 6 + offset + pos, this.field_2_reserved1);
        LittleEndian.putInt(data, 10 + offset + pos, this.field_3_reserved2);
        LittleEndian.putInt(data, 14 + offset + pos, this.field_4_reserved3);
        LittleEndian.putInt(data, 18 + offset + pos, this.field_5_reserved4);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 4125;
    }

    public Object clone() {
        AxisRecord rec = new AxisRecord();
        rec.field_1_axisType = this.field_1_axisType;
        rec.field_2_reserved1 = this.field_2_reserved1;
        rec.field_3_reserved2 = this.field_3_reserved2;
        rec.field_4_reserved3 = this.field_4_reserved3;
        rec.field_5_reserved4 = this.field_5_reserved4;
        return rec;
    }

    public short getAxisType() {
        return this.field_1_axisType;
    }

    public void setAxisType(short field_1_axisType) {
        this.field_1_axisType = field_1_axisType;
    }

    public int getReserved1() {
        return this.field_2_reserved1;
    }

    public void setReserved1(int field_2_reserved1) {
        this.field_2_reserved1 = field_2_reserved1;
    }

    public int getReserved2() {
        return this.field_3_reserved2;
    }

    public void setReserved2(int field_3_reserved2) {
        this.field_3_reserved2 = field_3_reserved2;
    }

    public int getReserved3() {
        return this.field_4_reserved3;
    }

    public void setReserved3(int field_4_reserved3) {
        this.field_4_reserved3 = field_4_reserved3;
    }

    public int getReserved4() {
        return this.field_5_reserved4;
    }

    public void setReserved4(int field_5_reserved4) {
        this.field_5_reserved4 = field_5_reserved4;
    }
}

