/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.wpoi.dyna;

import org.phosphoresce.commons.wpoi.adapter.PoiCell;
import org.phosphoresce.commons.wpoi.exception.PoiException;

final class PoiDynaUtil {
    public static final String DYNA_PREFIX = "$dyna:";
    public static final String DYNA_COMMNET_IDENTIFIER = "#";
    public static final String DYNA_TYPE_VALUE = "value:";
    public static final String DYNA_TYPE_LIST_START = "list_start:";
    public static final String DYNA_TYPE_LIST_END = "list_end:";

    PoiDynaUtil() {
    }

    public static boolean isDynaCell(PoiCell pCell) {
        return pCell != null && pCell.getForceStringValue().startsWith(DYNA_PREFIX);
    }

    public static String getDynaType(PoiCell pCell) throws PoiException {
        if (!PoiDynaUtil.isDynaCell(pCell)) {
            throw new PoiException("\u6307\u5b9a\u3055\u308c\u305fHSSFCell\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u52d5\u7684\u30bb\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093[" + (pCell == null ? "null" : pCell.getForceStringValue() + "]"));
        }
        String dynaTypeAndValue = pCell.getForceStringValue().substring(DYNA_PREFIX.length());
        if (dynaTypeAndValue.startsWith(DYNA_TYPE_VALUE)) {
            return DYNA_TYPE_VALUE;
        }
        if (dynaTypeAndValue.startsWith(DYNA_TYPE_LIST_START)) {
            return DYNA_TYPE_LIST_START;
        }
        if (dynaTypeAndValue.startsWith(DYNA_TYPE_LIST_END)) {
            return DYNA_TYPE_LIST_END;
        }
        throw new PoiException("\u6307\u5b9a\u3055\u308c\u305fHSSFCell\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u4e0d\u660e\u306a\u52d5\u7684\u30bb\u30eb\u30bf\u30a4\u30d7\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u3059");
    }

    public static String getDynaKey(PoiCell pCell) throws PoiException {
        String dynaComment;
        String dynaType = PoiDynaUtil.getDynaType(pCell);
        String dynaColumn = pCell.getForceStringValue().substring((DYNA_PREFIX + dynaType).length());
        String dynaKey = dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) >= 0 ? dynaColumn.substring(0, dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER)) : dynaColumn;
        String string = dynaComment = dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) >= 0 ? dynaColumn.substring(dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) + 1) : "";
        if ("".equals(dynaKey)) {
            throw new PoiException("\u6307\u5b9a\u3055\u308c\u305fHSSFCell\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u52d5\u7684\u30ad\u30fc\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        return dynaKey.trim();
    }

    public static String getDynaComment(PoiCell pCell) throws PoiException {
        String dynaType = PoiDynaUtil.getDynaType(pCell);
        String dynaColumn = pCell.getForceStringValue().substring((DYNA_PREFIX + dynaType).length());
        String dynaKey = dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) >= 0 ? dynaColumn.substring(0, dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER)) : dynaColumn;
        String dynaComment = dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) >= 0 ? dynaColumn.substring(dynaColumn.indexOf(DYNA_COMMNET_IDENTIFIER) + 1) : "";
        return dynaComment.trim();
    }

    public static boolean isDynaValue(PoiCell pCell) throws PoiException {
        return DYNA_TYPE_VALUE.equals(PoiDynaUtil.getDynaType(pCell));
    }

    public static boolean isDynaListStart(PoiCell pCell) throws PoiException {
        return DYNA_TYPE_LIST_START.equals(PoiDynaUtil.getDynaType(pCell));
    }

    public static boolean isDynaListEnd(PoiCell pCell) throws PoiException {
        return DYNA_TYPE_LIST_END.equals(PoiDynaUtil.getDynaType(pCell));
    }
}

