package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.dialogs.ConfigDialog;
import jp.gr.java_conf.miya.pglauncher.dialogs.ProgramDialog;
import jp.gr.java_conf.miya.pglauncher.utils.LocalUtils;
import jp.gr.java_conf.miya.pglauncher.utils.TreeUtils;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddProgramAction extends AbstractAction {

	//======================================================================
	// Instance Variable
	//======================================================================
	//------------------------------------------------------------ private
	private ConfigDialog dialog_;
	private TreeViewer viewer_;

	//======================================================================
	// Constructor
	//======================================================================
	//------------------------------------------------------------ public
	public AddProgramAction(ConfigDialog dialog,
						TreeViewer viewer,
						ActionEventProvider provider){
		super(LocalUtils.getString("AddProgramAction.menuTitle"),null,provider); //$NON-NLS-1$
		dialog_ = dialog;
		viewer_ = viewer;
	}

	//======================================================================
	// Instance Method
	//======================================================================
	//------------------------------------------------------------ public
	public void run(){
		ProgramDialog dialog = new ProgramDialog(viewer_.getControl().getShell());
		dialog.open();
		if(dialog.getReturnCode() == ProgramDialog.OK){
			Element el = TreeUtils.getSelectedElement(viewer_);
			Element newEl = null;
			if(dialog.isProgram()){
				newEl = _createProgramElement(dialog.getProgramName(),dialog.getPath(),dialog.getArg());
				el.appendChild(newEl);
			}else if(dialog.isFolder()){
				newEl = _createFolderElement(dialog.getProgramName(),dialog.getPath());
				el.appendChild(newEl);
			}
			viewer_.refresh();
			viewer_.setSelection(new StructuredSelection(newEl),true);
			dialog_.modified();
		}
	}
	
	public void doubleClick(Event event){}
	
	public void rightClick(Event event){
		Element el = TreeUtils.getSelectedElement(viewer_);
		String type = el.getNodeName();
		
		if(type.equals(Const.NODE_ROOT) ||
				type.equals(Const.NODE_GROUP)) setEnabled(true);
		else setEnabled(false);
	}
	
	public void keyDown(Event event){}
	
	//------------------------------------------------------------ private
	private Element _createProgramElement(String name,String path,String arg){
		Element el = ((Document)viewer_.getInput()).createElement(Const.NODE_PROGRAM);
		el.setAttribute(Const.ATTR_NAME,name);
		el.setAttribute(Const.ATTR_PATH,path);
		el.setAttribute(Const.ATTR_ARG,arg);
		return el;
	}
	private Element _createFolderElement(String name,String path){
		Element el = ((Document)viewer_.getInput()).createElement(Const.NODE_FOLDER);
		el.setAttribute(Const.ATTR_NAME,name);
		el.setAttribute(Const.ATTR_PATH,path);
		return el;
	}
}
