package jp.gr.java_conf.miya.pglauncher.actions;

import jp.gr.java_conf.miya.pglauncher.common.Const;
import jp.gr.java_conf.miya.pglauncher.dialogs.ConfigDialog;
import jp.gr.java_conf.miya.pglauncher.dialogs.GroupDialog;
import jp.gr.java_conf.miya.pglauncher.utils.LocalUtils;
import jp.gr.java_conf.miya.pglauncher.utils.TreeUtils;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddGroupAction extends AbstractAction {
	
	//======================================================================
	// Instance Variable
	//======================================================================
	//------------------------------------------------------------ private
	private ConfigDialog dialog_;
	private TreeViewer viewer_;

	//======================================================================
	// Constructor
	//======================================================================
	//------------------------------------------------------------ public
	public AddGroupAction(ConfigDialog dialog,
							TreeViewer viewer,
							ActionEventProvider provider){
		super(LocalUtils.getString("AddGroupAction.menuTitle"),null,provider); //$NON-NLS-1$
		dialog_ = dialog;
		viewer_ = viewer;
	}

	//======================================================================
	// Instance Method
	//======================================================================
	//------------------------------------------------------------ public
	public void run(){
		GroupDialog dialog = new GroupDialog(viewer_.getControl().getShell(),""); //$NON-NLS-1$
		dialog.open();
		if(dialog.getReturnCode() == GroupDialog.OK){
			Element el = TreeUtils.getSelectedElement(viewer_);
			Node group = _createGroupElement(dialog.getGroupName());
			el.appendChild(group);
			viewer_.refresh();
			viewer_.setSelection(new StructuredSelection(group),true);
			dialog_.modified();
		}
	}
	
	public void doubleClick(Event event){}
	
	public void rightClick(Event event){
		Element el = TreeUtils.getSelectedElement(viewer_);
		String type = el.getNodeName();
		if(type.equals(Const.NODE_ROOT) ||
				type.equals(Const.NODE_GROUP)){
			setEnabled(true);
		}else{
			setEnabled(false);
		}
	}
	
	public void keyDown(Event event){}
	
	//------------------------------------------------------------ private
	private Element _createGroupElement(String str){
		Element el = ((Document)viewer_.getInput()).createElement(Const.NODE_GROUP);
		el.setAttribute(Const.ATTR_NAME,str);
		return el;
	}
}
