/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.miya.pglauncher.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.gr.java_conf.miya.pglauncher.PGLauncherPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    private static XMLUtils instance_;

    private XMLUtils() {
    }

    public static XMLUtils getInstance() {
        if (instance_ == null) {
            instance_ = new XMLUtils();
        }
        return instance_;
    }

    public static void removeNode(Document document, Node node) {
        XMLUtils._removeNode(document, node);
    }

    private static boolean _removeNode(Node parent, Node target) {
        NodeList list = parent.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.equals(target)) {
                parent.removeChild(node);
                return true;
            }
            if (node.getChildNodes().getLength() > 0 && XMLUtils._removeNode(node, target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Document loadDocument() {
        File file = PGLauncherPlugin.getConfigFile();
        try {
            if (!file.exists()) {
                FileWriter writer = new FileWriter(file);
                writer.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<pglauncher>\n</pglauncher>".toString());
                writer.flush();
                writer.close();
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveDocument(Document document) {
        File file = PGLauncherPlugin.getConfigFile();
        try {
            DOMSource source = new DOMSource(document);
            FileOutputStream os = new FileOutputStream(file);
            StreamResult result = new StreamResult(os);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

