/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.miya.pglauncher.dialogs;

import java.io.File;
import jp.gr.java_conf.miya.pglauncher.utils.LocalUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProgramDialog
extends TitleAreaDialog {
    public static final int FOCUS_PROGRAM = 0;
    public static final int FOCUS_FOLDER = 1;
    private String programName_;
    private String path_;
    private String arg_;
    private ModifyListenerImpl modListener_;
    private SelectionListenerImpl selectListener_;
    private Text programText_;
    private Text argText_;
    private Text folderText_;
    private Text nameText_;
    private Button programRadio_;
    private Button folderRadio_;
    private Button programButton_;
    private Button folderButton_;
    private int focus_ = 0;

    public ProgramDialog(Shell parent) {
        this(parent, "", "", "", 0);
    }

    public ProgramDialog(Shell parent, String programName, String path, String arg, int focus) {
        super(parent);
        this.programName_ = programName;
        this.path_ = path;
        this.arg_ = arg;
        this.focus_ = focus;
        this.modListener_ = new ModifyListenerImpl();
        this.selectListener_ = new SelectionListenerImpl();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(LocalUtils.getString("ProgramDialog.titlebar"));
    }

    public void create() {
        super.create();
        if (this.programName_.equals("")) {
            this.getButton(0).setEnabled(false);
        }
    }

    public String getProgramName() {
        return this.programName_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getArg() {
        return this.arg_;
    }

    public boolean isProgram() {
        return this.focus_ == 0;
    }

    public boolean isFolder() {
        return this.focus_ == 1;
    }

    protected Point getInitialSize() {
        return new Point(400, 320);
    }

    protected void okPressed() {
        this.programName_ = this.nameText_.getText();
        if (this.isProgram()) {
            this.path_ = this.programText_.getText();
            this.arg_ = this.argText_.getText();
        }
        if (this.isFolder()) {
            this.path_ = this.folderText_.getText();
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        this.setMessage(LocalUtils.getString("ProgramDialog.title"), 1);
        Group group = new Group(contents, 0);
        group.setText(LocalUtils.getString("ProgramDialog.label3"));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        this.programRadio_ = new Button((Composite)group, 16);
        this.programRadio_.setText(LocalUtils.getString("ProgramDialog.radio1"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.programRadio_.setLayoutData((Object)data);
        this.programRadio_.addSelectionListener((SelectionListener)this.selectListener_);
        this.programText_ = new Text((Composite)group, 2048);
        if (this.isProgram()) {
            this.programText_.setText(this.path_);
        }
        this.programText_.setLayoutData((Object)new GridData(768));
        this.programText_.addModifyListener((ModifyListener)this.modListener_);
        this.programButton_ = new Button((Composite)group, 8);
        this.programButton_.setText(LocalUtils.getString("ProgramDialog.referenceBtn"));
        this.programButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ProgramDialog.this.programButton_.getShell());
                dialog.setFilterExtensions(new String[]{"*.*"});
                String filePath = dialog.open();
                if (filePath != null) {
                    String fileName;
                    int pos;
                    ProgramDialog.this.programText_.setText(filePath);
                    int delim = filePath.lastIndexOf("\\");
                    int slash = filePath.lastIndexOf("/");
                    if (slash > delim) {
                        delim = slash;
                    }
                    if ((pos = (fileName = filePath.substring(delim + 1)).indexOf(".")) > 0) {
                        fileName = fileName.substring(0, pos);
                    }
                    ProgramDialog.this.nameText_.setText(fileName);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite argContents = new Composite((Composite)group, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        argContents.setLayout((Layout)layout);
        data = new GridData(768);
        argContents.setLayoutData((Object)data);
        Label argLabel = new Label(argContents, 0);
        argLabel.setText(LocalUtils.getString("ProgramDialog.label2"));
        this.argText_ = new Text(argContents, 2048);
        this.argText_.setLayoutData((Object)new GridData(768));
        if (this.isProgram()) {
            this.argText_.setText(this.arg_);
        }
        new Label((Composite)group, 0);
        this.folderRadio_ = new Button((Composite)group, 16);
        this.folderRadio_.setText(LocalUtils.getString("ProgramDialog.radio2"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.folderRadio_.setLayoutData((Object)data);
        this.folderRadio_.addSelectionListener((SelectionListener)this.selectListener_);
        this.folderText_ = new Text((Composite)group, 2048);
        if (this.isFolder()) {
            this.folderText_.setText(this.path_);
        }
        this.folderText_.setLayoutData((Object)new GridData(768));
        this.folderText_.addModifyListener((ModifyListener)this.modListener_);
        this.folderButton_ = new Button((Composite)group, 8);
        this.folderButton_.setText(LocalUtils.getString("ProgramDialog.referenceBtn"));
        this.folderButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String dirPath = new DirectoryDialog(ProgramDialog.this.programButton_.getShell()).open();
                if (dirPath != null) {
                    ProgramDialog.this.folderText_.setText(dirPath);
                    int delim = dirPath.lastIndexOf("\\");
                    int slash = dirPath.lastIndexOf("/");
                    if (slash > delim) {
                        delim = slash;
                    }
                    ProgramDialog.this.nameText_.setText(dirPath.substring(delim + 1));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.programRadio_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProgramDialog.this.programText_.setEnabled(true);
                ProgramDialog.this.programButton_.setEnabled(true);
                ProgramDialog.this.argText_.setEnabled(true);
                ProgramDialog.this.folderText_.setEnabled(false);
                ProgramDialog.this.folderButton_.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.folderRadio_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProgramDialog.this.programText_.setEnabled(false);
                ProgramDialog.this.programButton_.setEnabled(false);
                ProgramDialog.this.argText_.setEnabled(false);
                ProgramDialog.this.folderText_.setEnabled(true);
                ProgramDialog.this.folderButton_.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.isProgram()) {
            this.programRadio_.setSelection(true);
            this.folderRadio_.setSelection(false);
            this.programText_.setEnabled(true);
            this.programButton_.setEnabled(true);
            this.argText_.setEnabled(true);
            this.folderText_.setEnabled(false);
            this.folderButton_.setEnabled(false);
        }
        if (this.isFolder()) {
            this.programRadio_.setSelection(false);
            this.folderRadio_.setSelection(true);
            this.programText_.setEnabled(false);
            this.programButton_.setEnabled(false);
            this.argText_.setEnabled(false);
            this.folderText_.setEnabled(true);
            this.folderButton_.setEnabled(true);
        }
        Label nameLabel = new Label(contents, 0);
        nameLabel.setText(LocalUtils.getString("ProgramDialog.label1"));
        this.nameText_ = new Text(contents, 2048);
        this.nameText_.setText(this.programName_);
        this.nameText_.setLayoutData((Object)new GridData(768));
        this.nameText_.addModifyListener((ModifyListener)this.modListener_);
        this.programText_.setFocus();
        return composite;
    }

    private boolean _validateName(String str) {
        if (str.length() == 0) {
            this.setDisableOK(LocalUtils.getString("ProgramDialog.error1"));
            return false;
        }
        return true;
    }

    private boolean _validateProgramText(String str) {
        if (str.length() == 0) {
            this.setDisableOK(LocalUtils.getString("ProgramDialog.error2"));
            return false;
        }
        if (!this.isFileExist(str)) {
            this.setDisableOK(LocalUtils.getString("ProgramDialog.error3"));
            return false;
        }
        return true;
    }

    private boolean _validateFolderText(String str) {
        if (str.length() == 0) {
            this.setDisableOK(LocalUtils.getString("ProgramDialog.error4"));
            return false;
        }
        if (!this.isFolderExist(str)) {
            this.setDisableOK(LocalUtils.getString("ProgramDialog.error5"));
            return false;
        }
        return true;
    }

    private boolean isFileExist(String fileName) {
        File file = new File(fileName);
        return file.exists() && file.isFile();
    }

    private boolean isFolderExist(String fileName) {
        File file = new File(fileName);
        return file.exists() && file.isDirectory();
    }

    private void setEnableOK() {
        this.setMessage(LocalUtils.getString("ProgramDialog.title"), 1);
        this.getButton(0).setEnabled(true);
    }

    private void setDisableOK(String msg) {
        this.setMessage(msg, 3);
        this.getButton(0).setEnabled(false);
    }

    class ModifyListenerImpl
    implements ModifyListener {
        ModifyListenerImpl() {
        }

        public void modifyText(ModifyEvent e) {
            if (!ProgramDialog.this._validateName(ProgramDialog.this.nameText_.getText())) {
                return;
            }
            if (ProgramDialog.this.focus_ == 0 ? !ProgramDialog.this._validateProgramText(ProgramDialog.this.programText_.getText()) : ProgramDialog.this.focus_ == 1 && !ProgramDialog.this._validateFolderText(ProgramDialog.this.folderText_.getText())) {
                return;
            }
            ProgramDialog.this.setEnableOK();
        }
    }

    class SelectionListenerImpl
    implements SelectionListener {
        SelectionListenerImpl() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == ProgramDialog.this.programRadio_) {
                ProgramDialog.this.focus_ = 0;
            } else if (e.widget == ProgramDialog.this.folderRadio_) {
                ProgramDialog.this.focus_ = 1;
            }
            if (ProgramDialog.this.focus_ == 0 ? !ProgramDialog.this._validateProgramText(ProgramDialog.this.programText_.getText()) : ProgramDialog.this.focus_ == 1 && !ProgramDialog.this._validateFolderText(ProgramDialog.this.folderText_.getText())) {
                return;
            }
            if (!ProgramDialog.this._validateName(ProgramDialog.this.nameText_.getText())) {
                return;
            }
            ProgramDialog.this.setEnableOK();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

