/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.base.ui.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.weasis.base.ui.Messages;
import org.weasis.base.ui.gui.JLocaleCombo;
import org.weasis.core.api.gui.util.AbstractItemDialogPage;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.api.gui.util.WinUtil;
import org.weasis.core.api.service.BundleTools;

public class GeneralSetting
extends AbstractItemDialogPage {
    public static final String pageName = Messages.getString("LookSetting.gen");
    private LookInfo oldUILook;
    private Component component1;
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private final JLabel jLabelMLook = new JLabel();
    private final JComboBox jComboBox1 = new JComboBox();
    private final JLabel labelLocale = new JLabel(Messages.getString("LookSetting.locale"));
    private final JComboBox comboBox = new JLocaleCombo();
    private final JTextPane txtpnNote = new JTextPane();
    private final JCheckBox chckbxConfirmClosing = new JCheckBox(Messages.getString("GeneralSetting.closingConfirmation"));
    private final JButton button = new JButton(Messages.getString("GeneralSetting.show"));

    public GeneralSetting() {
        this.setTitle(pageName);
        this.setList(this.jComboBox1, UIManager.getInstalledLookAndFeels());
        try {
            this.jbInit();
            this.initialize(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.component1 = Box.createHorizontalStrut(8);
        this.gridBagLayout1.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0};
        this.gridBagLayout1.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0};
        this.setLayout(this.gridBagLayout1);
        this.jLabelMLook.setText(Messages.getString("LookSetting.lf"));
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.insets = new Insets(15, 10, 5, 5);
        gbc_label.anchor = 21;
        gbc_label.gridx = 0;
        gbc_label.gridy = 0;
        this.add(this.labelLocale, gbc_label);
        GridBagConstraints gbc_comboBox = new GridBagConstraints();
        gbc_comboBox.gridwidth = 3;
        gbc_comboBox.anchor = 17;
        gbc_comboBox.insets = new Insets(15, 0, 5, 0);
        gbc_comboBox.gridx = 1;
        gbc_comboBox.gridy = 0;
        this.add(this.comboBox, gbc_comboBox);
        GridBagConstraints gbc_button = new GridBagConstraints();
        gbc_button.insets = new Insets(7, 5, 5, 15);
        gbc_button.gridx = 2;
        gbc_button.gridy = 1;
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookInfo item = (LookInfo)GeneralSetting.this.jComboBox1.getSelectedItem();
                final String finalLafClassName = item.getClassName();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Dialog dialog = WinUtil.getParentDialog((Component)((Object)GeneralSetting.this));
                            UIManager.setLookAndFeel(finalLafClassName);
                            SwingUtilities.updateComponentTreeUI(dialog);
                        }
                        catch (Exception exception) {
                            System.out.println("Can't change look and feel");
                        }
                    }
                };
                GuiExecutor.instance().execute(runnable);
            }
        });
        this.add(this.button, gbc_button);
        GridBagConstraints gbc_chckbxConfirmationMessageWhen = new GridBagConstraints();
        gbc_chckbxConfirmationMessageWhen.gridwidth = 4;
        gbc_chckbxConfirmationMessageWhen.anchor = 17;
        gbc_chckbxConfirmationMessageWhen.insets = new Insets(7, 10, 5, 0);
        gbc_chckbxConfirmationMessageWhen.gridx = 0;
        gbc_chckbxConfirmationMessageWhen.gridy = 2;
        this.add(this.chckbxConfirmClosing, gbc_chckbxConfirmationMessageWhen);
        GridBagConstraints gbc_txtpnNote = new GridBagConstraints();
        gbc_txtpnNote.anchor = 18;
        gbc_txtpnNote.gridwidth = 4;
        gbc_txtpnNote.insets = new Insets(5, 10, 5, 0);
        gbc_txtpnNote.fill = 2;
        gbc_txtpnNote.gridx = 0;
        gbc_txtpnNote.gridy = 3;
        this.txtpnNote.setEditable(false);
        this.txtpnNote.setText(Messages.getString("GeneralSetting.txtpnNote"));
        this.add(this.txtpnNote, gbc_txtpnNote);
        this.add(this.component1, new GridBagConstraints(3, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jLabelMLook, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(7, 10, 5, 5), 0, 0));
        this.add(this.jComboBox1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 2, 5, 15), 5, -2));
    }

    protected void initialize(boolean afirst) {
        this.chckbxConfirmClosing.setSelected(BundleTools.SYSTEM_PREFERENCES.getBooleanProperty("weasis.confirm.closing", true));
        String className = null;
        LookAndFeel currentLAF = UIManager.getLookAndFeel();
        if (currentLAF != null) {
            className = currentLAF.getClass().getName();
        }
        if (className != null) {
            for (int i = 0; i < this.jComboBox1.getItemCount(); ++i) {
                LookInfo look = (LookInfo)this.jComboBox1.getItemAt(i);
                if (!className.equals(look.getClassName())) continue;
                this.oldUILook = look;
                break;
            }
        }
        if (this.oldUILook == null) {
            this.jComboBox1.setSelectedIndex(0);
            this.oldUILook = (LookInfo)this.jComboBox1.getSelectedItem();
        } else {
            this.jComboBox1.setSelectedItem(this.oldUILook);
        }
    }

    public void setList(JComboBox jComboBox, UIManager.LookAndFeelInfo[] look) {
        jComboBox.removeAllItems();
        for (int i = 0; i < look.length; ++i) {
            jComboBox.addItem(new LookInfo(look[i].getName(), look[i].getClassName()));
        }
    }

    public void closeAdditionalWindow() {
        BundleTools.SYSTEM_PREFERENCES.putBooleanProperty("weasis.confirm.closing", this.chckbxConfirmClosing.isSelected());
        LookInfo look = (LookInfo)this.jComboBox1.getSelectedItem();
        if (look != null) {
            BundleTools.SYSTEM_PREFERENCES.put((Object)"weasis.look", (Object)look.getClassName());
        }
        final String finalLafClassName = this.oldUILook.getClassName();
        LookAndFeel currentLAF = UIManager.getLookAndFeel();
        if (currentLAF != null && !finalLafClassName.equals(currentLAF.getClass().getName())) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        WinUtil.getParentDialog((Component)((Object)GeneralSetting.this)).setVisible(false);
                        UIManager.setLookAndFeel(finalLafClassName);
                        for (Window window : Window.getWindows()) {
                            SwingUtilities.updateComponentTreeUI(window);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Can't change look and feel");
                    }
                }
            };
            GuiExecutor.instance().execute(runnable);
        }
    }

    public void resetoDefaultValues() {
    }

    static class LookInfo {
        private final String name;
        private final String className;

        public LookInfo(String name, String className) {
            this.name = name;
            this.className = className;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return this.name;
        }
    }
}

