/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer.wado;

import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VRMap;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.explorer.ObservableEvent;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.gui.task.CircularProgressBar;
import org.weasis.core.api.gui.task.SeriesProgressMonitor;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.SeriesImporter;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.media.data.Thumbnail;
import org.weasis.core.api.service.BundleTools;
import org.weasis.core.api.util.FileUtil;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.SeriesViewerFactory;
import org.weasis.core.ui.editor.ViewerPluginBuilder;
import org.weasis.core.ui.editor.image.ViewerPlugin;
import org.weasis.dicom.codec.DicomInstance;
import org.weasis.dicom.codec.DicomMediaIO;
import org.weasis.dicom.codec.TransferSyntax;
import org.weasis.dicom.codec.wado.WadoParameters;
import org.weasis.dicom.explorer.DicomExplorer;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.MimeSystemAppFactory;
import org.weasis.dicom.explorer.wado.DicomManager;
import org.weasis.dicom.explorer.wado.DownloadPriority;
import org.weasis.dicom.explorer.wado.LoadRemoteDicomManifest;

public class LoadSeries
extends SwingWorker<Boolean, Void>
implements SeriesImporter {
    private static final Logger log = LoggerFactory.getLogger(LoadSeries.class);
    public static final String CODOWNLOAD_IMAGES_NB = "wado.codownload.images.nb";
    public static final int CODOWNLOAD_NUMBER = BundleTools.SYSTEM_PREFERENCES.getIntProperty("wado.codownload.images.nb", 4);
    public static final File DICOM_EXPORT_DIR = new File(AbstractProperties.APP_TEMP_DIR, "dicom");
    public static final File DICOM_TMP_DIR = new File(AbstractProperties.APP_TEMP_DIR, "tmp");
    private static final ExecutorService executor;
    private final DicomModel dicomModel;
    private final Series dicomSeries;
    private final JProgressBar progressBar;
    private DownloadPriority priority = null;

    public LoadSeries(Series dicomSeries, DicomModel dicomModel) {
        if (dicomModel == null || dicomSeries == null) {
            throw new IllegalArgumentException("null parameters");
        }
        this.dicomModel = dicomModel;
        this.dicomSeries = dicomSeries;
        final List sopList = (List)dicomSeries.getTagValue(TagW.WadoInstanceReferenceList);
        final CircularProgressBar[] bar = new CircularProgressBar[1];
        GuiExecutor.instance().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                bar[0] = new CircularProgressBar(0, sopList.size());
            }
        });
        this.progressBar = bar[0];
        this.dicomSeries.setSeriesLoader((SeriesImporter)this);
    }

    public LoadSeries(Series dicomSeries, DicomModel dicomModel, JProgressBar progressBar) {
        if (dicomModel == null || dicomSeries == null || progressBar == null) {
            throw new IllegalArgumentException("null parameters");
        }
        this.dicomModel = dicomModel;
        this.dicomSeries = dicomSeries;
        this.progressBar = progressBar;
        this.dicomSeries.setSeriesLoader((SeriesImporter)this);
    }

    @Override
    protected Boolean doInBackground() {
        return this.startDownload();
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public boolean isStopped() {
        return this.isCancelled();
    }

    public boolean stop() {
        if (!this.isDone()) {
            boolean val = this.cancel(true);
            this.dicomSeries.setSeriesLoader((SeriesImporter)this);
            return val;
        }
        return true;
    }

    public void resume() {
        if (this.isStopped()) {
            LoadSeries taskResume = new LoadSeries(this.dicomSeries, this.dicomModel, this.progressBar);
            DownloadPriority p = this.getPriority();
            p.setPriority(DownloadPriority.COUNTER.getAndDecrement());
            taskResume.setPriority(p);
            Thumbnail thumbnail = (Thumbnail)this.getDicomSeries().getTagValue(TagW.Thumbnail);
            if (thumbnail != null) {
                LoadSeries.removeAnonymousMouseAndKeyListener(thumbnail);
                thumbnail.addMouseListener((MouseListener)DicomExplorer.createThumbnailMouseAdapter(taskResume.getDicomSeries(), this.dicomModel, taskResume));
                thumbnail.addKeyListener((KeyListener)DicomExplorer.createThumbnailKeyListener(taskResume.getDicomSeries(), this.dicomModel));
            }
            LoadRemoteDicomManifest.loadingQueue.offer(taskResume);
        }
    }

    @Override
    protected void done() {
        if (!this.isStopped()) {
            LoadRemoteDicomManifest.currentTasks.remove(this);
            Thumbnail thumbnail = (Thumbnail)this.dicomSeries.getTagValue(TagW.Thumbnail);
            if (thumbnail != null) {
                thumbnail.setProgressBar(null);
                thumbnail.repaint();
            }
            Integer splitNb = (Integer)this.dicomSeries.getTagValue(TagW.SplitSeriesNumber);
            Object dicomObject = this.dicomSeries.getTagValue(TagW.DicomSpecialElement);
            if (splitNb != null || dicomObject != null) {
                this.dicomModel.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Update, (Object)this.dicomModel, null, (Object)this.dicomSeries));
            } else if (this.dicomSeries.size() == 0) {
                this.dicomModel.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Remove, (Object)this.dicomModel, null, (Object)this.dicomSeries));
            }
            this.dicomSeries.setSeriesLoader(null);
        }
    }

    private boolean isSOPInstanceUIDExist(MediaSeriesGroup study, Series dicomSeries, String sopUID) {
        if (dicomSeries.hasMediaContains(TagW.SOPInstanceUID, (Object)sopUID)) {
            return true;
        }
        String uid = (String)dicomSeries.getTagValue(TagW.SeriesInstanceUID);
        if (study != null && uid != null) {
            Collection<MediaSeriesGroup> seriesList = this.dicomModel.getChildren(study);
            for (MediaSeriesGroup group : seriesList) {
                Series s;
                if (dicomSeries == group || !(group instanceof Series) || !uid.equals((s = (Series)group).getTagValue(TagW.SeriesInstanceUID)) || !s.hasMediaContains(TagW.SOPInstanceUID, (Object)sopUID)) continue;
                return true;
            }
        }
        return false;
    }

    private void incrementProgressBarValue() {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LoadSeries.this.progressBar.setValue(LoadSeries.this.progressBar.getValue() + 1);
            }
        });
    }

    private Boolean startDownload() {
        MediaSeriesGroup patient = this.dicomModel.getParent((MediaSeriesGroup)this.dicomSeries, DicomModel.patient);
        MediaSeriesGroup study = this.dicomModel.getParent((MediaSeriesGroup)this.dicomSeries, DicomModel.study);
        log.info("Downloading series of {} [{}]", (Object)patient, (Object)this.dicomSeries);
        List sopList = (List)this.dicomSeries.getTagValue(TagW.WadoInstanceReferenceList);
        WadoParameters wado = (WadoParameters)this.dicomSeries.getTagValue(TagW.WadoParameters);
        if (wado == null) {
            return false;
        }
        ExecutorService imageDownloader = Executors.newFixedThreadPool(CODOWNLOAD_NUMBER);
        ArrayList<Download> tasks = new ArrayList<Download>(sopList.size());
        int[] dindex = this.generateDownladOrder(sopList.size());
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                LoadSeries.this.progressBar.setValue(0);
            }
        });
        for (int k = 0; k < sopList.size(); ++k) {
            DicomInstance instance = (DicomInstance)sopList.get(dindex[k]);
            if (this.isCancelled()) {
                return true;
            }
            if (this.isSOPInstanceUIDExist(study, this.dicomSeries, instance.getSopInstanceUID())) {
                this.incrementProgressBarValue();
                log.debug("DICOM instance {} already exists, skip.", (Object)instance.getSopInstanceUID());
                continue;
            }
            URL url = null;
            try {
                String studyUID = "";
                String seriesUID = "";
                if (!wado.isRequireOnlySOPInstanceUID()) {
                    studyUID = (String)study.getTagValue(TagW.StudyInstanceUID);
                    seriesUID = (String)this.dicomSeries.getTagValue(TagW.SeriesInstanceUID);
                }
                StringBuffer request = new StringBuffer(wado.getWadoURL());
                if (instance.getDirectDownloadFile() == null) {
                    String wado_tsuid;
                    request.append("?requestType=WADO&studyUID=");
                    request.append(studyUID);
                    request.append("&seriesUID=");
                    request.append(seriesUID);
                    request.append("&objectUID=");
                    request.append(instance.getSopInstanceUID());
                    request.append("&contentType=application%2Fdicom");
                    TransferSyntax transcoding = DicomManager.getInstance().getWadoTSUID();
                    if (transcoding.getTransferSyntaxUID() != null) {
                        this.dicomSeries.setTag(TagW.WadoTransferSyntaxUID, (Object)transcoding.getTransferSyntaxUID());
                    }
                    if ((wado_tsuid = (String)this.dicomSeries.getTagValue(TagW.WadoTransferSyntaxUID)) != null && !wado_tsuid.equals("")) {
                        Integer rate;
                        request.append("&transferSyntax=");
                        request.append(wado_tsuid);
                        if (transcoding.getTransferSyntaxUID() != null) {
                            this.dicomSeries.setTag(TagW.WadoCompressionRate, (Object)transcoding.getCompression());
                        }
                        if ((rate = (Integer)this.dicomSeries.getTagValue(TagW.WadoCompressionRate)) != null && rate > 0) {
                            request.append("&imageQuality=");
                            request.append(rate);
                        }
                    }
                } else {
                    request.append(instance.getDirectDownloadFile());
                }
                request.append(wado.getAdditionnalParameters());
                url = new URL(request.toString());
            }
            catch (MalformedURLException e1) {
                log.error(e1.getMessage(), e1.getCause());
                continue;
            }
            log.debug("Download DICOM instance {} index {}.", (Object)url, (Object)k);
            Download ref = new Download(url, wado);
            tasks.add(ref);
        }
        try {
            imageDownloader.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        imageDownloader.shutdown();
        return true;
    }

    public void startDownloadImageReference(final WadoParameters wadoParameters) {
        List sopList = (List)this.dicomSeries.getTagValue(TagW.WadoInstanceReferenceList);
        if (sopList.size() > 0) {
            Collections.sort(sopList, new Comparator<DicomInstance>(){

                @Override
                public int compare(DicomInstance dcm1, DicomInstance dcm2) {
                    int nubmer1 = dcm1.getInstanceNumber();
                    int nubmer2 = dcm2.getInstanceNumber();
                    if (nubmer1 == -1 && nubmer2 == -1) {
                        int length2;
                        String str1 = dcm1.getSopInstanceUID();
                        String str2 = dcm2.getSopInstanceUID();
                        int length1 = str1.length();
                        if (length1 < (length2 = str2.length())) {
                            char[] c = new char[length2 - length1];
                            for (int i = 0; i < c.length; ++i) {
                                c[i] = 48;
                            }
                            int index = str1.lastIndexOf(".") + 1;
                            str1 = str1.substring(0, index) + new String(c) + str1.substring(index);
                        } else if (length1 > length2) {
                            char[] c = new char[length1 - length2];
                            for (int i = 0; i < c.length; ++i) {
                                c[i] = 48;
                            }
                            int index = str2.lastIndexOf(".") + 1;
                            str2 = str2.substring(0, index) + new String(c) + str2.substring(index);
                        }
                        return str1.compareTo(str2);
                    }
                    return nubmer1 < nubmer2 ? -1 : (nubmer1 == nubmer2 ? 0 : 1);
                }
            });
            final DicomInstance instance = (DicomInstance)sopList.get(sopList.size() / 2);
            Runnable thumbnailLoader = new Runnable(){

                @Override
                public void run() {
                    String studyUID = "";
                    String seriesUID = "";
                    if (!wadoParameters.isRequireOnlySOPInstanceUID()) {
                        MediaSeriesGroup study = LoadSeries.this.dicomModel.getParent((MediaSeriesGroup)LoadSeries.this.dicomSeries, DicomModel.study);
                        studyUID = (String)study.getTagValue(TagW.StudyInstanceUID);
                        seriesUID = (String)LoadSeries.this.dicomSeries.getTagValue(TagW.SeriesInstanceUID);
                    }
                    File file = null;
                    if (instance.getDirectDownloadFile() == null) {
                        try {
                            file = LoadSeries.this.getJPEGThumnails(wadoParameters, studyUID, seriesUID, instance.getSopInstanceUID());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (file != null) {
                        final File finalfile = file;
                        GuiExecutor.instance().execute(new Runnable(){

                            @Override
                            public void run() {
                                Thumbnail thumbnail = (Thumbnail)LoadSeries.this.dicomSeries.getTagValue(TagW.Thumbnail);
                                if (thumbnail == null) {
                                    thumbnail = new Thumbnail((MediaSeries)LoadSeries.this.dicomSeries, finalfile, 112);
                                }
                                if (LoadSeries.this.isDone()) {
                                    thumbnail.setProgressBar(null);
                                    thumbnail.repaint();
                                } else {
                                    thumbnail.setProgressBar(LoadSeries.this.progressBar);
                                }
                                LoadSeries.addListenerToThumbnail(thumbnail, LoadSeries.this, LoadSeries.this.dicomModel);
                                thumbnail.registerListeners();
                                LoadSeries.this.dicomSeries.setTag(TagW.Thumbnail, (Object)thumbnail);
                            }
                        });
                    }
                    LoadSeries.this.dicomModel.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Add, (Object)LoadSeries.this.dicomModel, null, (Object)LoadSeries.this.dicomSeries));
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            };
            executor.submit(thumbnailLoader);
        }
    }

    public static void removeAnonymousMouseAndKeyListener(Thumbnail tumbnail) {
        int i;
        MouseListener[] listener = tumbnail.getMouseListeners();
        MouseMotionListener[] motionListeners = tumbnail.getMouseMotionListeners();
        KeyListener[] keyListeners = tumbnail.getKeyListeners();
        MouseWheelListener[] wheelListeners = tumbnail.getMouseWheelListeners();
        for (i = 0; i < listener.length; ++i) {
            if (!listener[i].getClass().isAnonymousClass()) continue;
            tumbnail.removeMouseListener(listener[i]);
        }
        for (i = 0; i < motionListeners.length; ++i) {
            if (!motionListeners[i].getClass().isAnonymousClass()) continue;
            tumbnail.removeMouseMotionListener(motionListeners[i]);
        }
        for (i = 0; i < wheelListeners.length; ++i) {
            if (!wheelListeners[i].getClass().isAnonymousClass()) continue;
            tumbnail.removeMouseWheelListener(wheelListeners[i]);
        }
        for (i = 0; i < keyListeners.length; ++i) {
            if (!keyListeners[i].getClass().isAnonymousClass()) continue;
            tumbnail.removeKeyListener(keyListeners[i]);
        }
    }

    private static void addListenerToThumbnail(Thumbnail thumbnail, LoadSeries loadSeries, DicomModel dicomModel) {
        Series series = loadSeries.getDicomSeries();
        thumbnail.addMouseListener((MouseListener)DicomExplorer.createThumbnailMouseAdapter(series, dicomModel, loadSeries));
        thumbnail.addKeyListener((KeyListener)DicomExplorer.createThumbnailKeyListener(series, dicomModel));
    }

    public static void openSequenceInPlugin(SeriesViewerFactory factory, List<MediaSeries> series, DicomModel dicomModel, boolean removeOldSeries) {
        if (factory == null) {
            return;
        }
        dicomModel.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Register, (Object)dicomModel, null, (Object)new ViewerPluginBuilder(factory, series, (DataExplorerModel)dicomModel, true, removeOldSeries)));
    }

    public static void openSequenceInDefaultPlugin(List<MediaSeries> series, DicomModel dicomModel) {
        ArrayList<String> mimes = new ArrayList<String>();
        for (MediaSeries s : series) {
            String mime = s.getMimeType();
            if (mime == null || mimes.contains(mime)) continue;
            mimes.add(mime);
        }
        for (String mime : mimes) {
            SeriesViewerFactory plugin = UIManager.getViewerFactory((String)mime);
            if (plugin == null) continue;
            ArrayList<MediaSeries> seriesList = new ArrayList<MediaSeries>();
            for (MediaSeries s : series) {
                if (!mime.equals(s.getMimeType())) continue;
                seriesList.add(s);
            }
            LoadSeries.openSequenceInPlugin(plugin, seriesList, dicomModel, true);
        }
    }

    public Series getDicomSeries() {
        return this.dicomSeries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getJPEGThumnails(WadoParameters wadoParameters, String StudyUID, String SeriesUID, String SOPInstanceUID) throws Exception {
        URL url = new URL(wadoParameters.getWadoURL() + "?requestType=WADO&studyUID=" + StudyUID + "&seriesUID=" + SeriesUID + "&objectUID=" + SOPInstanceUID + "&contentType=image/jpeg&imageQuality=70" + "&rows=" + 256 + "&columns=" + 256 + wadoParameters.getAdditionnalParameters());
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setDoInput(true);
        httpCon.setRequestMethod("GET");
        if (wadoParameters.getWebLogin() != null) {
            httpCon.setRequestProperty("Authorization", "Basic " + wadoParameters.getWebLogin());
        }
        if (wadoParameters.getHttpTaglist().size() > 0) {
            for (WadoParameters.HttpTag tag : wadoParameters.getHttpTaglist()) {
                httpCon.setRequestProperty(tag.getKey(), tag.getValue());
            }
        }
        httpCon.connect();
        if (httpCon.getResponseCode() / 100 != 2) {
            return null;
        }
        BufferedOutputStream out = null;
        InputStream in = null;
        File outFile = File.createTempFile("tumb_", ".jpg", AbstractProperties.APP_TEMP_DIR);
        try {
            int numRead;
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            in = httpCon.getInputStream();
            byte[] buffer = new byte[1024];
            long numWritten = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, numRead);
                numWritten += (long)numRead;
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(in);
                FileUtil.safeClose(out);
                throw throwable;
            }
            FileUtil.safeClose(in);
            FileUtil.safeClose((Closeable)out);
        }
        FileUtil.safeClose((Closeable)in);
        FileUtil.safeClose((Closeable)out);
        return outFile;
    }

    private int[] generateDownladOrder(int size) {
        int k;
        int[] dindex = new int[size];
        if (size < 4) {
            for (int i = 0; i < dindex.length; ++i) {
                dindex[i] = i;
            }
            return dindex;
        }
        boolean[] map = new boolean[size];
        int pos = 0;
        dindex[pos++] = 0;
        map[0] = true;
        dindex[pos++] = size - 1;
        map[size - 1] = true;
        dindex[pos++] = k;
        map[k] = true;
        for (k = (size - 1) / 2; k > 0; k /= 2) {
            int start = 0;
            for (int i = 1; i < map.length; ++i) {
                if (!map[i]) continue;
                if (!map[i - 1]) {
                    int mid = start + (i - start) / 2;
                    map[mid] = true;
                    dindex[pos++] = mid;
                }
                start = i;
            }
        }
        return dindex;
    }

    public synchronized DownloadPriority getPriority() {
        return this.priority;
    }

    public synchronized void setPriority(DownloadPriority priority) {
        this.priority = priority;
    }

    public void setPriority() {
        boolean change;
        DownloadPriority p = this.getPriority();
        if (p != null && SwingWorker.StateValue.PENDING.equals((Object)this.getState()) && (change = LoadRemoteDicomManifest.loadingQueue.remove(this))) {
            p.setPriority(DownloadPriority.COUNTER.getAndDecrement());
            LoadRemoteDicomManifest.loadingQueue.offer(this);
            for (LoadSeries s : LoadRemoteDicomManifest.currentTasks) {
                if (s == this || !SwingWorker.StateValue.STARTED.equals((Object)s.getState())) continue;
                LoadSeries taskResume = new LoadSeries(s.getDicomSeries(), this.dicomModel, s.getProgressBar());
                s.cancel(true);
                taskResume.setPriority(s.getPriority());
                Thumbnail thumbnail = (Thumbnail)s.getDicomSeries().getTagValue(TagW.Thumbnail);
                if (thumbnail != null) {
                    LoadSeries.removeAnonymousMouseAndKeyListener(thumbnail);
                    LoadSeries.addListenerToThumbnail(thumbnail, taskResume, this.dicomModel);
                }
                LoadRemoteDicomManifest.loadingQueue.offer(taskResume);
                break;
            }
        }
    }

    static {
        try {
            DICOM_TMP_DIR.mkdirs();
            DICOM_EXPORT_DIR.mkdir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        executor = Executors.newFixedThreadPool(3);
    }

    class Download
    implements Callable<Boolean> {
        private final URL url;
        private int size;
        private int downloaded;
        private Status status;
        private File tempFile;
        private final WadoParameters wadoParameters;

        public Download(URL url, WadoParameters wadoParameters) {
            this.url = url;
            this.wadoParameters = wadoParameters;
            this.size = -1;
            this.downloaded = 0;
            this.status = Status.Downloading;
        }

        public File getTempFile() {
            return this.tempFile;
        }

        public String getUrl() {
            return this.url.toString();
        }

        public int getSize() {
            return this.size;
        }

        public float getProgress() {
            return (float)this.downloaded / (float)this.size * 100.0f;
        }

        public Status getStatus() {
            return this.status;
        }

        public void pause() {
            this.status = Status.Paused;
        }

        public void resume() {
            this.status = Status.Downloading;
        }

        public void cancel() {
            this.status = Status.Cancelled;
        }

        private void error() {
            this.status = Status.Error;
        }

        @Override
        public Boolean call() throws Exception {
            int responseCode;
            InputStream stream = null;
            URLConnection httpCon = null;
            try {
                httpCon = this.url.openConnection();
                if (this.wadoParameters.getWebLogin() != null) {
                    httpCon.setRequestProperty("Authorization", "Basic " + this.wadoParameters.getWebLogin());
                }
                if (this.wadoParameters.getHttpTaglist().size() > 0) {
                    for (WadoParameters.HttpTag tag : this.wadoParameters.getHttpTaglist()) {
                        httpCon.setRequestProperty(tag.getKey(), tag.getValue());
                    }
                }
                httpCon.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
                httpCon.connect();
            }
            catch (IOException e) {
                this.error();
                log.error("IOException for {}: {} ", (Object)this.url, (Object)e.getMessage());
                return false;
            }
            if (httpCon instanceof HttpURLConnection && (responseCode = ((HttpURLConnection)httpCon).getResponseCode()) / 100 != 2) {
                this.error();
                log.error("Http Response error {} for {}", (Object)responseCode, (Object)this.url);
                return false;
            }
            if (this.tempFile == null) {
                this.tempFile = File.createTempFile("image_", ".dcm", DICOM_TMP_DIR);
            }
            stream = httpCon.getInputStream();
            int contentLength = httpCon.getContentLength();
            contentLength = -1;
            if (contentLength == -1) {
                LoadSeries.this.progressBar.setIndeterminate(LoadSeries.this.progressBar.getMaximum() < 3);
            }
            if (this.size == -1) {
                this.size = contentLength;
            }
            DicomMediaIO dicomReader = null;
            log.debug("Download DICOM instance {} to {}.", (Object)this.url, (Object)this.tempFile.getName());
            if (LoadSeries.this.dicomSeries != null) {
                WadoParameters wado = (WadoParameters)LoadSeries.this.dicomSeries.getTagValue(TagW.WadoParameters);
                int[] overrideList = wado.getOverrideDicomTagIDList();
                int bytesTransferred = 0;
                if (overrideList == null && wado != null) {
                    bytesTransferred = FileUtil.writeFile((InputStream)new SeriesProgressMonitor(LoadSeries.this.dicomSeries, stream), (OutputStream)new FileOutputStream(this.tempFile));
                } else if (wado != null) {
                    bytesTransferred = this.writFile((InputStream)new SeriesProgressMonitor(LoadSeries.this.dicomSeries, stream), new FileOutputStream(this.tempFile), overrideList);
                }
                if (bytesTransferred >= 0) {
                    log.warn("Download interruption {} ", (Object)this.url);
                    try {
                        this.tempFile.delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return false;
                }
                File renameFile = new File(DICOM_EXPORT_DIR, this.tempFile.getName());
                if (this.tempFile.renameTo(renameFile)) {
                    this.tempFile = renameFile;
                }
                if ((dicomReader = new DicomMediaIO(this.tempFile)).readMediaTags() && LoadSeries.this.dicomSeries.size() == 0) {
                    dicomReader.writeMetaData((MediaSeriesGroup)LoadSeries.this.dicomSeries);
                    MediaSeriesGroup study = LoadSeries.this.dicomModel.getParent((MediaSeriesGroup)LoadSeries.this.dicomSeries, DicomModel.study);
                    dicomReader.writeMetaData(study);
                    MediaSeriesGroup patient = LoadSeries.this.dicomModel.getParent((MediaSeriesGroup)LoadSeries.this.dicomSeries, DicomModel.patient);
                    dicomReader.writeMetaData(patient);
                    GuiExecutor.instance().invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Thumbnail thumb = (Thumbnail)LoadSeries.this.dicomSeries.getTagValue(TagW.Thumbnail);
                            if (thumb != null) {
                                thumb.repaint();
                            }
                            LoadSeries.this.dicomModel.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.UpdateParent, (Object)LoadSeries.this.dicomModel, null, (Object)LoadSeries.this.dicomSeries));
                        }
                    });
                }
            }
            if (this.status == Status.Downloading) {
                this.status = Status.Complete;
                if (this.tempFile != null && LoadSeries.this.dicomSeries != null && dicomReader.readMediaTags()) {
                    final DicomMediaIO reader = dicomReader;
                    GuiExecutor.instance().invokeAndWait(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            boolean firstImageToDisplay = false;
                            MediaElement[] medias = reader.getMediaElement();
                            if (medias != null) {
                                firstImageToDisplay = LoadSeries.this.dicomSeries.size() == 0;
                                for (Object media : medias) {
                                    LoadSeries.this.dicomModel.applySplittingRules(LoadSeries.this.dicomSeries, (MediaElement)media);
                                }
                                if (firstImageToDisplay && LoadSeries.this.dicomSeries.size() == 0) {
                                    firstImageToDisplay = false;
                                }
                            }
                            reader.reset();
                            Thumbnail thumb = (Thumbnail)LoadSeries.this.dicomSeries.getTagValue(TagW.Thumbnail);
                            if (thumb != null) {
                                thumb.repaint();
                            }
                            if (firstImageToDisplay) {
                                SeriesViewerFactory plugin;
                                boolean openNewTab = true;
                                MediaSeriesGroup entry1 = LoadSeries.this.dicomModel.getParent((MediaSeriesGroup)LoadSeries.this.dicomSeries, DicomModel.patient);
                                if (entry1 != null) {
                                    Object media;
                                    media = UIManager.VIEWER_PLUGINS;
                                    synchronized (media) {
                                        for (ViewerPlugin p : UIManager.VIEWER_PLUGINS) {
                                            if (!entry1.equals(p.getGroupID())) continue;
                                            openNewTab = false;
                                            break;
                                        }
                                    }
                                }
                                if (openNewTab && (plugin = UIManager.getViewerFactory((String)LoadSeries.this.dicomSeries.getMimeType())) != null && !(plugin instanceof MimeSystemAppFactory)) {
                                    ArrayList<MediaSeries> list = new ArrayList<MediaSeries>(1);
                                    list.add((MediaSeries)LoadSeries.this.dicomSeries);
                                    LoadSeries.openSequenceInPlugin(plugin, list, LoadSeries.this.dicomModel, true);
                                }
                            }
                        }
                    });
                }
            }
            LoadSeries.this.incrementProgressBarValue();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public int writFile(InputStream inputStream, OutputStream out, int[] overrideList) {
            int n;
            if (inputStream == null && out == null) {
                return 0;
            }
            DicomInputStream dis = null;
            DicomOutputStream dos = null;
            try {
                dis = new DicomInputStream((InputStream)new BufferedInputStream(inputStream));
                DicomObject dcm = dis.readDicomObject();
                dos = new DicomOutputStream((OutputStream)new BufferedOutputStream(out));
                if (overrideList != null) {
                    MediaSeriesGroup study = LoadSeries.this.dicomModel.getParent((MediaSeriesGroup)LoadSeries.this.dicomSeries, DicomModel.study);
                    MediaSeriesGroup patient = LoadSeries.this.dicomModel.getParent((MediaSeriesGroup)LoadSeries.this.dicomSeries, DicomModel.patient);
                    VRMap vrMap = VRMap.getVRMap();
                    for (int tag : overrideList) {
                        TagW tagElement = patient.getTagElement(tag);
                        Object value = null;
                        if (tagElement == null) {
                            tagElement = study.getTagElement(tag);
                            value = study.getTagValue(tagElement);
                        } else {
                            value = patient.getTagValue(tagElement);
                        }
                        if (value == null) continue;
                        TagW.TagType type = tagElement.getType();
                        if (TagW.TagType.String.equals((Object)type)) {
                            dcm.putString(tag, vrMap.vrOf(tag), value.toString());
                            continue;
                        }
                        if (TagW.TagType.Date.equals((Object)type) || TagW.TagType.Time.equals((Object)type)) {
                            dcm.putDate(tag, vrMap.vrOf(tag), (Date)value);
                            continue;
                        }
                        if (TagW.TagType.Integer.equals((Object)type)) {
                            dcm.putInt(tag, vrMap.vrOf(tag), ((Integer)value).intValue());
                            continue;
                        }
                        if (!TagW.TagType.Float.equals((Object)type)) continue;
                        dcm.putFloat(tag, vrMap.vrOf(tag), ((Float)value).floatValue());
                    }
                }
                dos.writeDicomFile(dcm);
                n = -1;
            }
            catch (InterruptedIOException e) {
                int n2 = e.bytesTransferred;
                FileUtil.safeClose(dos);
                FileUtil.safeClose((Closeable)dis);
                return n2;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                int n3 = 0;
                {
                    catch (Throwable throwable) {
                        FileUtil.safeClose(dos);
                        FileUtil.safeClose(dis);
                        throw throwable;
                    }
                }
                FileUtil.safeClose(dos);
                FileUtil.safeClose((Closeable)dis);
                return n3;
            }
            FileUtil.safeClose((Closeable)dos);
            FileUtil.safeClose((Closeable)dis);
            return n;
        }
    }

    public static enum Status {
        Downloading,
        Paused,
        Complete,
        Cancelled,
        Error;

    }
}

