/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer.pref;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.weasis.core.api.gui.util.AbstractItemDialogPage;
import org.weasis.core.api.media.data.TagW;
import org.weasis.dicom.codec.InfoViewElementPanel;
import org.weasis.dicom.codec.display.CornerDisplay;
import org.weasis.dicom.codec.display.CornerInfoData;
import org.weasis.dicom.codec.display.Modality;
import org.weasis.dicom.codec.display.ModalityInfoData;
import org.weasis.dicom.explorer.Messages;

public class ModalityPrefView
extends AbstractItemDialogPage
implements DragGestureListener {
    public static final HashMap<Integer, TagW> tagList = new HashMap();
    private JList list;
    private DragSource ds;
    private JComboBox cornercomboBox;
    private JComboBox modalitycomboBox;
    private JList jListPosition;
    private JScrollPane scrollPane_1;
    private static ModalityInfoData[] infos;
    private final InfoViewElementPanel cornerView = new InfoViewElementPanel();
    private final transient ItemListener changeViewListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ModalityPrefView.this.changCornerView();
            }
        }
    };

    public ModalityPrefView() {
        this.setTitle(Messages.getString("ModalityPrefView.annotations"));
        this.initNorthPanel();
        this.initGUI();
        this.jListPosition.setListData(new Vector<TagW>(tagList.values()));
        this.changCornerView();
    }

    private static void fillMap(TagW tag) {
        tagList.put(tag.getId(), tag);
    }

    public void initGUI() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.jListPosition = new JList();
        this.jListPosition.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jListPosition.setSelectionMode(0);
        this.ds = new DragSource();
        this.ds.createDefaultDragGestureRecognizer(this.jListPosition, 1, this);
        JPanel panel_corner = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        panel_corner.setLayout(flowLayout);
        this.add(panel_corner);
        JLabel cornerLabel = new JLabel();
        cornerLabel.setText(Messages.getString("ModalityPrefView.corner"));
        panel_corner.add(cornerLabel);
        this.cornercomboBox = new JComboBox<CornerDisplay>(CornerDisplay.values());
        this.cornercomboBox.addItemListener(this.changeViewListener);
        panel_corner.add(this.cornercomboBox);
        JPanel panel_1 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel_1.setLayout(gridBagLayout);
        this.add(panel_1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        panel_1.add((Component)this.cornerView, gridBagConstraints);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.scrollPane_1 = new JScrollPane();
        this.scrollPane_1.setPreferredSize(new Dimension(70, 30));
        GridBagConstraints gridBagConstraints_1 = new GridBagConstraints();
        gridBagConstraints_1.weighty = 1.0;
        gridBagConstraints_1.weightx = 0.5;
        gridBagConstraints_1.fill = 1;
        gridBagConstraints_1.gridx = 1;
        gridBagConstraints_1.gridy = 0;
        this.scrollPane_1.setViewportView(this.jListPosition);
        tabbedPane.add(Messages.getString("ModalityPrefView.dcm_el"), this.scrollPane_1);
        panel_1.add((Component)tabbedPane, gridBagConstraints_1);
        JScrollPane scrollPane = new JScrollPane();
        tabbedPane.addTab(Messages.getString("ModalityPrefView.other_val"), null, scrollPane, null);
        this.list = new JList();
        scrollPane.setPreferredSize(new Dimension(70, 30));
        scrollPane.setViewportView(this.list);
        JButton propertiesButton = new JButton();
        propertiesButton.setText(Messages.getString("ModalityPrefView.prop"));
        GridBagConstraints gridBagConstraints_4 = new GridBagConstraints();
        gridBagConstraints_4.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints_4.gridy = 1;
        gridBagConstraints_4.gridx = 0;
        panel_1.add((Component)propertiesButton, gridBagConstraints_4);
        JButton jButtonFormat = new JButton();
        GridBagConstraints gridBagConstraints_3 = new GridBagConstraints();
        gridBagConstraints_3.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints_3.gridy = 1;
        gridBagConstraints_3.gridx = 1;
        panel_1.add((Component)jButtonFormat, gridBagConstraints_3);
        jButtonFormat.setText(Messages.getString("ModalityPrefView.format"));
        jButtonFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String result;
                TagW element = (TagW)ModalityPrefView.this.jListPosition.getSelectedValue();
                if (element != null && (result = JOptionPane.showInputDialog((Component)((Object)ModalityPrefView.this), element.getName(), element.getFormat())) != null) {
                    if (result.indexOf("$V") != -1) {
                        element.setFormat(result);
                    } else if (result.trim().equals("")) {
                        element.setFormat(null);
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)ModalityPrefView.this), Messages.getString("ModalityPrefView.not_valid"), Messages.getString("ModalityPrefView.disp_format"), 0);
                    }
                }
            }
        });
        jButtonFormat.setToolTipText(Messages.getString("ModalityPrefView.elem_disp"));
    }

    public void initNorthPanel() {
        JPanel panel_modality = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        panel_modality.setLayout(flowLayout);
        this.add(panel_modality);
        JLabel modalityLabel = new JLabel();
        modalityLabel.setText(Messages.getString("ModalityPrefView.template"));
        panel_modality.add(modalityLabel);
        this.modalitycomboBox = new JComboBox<ModalityInfoData>(ModalityPrefView.loadDefaultModalityDisplayPreferences());
        this.modalitycomboBox.addItemListener(this.changeViewListener);
        panel_modality.add(this.modalitycomboBox);
    }

    public static synchronized ModalityInfoData[] loadDefaultModalityDisplayPreferences() {
        if (infos == null) {
            TagW.PatientID.setFormat(Messages.getString("ModalityPrefView.id"));
            TagW.PatientSex.setFormat(Messages.getString("ModalityPrefView.sex"));
            TagW.StudyID.setFormat(Messages.getString("ModalityPrefView.study"));
            TagW.StudyDescription.setFormat(Messages.getString("ModalityPrefView.study_des"));
            TagW.AcquisitionDate.setFormat(Messages.getString("ModalityPrefView.acq"));
            TagW.AcquisitionTime.setFormat(Messages.getString("ModalityPrefView.acq"));
            TagW.SeriesNumber.setFormat(Messages.getString("ModalityPrefView.series_nb"));
            TagW.SeriesDescription.setFormat(Messages.getString("ModalityPrefView.series_desc"));
            TagW.SliceThickness.setFormat(Messages.getString("ModalityPrefView.thick"));
            TagW.SliceLocation.setFormat(Messages.getString("ModalityPrefView.location"));
            Modality[] modalities = Modality.values();
            infos = new ModalityInfoData[modalities.length - 1];
            for (int i = 0; i < infos.length; ++i) {
                ModalityPrefView.infos[i] = new ModalityInfoData(modalities[i + 1]);
                TagW[] disElements = infos[i].getCornerInfo(CornerDisplay.TOP_LEFT).getInfos();
                disElements[0] = TagW.PatientName;
                disElements[1] = TagW.PatientBirthDate;
                disElements[2] = TagW.PatientID;
                disElements[3] = TagW.PatientSex;
                disElements = infos[i].getCornerInfo(CornerDisplay.TOP_RIGHT).getInfos();
                disElements[0] = TagW.InstitutionName;
                disElements[1] = TagW.StudyID;
                disElements[2] = TagW.StudyDescription;
                disElements[3] = TagW.AcquisitionDate;
                disElements[4] = TagW.AcquisitionTime;
                disElements = infos[i].getCornerInfo(CornerDisplay.BOTTOM_RIGHT).getInfos();
                disElements[2] = TagW.SeriesNumber;
                disElements[3] = TagW.ContrastBolusAgent;
                disElements[4] = TagW.SeriesDescription;
                disElements[5] = TagW.SliceThickness;
                disElements[6] = TagW.SliceLocation;
            }
        }
        return infos;
    }

    public static ModalityInfoData getModlatityInfos(Modality mod) {
        if (infos == null) {
            ModalityPrefView.loadDefaultModalityDisplayPreferences();
        }
        for (int i = 0; i < infos.length; ++i) {
            if (!infos[i].getModality().equals((Object)mod)) continue;
            return infos[i];
        }
        return infos[0];
    }

    public void closeAdditionalWindow() {
    }

    public void resetoDefaultValues() {
    }

    public void changCornerView() {
        ModalityInfoData info = (ModalityInfoData)this.modalitycomboBox.getSelectedItem();
        if (info != null) {
            CornerInfoData corner = info.getCornerInfo((CornerDisplay)this.cornercomboBox.getSelectedItem());
            this.cornerView.setCorner(corner);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Component component = dge.getComponent();
        TagW t = null;
        if (component instanceof JList) {
            t = (TagW)((JList)component).getSelectedValue();
        }
        if (t != null) {
            try {
                dge.startDrag(null, (Transferable)t, null);
                return;
            }
            catch (RuntimeException re) {
                // empty catch block
            }
        }
    }

    public static TagW getInfoElement(int id) {
        return tagList.get(id);
    }

    static {
        ModalityPrefView.fillMap(TagW.PatientID);
        ModalityPrefView.fillMap(TagW.PatientName);
        ModalityPrefView.fillMap(TagW.PatientBirthDate);
        ModalityPrefView.fillMap(TagW.PatientBirthTime);
        ModalityPrefView.fillMap(TagW.PatientSex);
        ModalityPrefView.fillMap(TagW.IssuerOfPatientID);
        ModalityPrefView.fillMap(TagW.PatientComments);
        ModalityPrefView.fillMap(TagW.StudyID);
        ModalityPrefView.fillMap(TagW.StudyDate);
        ModalityPrefView.fillMap(TagW.StudyTime);
        ModalityPrefView.fillMap(TagW.StudyDescription);
        ModalityPrefView.fillMap(TagW.AccessionNumber);
        ModalityPrefView.fillMap(TagW.ModalitiesInStudy);
        ModalityPrefView.fillMap(TagW.NumberOfStudyRelatedInstances);
        ModalityPrefView.fillMap(TagW.NumberOfStudyRelatedSeries);
        ModalityPrefView.fillMap(TagW.StudyStatusID);
        ModalityPrefView.fillMap(TagW.ProcedureCodeSequence);
        ModalityPrefView.fillMap(TagW.SeriesInstanceUID);
        ModalityPrefView.fillMap(TagW.Modality);
        ModalityPrefView.fillMap(TagW.SeriesDate);
        ModalityPrefView.fillMap(TagW.SeriesDescription);
        ModalityPrefView.fillMap(TagW.RetrieveAETitle);
        ModalityPrefView.fillMap(TagW.ReferringPhysicianName);
        ModalityPrefView.fillMap(TagW.InstitutionName);
        ModalityPrefView.fillMap(TagW.InstitutionalDepartmentName);
        ModalityPrefView.fillMap(TagW.StationName);
        ModalityPrefView.fillMap(TagW.Manufacturer);
        ModalityPrefView.fillMap(TagW.ManufacturerModelName);
        ModalityPrefView.fillMap(TagW.ReferencedPerformedProcedureStepSequence);
        ModalityPrefView.fillMap(TagW.SeriesNumber);
        ModalityPrefView.fillMap(TagW.PreferredPlaybackSequencing);
        ModalityPrefView.fillMap(TagW.CineRate);
        ModalityPrefView.fillMap(TagW.Laterality);
        ModalityPrefView.fillMap(TagW.BodyPartExamined);
        ModalityPrefView.fillMap(TagW.NumberOfSeriesRelatedInstances);
        ModalityPrefView.fillMap(TagW.PerformedProcedureStepStartDate);
        ModalityPrefView.fillMap(TagW.PerformedProcedureStepStartTime);
        ModalityPrefView.fillMap(TagW.RequestAttributesSequence);
        ModalityPrefView.fillMap(TagW.ImageType);
        ModalityPrefView.fillMap(TagW.ImageComments);
        ModalityPrefView.fillMap(TagW.ContrastBolusAgent);
        ModalityPrefView.fillMap(TagW.TransferSyntaxUID);
        ModalityPrefView.fillMap(TagW.InstanceNumber);
        ModalityPrefView.fillMap(TagW.SOPInstanceUID);
        ModalityPrefView.fillMap(TagW.SOPClassUID);
        ModalityPrefView.fillMap(TagW.ScanningSequence);
        ModalityPrefView.fillMap(TagW.SequenceVariant);
        ModalityPrefView.fillMap(TagW.ScanOptions);
        ModalityPrefView.fillMap(TagW.RepetitionTime);
        ModalityPrefView.fillMap(TagW.EchoTime);
        ModalityPrefView.fillMap(TagW.InversionTime);
        ModalityPrefView.fillMap(TagW.EchoNumbers);
        ModalityPrefView.fillMap(TagW.GantryDetectorTilt);
        ModalityPrefView.fillMap(TagW.ConvolutionKernel);
        ModalityPrefView.fillMap(TagW.FlipAngle);
        ModalityPrefView.fillMap(TagW.SliceLocation);
        ModalityPrefView.fillMap(TagW.SliceThickness);
        ModalityPrefView.fillMap(TagW.AcquisitionDate);
        ModalityPrefView.fillMap(TagW.AcquisitionTime);
        ModalityPrefView.fillMap(TagW.ImagePositionPatient);
        ModalityPrefView.fillMap(TagW.ImageOrientationPatient);
        ModalityPrefView.fillMap(TagW.ImageOrientationPlane);
        ModalityPrefView.fillMap(TagW.PixelSpacing);
        ModalityPrefView.fillMap(TagW.WindowWidth);
        ModalityPrefView.fillMap(TagW.WindowCenter);
        ModalityPrefView.fillMap(TagW.RescaleSlope);
        ModalityPrefView.fillMap(TagW.RescaleIntercept);
        ModalityPrefView.fillMap(TagW.SmallestImagePixelValue);
        ModalityPrefView.fillMap(TagW.LargestImagePixelValue);
        ModalityPrefView.fillMap(TagW.PixelPaddingValue);
        ModalityPrefView.fillMap(TagW.NumberOfFrames);
        ModalityPrefView.fillMap(TagW.PixelPaddingRangeLimit);
        ModalityPrefView.fillMap(TagW.OverlayRows);
        ModalityPrefView.fillMap(TagW.SamplesPerPixel);
        ModalityPrefView.fillMap(TagW.MonoChrome);
        ModalityPrefView.fillMap(TagW.PhotometricInterpretation);
        ModalityPrefView.fillMap(TagW.Rows);
        ModalityPrefView.fillMap(TagW.Columns);
        ModalityPrefView.fillMap(TagW.BitsAllocated);
        ModalityPrefView.fillMap(TagW.BitsStored);
        ModalityPrefView.fillMap(TagW.PixelRepresentation);
        infos = null;
    }
}

