/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.explorer.ObservableEvent;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.explorer.model.TreeModel;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.api.media.MimeInspector;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.MediaSeriesGroupNode;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.media.data.Thumbnail;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.SeriesViewerFactory;
import org.weasis.dicom.codec.DicomMediaIO;
import org.weasis.dicom.explorer.DicomExplorer;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.Messages;
import org.weasis.dicom.explorer.MimeSystemAppFactory;
import org.weasis.dicom.explorer.wado.LoadSeries;

public class LoadLocalDicom
extends SwingWorker<Boolean, String> {
    private static final Logger log = LoggerFactory.getLogger(LoadLocalDicom.class);
    private final File[] files;
    private final DicomModel dicomModel;
    private final boolean recursive;
    private boolean openPlugin;
    private final boolean flatSearch;
    private JProgressBar progressBar = null;

    public LoadLocalDicom(File[] files, boolean recursive, DataExplorerModel explorerModel, boolean flatSearch) {
        if (files == null || !(explorerModel instanceof DicomModel)) {
            throw new IllegalArgumentException("invalid parameters");
        }
        this.dicomModel = (DicomModel)explorerModel;
        this.files = files;
        this.recursive = recursive;
        this.openPlugin = true;
        this.flatSearch = flatSearch;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setProgressBar(JProgressBar progressBar) {
        this.progressBar = progressBar;
        if (progressBar != null) {
            progressBar.setIndeterminate(true);
            progressBar.setStringPainted(true);
        }
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        this.addSelectionAndnotify(this.files, true);
        return true;
    }

    @Override
    protected void done() {
        if (this.progressBar != null) {
            this.progressBar.setIndeterminate(false);
        }
        this.writeInfo(Messages.getString("LoadLocalDicom.end"));
    }

    private void writeInfo(String text) {
        if (this.progressBar != null) {
            this.progressBar.setString(text);
        }
        log.info(text);
    }

    public void addSelectionAndnotify(File[] file, boolean firstLevel) {
        if (file == null || file.length < 1) {
            return;
        }
        ArrayList<Thumbnail> thumbs = new ArrayList<Thumbnail>();
        ArrayList<File> folders = new ArrayList<File>();
        for (int i = 0; i < file.length; ++i) {
            Thumbnail t;
            DicomMediaIO loader;
            if (file[i].isDirectory()) {
                if (!firstLevel && !this.recursive) continue;
                folders.add(file[i]);
                continue;
            }
            if (!file[i].canRead()) continue;
            String mime = null;
            try {
                mime = MimeInspector.getMimeType((File)file[i]);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!"application/dicom".equals(mime) || !(loader = new DicomMediaIO(file[i])).readMediaTags() || (t = this.buildDicomStructure(loader, this.openPlugin)) == null) continue;
            thumbs.add(t);
        }
        for (final Thumbnail t : thumbs) {
            MediaSeries series = t.getSeries();
            if (series == null || series.getMedias().size() <= 2) continue;
            GuiExecutor.instance().execute(new Runnable(){

                @Override
                public void run() {
                    t.reBuildThumbnail();
                }
            });
        }
        for (int i = 0; i < folders.size(); ++i) {
            this.addSelectionAndnotify(((File)folders.get(i)).listFiles(), false);
        }
    }

    public void addSelection(File[] file, boolean firstLevel) {
        boolean hasImages;
        if (file == null || file.length < 1) {
            return;
        }
        ArrayList<DicomMediaIO> files = new ArrayList<DicomMediaIO>();
        ArrayList<File> folders = new ArrayList<File>();
        for (int i = 0; i < file.length; ++i) {
            DicomMediaIO loader;
            if (file[i].isDirectory()) {
                if (!firstLevel && !this.recursive) continue;
                folders.add(file[i]);
                continue;
            }
            if (!file[i].canRead()) continue;
            String mime = null;
            try {
                mime = MimeInspector.getMimeType((File)file[i]);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!"application/dicom".equals(mime) || !(loader = new DicomMediaIO(file[i])).readMediaTags()) continue;
            files.add(loader);
        }
        boolean bl = hasImages = files.size() > 0;
        if (hasImages) {
            this.buildDicomStructure(files, this.openPlugin & hasImages);
        }
        for (int i = 0; i < folders.size(); ++i) {
            this.addSelection(((File)folders.get(i)).listFiles(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thumbnail buildDicomStructure(DicomMediaIO dicomReader, boolean open) {
        String studyUID;
        MediaSeriesGroup study;
        Thumbnail thumb = null;
        String patientPseudoUID = (String)dicomReader.getTagValue(TagW.PatientPseudoUID);
        MediaSeriesGroup patient = this.dicomModel.getHierarchyNode(TreeModel.rootNode, patientPseudoUID);
        if (patient == null) {
            patient = new MediaSeriesGroupNode(TagW.PatientPseudoUID, (Object)patientPseudoUID, TagW.PatientName);
            dicomReader.writeMetaData(patient);
            this.dicomModel.addHierarchyNode(TreeModel.rootNode, patient);
            this.writeInfo(Messages.getString("LoadLocalDicom.add_pat") + patient);
        }
        if ((study = this.dicomModel.getHierarchyNode(patient, studyUID = (String)dicomReader.getTagValue(TagW.StudyInstanceUID))) == null) {
            study = new MediaSeriesGroupNode(TagW.StudyInstanceUID, (Object)studyUID, TagW.StudyDate);
            dicomReader.writeMetaData(study);
            this.dicomModel.addHierarchyNode(patient, study);
        }
        String seriesUID = (String)dicomReader.getTagValue(TagW.SeriesInstanceUID);
        Series dicomSeries = (Series)this.dicomModel.getHierarchyNode(study, seriesUID);
        try {
            if (dicomSeries == null) {
                SeriesViewerFactory plugin;
                Thumbnail t;
                dicomSeries = dicomReader.buildSeries(seriesUID);
                dicomSeries.setTag(TagW.ExplorerModel, (Object)this.dicomModel);
                dicomReader.writeMetaData((MediaSeriesGroup)dicomSeries);
                this.dicomModel.addHierarchyNode(study, (MediaSeriesGroup)dicomSeries);
                MediaElement[] medias = dicomReader.getMediaElement();
                if (medias != null) {
                    for (MediaElement media : medias) {
                        dicomSeries.setFileSize(dicomSeries.getFileSize() + (double)media.getLength());
                        this.dicomModel.applySplittingRules(dicomSeries, media);
                    }
                }
                if ((t = (Thumbnail)dicomSeries.getTagValue(TagW.Thumbnail)) == null) {
                    t = DicomExplorer.createThumbnail(dicomSeries, this.dicomModel, 112);
                    dicomSeries.setTag(TagW.Thumbnail, (Object)t);
                }
                this.dicomModel.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Add, (Object)this.dicomModel, null, (Object)dicomSeries));
                thumb = t;
                Integer splitNb = (Integer)dicomSeries.getTagValue(TagW.SplitSeriesNumber);
                Object dicomObject = dicomSeries.getTagValue(TagW.DicomSpecialElement);
                if (splitNb != null || dicomObject != null) {
                    this.dicomModel.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Update, (Object)this.dicomModel, null, (Object)dicomSeries));
                }
                if (open && (plugin = UIManager.getViewerFactory((String)dicomSeries.getMimeType())) != null && !(plugin instanceof MimeSystemAppFactory)) {
                    this.openPlugin = false;
                    ArrayList<MediaSeries> list = new ArrayList<MediaSeries>(1);
                    list.add((MediaSeries)dicomSeries);
                    LoadSeries.openSequenceInPlugin(plugin, list, this.dicomModel, true);
                }
            } else {
                MediaElement[] medias = dicomReader.getMediaElement();
                if (medias != null) {
                    Thumbnail t;
                    for (MediaElement media : medias) {
                        dicomSeries.setFileSize(dicomSeries.getFileSize() + (double)media.getLength());
                        this.dicomModel.applySplittingRules(dicomSeries, media);
                    }
                    if (medias.length > 0 && (t = (Thumbnail)dicomSeries.getTagValue(TagW.Thumbnail)) != null) {
                        t.repaint();
                    }
                    Integer splitNb = (Integer)dicomSeries.getTagValue(TagW.SplitSeriesNumber);
                    Object dicomObject = dicomSeries.getTagValue(TagW.DicomSpecialElement);
                    if (splitNb != null || dicomObject != null) {
                        this.dicomModel.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Update, (Object)this.dicomModel, null, (Object)dicomSeries));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            dicomReader.reset();
        }
        return thumb;
    }

    private void buildDicomStructure(ArrayList<DicomMediaIO> seriesList, boolean open) {
        Series series;
        SeriesViewerFactory plugin;
        ArrayList<Series> dicomseriesList = new ArrayList<Series>();
        for (DicomMediaIO dicomReader : seriesList) {
            String studyUID;
            MediaSeriesGroup study;
            String patientPseudoUID = (String)dicomReader.getTagValue(TagW.PatientPseudoUID);
            MediaSeriesGroup patient = this.dicomModel.getHierarchyNode(TreeModel.rootNode, patientPseudoUID);
            if (patient == null) {
                patient = new MediaSeriesGroupNode(TagW.PatientPseudoUID, (Object)patientPseudoUID, TagW.PatientName);
                dicomReader.writeMetaData(patient);
                this.dicomModel.addHierarchyNode(TreeModel.rootNode, patient);
                this.writeInfo(Messages.getString("LoadLocalDicom.add_pat") + patient);
            }
            if ((study = this.dicomModel.getHierarchyNode(patient, studyUID = (String)dicomReader.getTagValue(TagW.StudyInstanceUID))) == null) {
                study = new MediaSeriesGroupNode(TagW.StudyInstanceUID, (Object)studyUID, TagW.StudyDate);
                dicomReader.writeMetaData(study);
                this.dicomModel.addHierarchyNode(patient, study);
            }
            String seriesUID = (String)dicomReader.getTagValue(TagW.SeriesInstanceUID);
            Series dicomSeries = (Series)this.dicomModel.getHierarchyNode(study, seriesUID);
            try {
                MediaElement[] medias;
                if (dicomSeries == null) {
                    dicomSeries = dicomReader.buildSeries(seriesUID);
                    dicomSeries.setTag(TagW.ExplorerModel, (Object)this.dicomModel);
                    dicomReader.writeMetaData((MediaSeriesGroup)dicomSeries);
                    this.dicomModel.addHierarchyNode(study, (MediaSeriesGroup)dicomSeries);
                    dicomseriesList.add(dicomSeries);
                    medias = dicomReader.getMediaElement();
                    if (medias == null) continue;
                    for (MediaElement media : medias) {
                        dicomSeries.setFileSize(dicomSeries.getFileSize() + (double)media.getLength());
                        this.dicomModel.applySplittingRules(dicomSeries, media);
                    }
                    continue;
                }
                if (this.isSOPInstanceUIDExist(study, dicomSeries, seriesUID, dicomReader.getTagValue(TagW.SOPInstanceUID)) || (medias = dicomReader.getMediaElement()) == null) continue;
                for (MediaElement media : medias) {
                    dicomSeries.setFileSize(dicomSeries.getFileSize() + (double)media.getLength());
                    if (!this.dicomModel.applySplittingRules(dicomSeries, media)) continue;
                    dicomseriesList.add(dicomSeries);
                }
            }
            catch (Exception e) {
                dicomReader.reset();
                e.printStackTrace();
            }
        }
        for (int i = 0; i < dicomseriesList.size(); ++i) {
            Series series2 = (Series)dicomseriesList.get(i);
            Thumbnail thumb = (Thumbnail)series2.getTagValue(TagW.Thumbnail);
            if (thumb == null) {
                thumb = DicomExplorer.createThumbnail(series2, this.dicomModel, 112);
                series2.setTag(TagW.Thumbnail, (Object)thumb);
            }
            series2.resetLoaders();
            this.dicomModel.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Add, (Object)this.dicomModel, null, (Object)series2));
            Integer splitNb = (Integer)series2.getTagValue(TagW.SplitSeriesNumber);
            Object dicomObject = series2.getTagValue(TagW.DicomSpecialElement);
            if (splitNb == null && dicomObject == null) continue;
            this.dicomModel.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Update, (Object)this.dicomModel, null, (Object)series2));
        }
        if (open && dicomseriesList.size() > 0 && (plugin = UIManager.getViewerFactory((String)(series = (Series)dicomseriesList.get(0)).getMimeType())) != null && !(plugin instanceof MimeSystemAppFactory)) {
            this.openPlugin = false;
            ArrayList<MediaSeries> list = new ArrayList<MediaSeries>(1);
            list.add((MediaSeries)series);
            LoadSeries.openSequenceInPlugin(plugin, list, this.dicomModel, true);
        }
    }

    private boolean isSOPInstanceUIDExist(MediaSeriesGroup study, Series dicomSeries, String seriesUID, Object sopUID) {
        String uid;
        if (dicomSeries.hasMediaContains(TagW.SOPInstanceUID, sopUID)) {
            return true;
        }
        Object splitNb = dicomSeries.getTagValue(TagW.SplitSeriesNumber);
        if (splitNb != null && study != null && (uid = (String)dicomSeries.getTagValue(TagW.SeriesInstanceUID)) != null) {
            Collection<MediaSeriesGroup> seriesList = this.dicomModel.getChildren(study);
            for (MediaSeriesGroup group : seriesList) {
                Series s;
                if (dicomSeries == group || !(group instanceof Series) || !uid.equals((s = (Series)group).getTagValue(TagW.SeriesInstanceUID)) || !s.hasMediaContains(TagW.SOPInstanceUID, sopUID)) continue;
                return true;
            }
        }
        return false;
    }
}

