/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.gui.util.MathUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class PerpendicularLineGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(PerpendicularLineGraphic.class.getResource("/icon/22x22/draw-perpendicular.png"));
    public static final Measurement LINE_LENGTH = new Measurement("Line length", true, true, true);
    public static final Measurement ORIENTATION = new Measurement("Orientation", true, true, false);
    public static final Measurement AZIMUTH = new Measurement("Azimuth", true, true, false);
    protected Point2D ptA;
    protected Point2D ptB;
    protected Point2D ptC;
    protected Point2D ptD;
    protected boolean lineABvalid;
    protected boolean lineCDvalid;

    public PerpendicularLineGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(4, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Perpendicular";
    }

    @Override
    protected int moveAndResizeOnDrawing(int handlePointIndex, double deltaX, double deltaY, MouseEventDouble mouseEvent) {
        List<Point2D> prevHandlePointList = this.getHandlePointList();
        if ((handlePointIndex = super.moveAndResizeOnDrawing(handlePointIndex, deltaX, deltaY, mouseEvent)) >= 0 && handlePointIndex < this.getHandlePointListSize()) {
            this.updateTool();
            if (handlePointIndex == 0 || handlePointIndex == 1) {
                Point2D prevPtB;
                Point2D prevPtA = prevHandlePointList.size() > 0 ? prevHandlePointList.get(0) : null;
                Point2D point2D = prevPtB = prevHandlePointList.size() > 1 ? prevHandlePointList.get(1) : null;
                if (this.lineABvalid && GeomUtil.isLineValid((Point2D)prevPtA, (Point2D)prevPtB) && this.ptC != null && this.ptD != null) {
                    double theta = GeomUtil.getAngleRad((Point2D)prevPtA, (Point2D)prevPtB) - GeomUtil.getAngleRad((Point2D)this.ptA, (Point2D)this.ptB);
                    Point2D anchor = handlePointIndex == 0 ? this.ptB : this.ptA;
                    AffineTransform rotate = AffineTransform.getRotateInstance(theta, anchor.getX(), anchor.getY());
                    rotate.transform(this.ptC, this.ptC);
                    rotate.transform(this.ptD, this.ptD);
                    this.setHandlePoint(2, this.ptC);
                    this.setHandlePoint(3, this.ptD);
                }
            } else if (handlePointIndex == 2) {
                if (this.lineABvalid && this.ptC != null) {
                    this.ptD = GeomUtil.getPerpendicularPointToLine((Point2D)this.ptA, (Point2D)this.ptB, (Point2D)this.ptC);
                    this.setHandlePoint(3, this.ptD);
                }
            } else if (handlePointIndex == 3) {
                Point2D prevPtD;
                Point2D point2D = prevPtD = prevHandlePointList.size() > 3 ? prevHandlePointList.get(3) : null;
                if (this.lineABvalid && this.ptD != null && prevPtD != null && this.ptC != null) {
                    this.ptD = GeomUtil.getPerpendicularPointToLine((Point2D)this.ptA, (Point2D)this.ptB, (Point2D)this.ptD);
                    AffineTransform translate = AffineTransform.getTranslateInstance(this.ptD.getX() - prevPtD.getX(), this.ptD.getY() - prevPtD.getY());
                    translate.transform(this.ptC, this.ptC);
                    this.setHandlePoint(2, this.ptC);
                    this.setHandlePoint(3, this.ptD);
                }
            }
        }
        return handlePointIndex;
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        this.updateTool();
        Shape newShape = null;
        Path2D.Double path = new Path2D.Double(1, 2);
        if (this.lineABvalid) {
            path.append(new Line2D.Double(this.ptA, this.ptB), false);
        }
        if (this.lineCDvalid) {
            path.append(new Line2D.Double(this.ptC, this.ptD), false);
        }
        if (this.lineABvalid && this.lineCDvalid) {
            newShape = new AbstractDragGraphic.AdvancedShape(3);
            AbstractDragGraphic.AdvancedShape aShape = newShape;
            aShape.addShape(path);
            if (!this.ptD.equals(this.ptA) && !this.ptD.equals(this.ptB) && Math.signum(GeomUtil.getAngleDeg((Point2D)this.ptD, (Point2D)this.ptA)) == Math.signum(GeomUtil.getAngleDeg((Point2D)this.ptD, (Point2D)this.ptB))) {
                Point2D E = this.ptD.distance(this.ptA) < this.ptD.distance(this.ptB) ? this.ptA : this.ptB;
                aShape.addShape(new Line2D.Double(this.ptD, E), this.getDashStroke(1.0f), true);
            }
            double cornerLength = 10.0;
            double dMin = Math.min(this.ptD.distance(this.ptC), Math.max(this.ptD.distance(this.ptA), this.ptD.distance(this.ptB))) * 2.0 / 3.0;
            double scalingMin = cornerLength / dMin;
            Point2D F = GeomUtil.getMidPoint((Point2D)this.ptA, (Point2D)this.ptB);
            Shape cornerShape = GeomUtil.getCornerShape((Point2D)F, (Point2D)this.ptD, (Point2D)this.ptC, (double)cornerLength);
            if (cornerShape != null) {
                aShape.addInvShape(cornerShape, this.ptD, scalingMin, this.getStroke(1.0f), true);
            }
        } else if (path.getCurrentPoint() != null) {
            newShape = path;
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.isShapeValid() && (adapter = imageElement.getMeasurementAdapter()) != null) {
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>(3);
            if (LINE_LENGTH.isComputed() && (!drawOnLabel || LINE_LENGTH.isGraphicLabel())) {
                val = null;
                if (releaseEvent || LINE_LENGTH.isQuickComputing()) {
                    val = this.ptC.distance(this.ptD) * adapter.getCalibRatio();
                }
                measVal.add(new MeasureItem(LINE_LENGTH, val, adapter.getUnit()));
            }
            if (ORIENTATION.isComputed() && (!drawOnLabel || ORIENTATION.isGraphicLabel())) {
                val = null;
                if (releaseEvent || ORIENTATION.isQuickComputing()) {
                    val = MathUtil.getOrientation((Point2D)this.ptC, (Point2D)this.ptD);
                }
                measVal.add(new MeasureItem(ORIENTATION, val, "deg"));
            }
            if (AZIMUTH.isComputed() && (!drawOnLabel || AZIMUTH.isGraphicLabel())) {
                val = null;
                if (releaseEvent || AZIMUTH.isQuickComputing()) {
                    val = MathUtil.getAzimuth((Point2D)this.ptC, (Point2D)this.ptD);
                }
                measVal.add(new MeasureItem(AZIMUTH, val, "deg"));
            }
            return measVal;
        }
        return null;
    }

    @Override
    public boolean isShapeValid() {
        this.updateTool();
        return this.lineABvalid && this.lineCDvalid;
    }

    protected void updateTool() {
        this.ptA = this.getHandlePoint(0);
        this.ptB = this.getHandlePoint(1);
        this.ptC = this.getHandlePoint(2);
        this.ptD = this.getHandlePoint(3);
        this.lineABvalid = this.ptA != null && this.ptB != null && !this.ptB.equals(this.ptA);
        this.lineCDvalid = this.ptC != null && this.ptD != null && !this.ptC.equals(this.ptD);
    }
}

