/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.graphic.RectangleGraphic;
import org.weasis.core.ui.util.MouseEventDouble;

public class EllipseGraphic
extends RectangleGraphic {
    public static final Icon ICON = new ImageIcon(EllipseGraphic.class.getResource("/icon/22x22/draw-eclipse.png"));
    public static final Measurement AREA = new Measurement("Area", true, true, true);
    public static final Measurement PERIMETER = new Measurement("Perimeter", true, true, false);
    public static final Measurement CENTER_X = new Measurement("Center X", true, true, false);
    public static final Measurement CENTER_Y = new Measurement("Center Y", true, true, false);
    public static final Measurement WIDTH = new Measurement("Width", true, true, false);
    public static final Measurement HEIGHT = new Measurement("Height", true, true, false);

    public EllipseGraphic(float lineThickness, Color paint, boolean labelVisible) {
        super(lineThickness, paint, labelVisible);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getUIName() {
        return Messages.getString("MeasureToolBar.ellipse");
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseevent) {
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        rectangle.setFrameFromDiagonal(this.getHandlePoint(RectangleGraphic.eHandlePoint.NW.index), this.getHandlePoint(RectangleGraphic.eHandlePoint.SE.index));
        this.setShape(new Ellipse2D.Double(((RectangularShape)rectangle).getX(), ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth(), ((RectangularShape)rectangle).getHeight()), mouseevent);
        this.updateLabel(mouseevent, this.getDefaultView2d(mouseevent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.isShapeValid() && (adapter = imageElement.getMeasurementAdapter()) != null) {
            List<MeasureItem> stats;
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setFrameFromDiagonal(this.getHandlePoint(RectangleGraphic.eHandlePoint.NW.index), this.getHandlePoint(RectangleGraphic.eHandlePoint.SE.index));
            double ratio = adapter.getCalibRatio();
            if (CENTER_X.isComputed() && (!drawOnLabel || CENTER_X.isGraphicLabel())) {
                val = releaseEvent || CENTER_X.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(rect.getCenterX())) : null;
                measVal.add(new MeasureItem(CENTER_X, val, adapter.getUnit()));
            }
            if (CENTER_Y.isComputed() && (!drawOnLabel || CENTER_Y.isGraphicLabel())) {
                val = releaseEvent || CENTER_Y.isQuickComputing() ? Double.valueOf(adapter.getYCalibratedValue(rect.getCenterY())) : null;
                measVal.add(new MeasureItem(CENTER_Y, val, adapter.getUnit()));
            }
            if (WIDTH.isComputed() && (!drawOnLabel || WIDTH.isGraphicLabel())) {
                val = releaseEvent || WIDTH.isQuickComputing() ? Double.valueOf(ratio * ((RectangularShape)rect).getWidth()) : null;
                measVal.add(new MeasureItem(WIDTH, val, adapter.getUnit()));
            }
            if (HEIGHT.isComputed() && (!drawOnLabel || HEIGHT.isGraphicLabel())) {
                val = releaseEvent || HEIGHT.isQuickComputing() ? Double.valueOf(ratio * ((RectangularShape)rect).getHeight()) : null;
                measVal.add(new MeasureItem(HEIGHT, val, adapter.getUnit()));
            }
            if (AREA.isComputed() && (!drawOnLabel || AREA.isGraphicLabel())) {
                val = releaseEvent || AREA.isQuickComputing() ? Double.valueOf(Math.PI * ((RectangularShape)rect).getWidth() * ratio * ((RectangularShape)rect).getHeight() * ratio / 4.0) : null;
                String unit = "pix".equals(adapter.getUnit()) ? adapter.getUnit() : adapter.getUnit() + "2";
                measVal.add(new MeasureItem(AREA, val, unit));
            }
            if ((stats = this.getImageStatistics(imageElement, releaseEvent)) != null) {
                measVal.addAll(stats);
            }
            return measVal;
        }
        return null;
    }
}

