/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import org.weasis.core.ui.graphic.ChainPoint;

public class Contour
implements Serializable {
    private static final long serialVersionUID = 9056317484468365515L;
    public static final int[] DIRX = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final int[] DIRY = new int[]{0, -1, -1, -1, 0, 1, 1, 1};
    private int coordx;
    private int coordy;
    private byte[] codeFreeman;
    private int area;
    private ArrayList<Double> parameters;

    public Contour(int coordx, int coordy, byte[] codeFreeman, int area, ArrayList<Double> parameters) {
        this.coordx = coordx;
        this.coordy = coordy;
        this.codeFreeman = codeFreeman;
        this.area = area;
        this.parameters = parameters;
    }

    public byte[] getCodeFreeman() {
        return this.codeFreeman;
    }

    public int getCoordx() {
        return this.coordx;
    }

    public int getCoordy() {
        return this.coordy;
    }

    public int getArea() {
        return this.area;
    }

    public ArrayList<Double> getParameters() {
        return this.parameters;
    }

    public Rectangle getBounds() {
        if (this.codeFreeman == null) {
            return null;
        }
        int[] dirX = DIRX;
        int[] dirY = DIRY;
        int boundsMinX = Integer.MAX_VALUE;
        int boundsMinY = Integer.MAX_VALUE;
        int boundsMaxX = Integer.MIN_VALUE;
        int boundsMaxY = Integer.MIN_VALUE;
        int x = this.coordx;
        int y = this.coordy;
        for (int i = 0; i < this.codeFreeman.length; ++i) {
            byte index = this.codeFreeman[i];
            boundsMinX = Math.min(boundsMinX, x += dirX[index]);
            boundsMaxX = Math.max(boundsMaxX, x);
            boundsMinY = Math.min(boundsMinY, y += dirY[index]);
            boundsMaxY = Math.max(boundsMaxY, y);
        }
        return new Rectangle(boundsMinX, boundsMinY, boundsMaxX - boundsMinX + 1, boundsMaxY - boundsMinY + 1);
    }

    private int changeDir(int lastDir, int index) {
        int change = index - lastDir;
        if (change < -4) {
            change = (change + 8) % 8;
        } else if (change > 4) {
            change = (change - 8) % 8;
        }
        return change;
    }

    private void writeTurnPosition(byte[][] matrix, int missX, int missY, int missPos, int offset, byte[] border) {
        block6: {
            int[] dirX = DIRX;
            int[] dirY = DIRY;
            if (offset > 2) {
                for (int extY = 2; extY < offset + 1; ++extY) {
                    int x;
                    int y;
                    int extX;
                    boolean canWriteX = true;
                    for (extX = 2; extX < offset - (extY - 2); ++extX) {
                        y = missY + dirY[missPos] * (extY - 2);
                        x = missX + dirX[missPos] * (extX - 2);
                        if (matrix[y][x] == border[extX + extY]) continue;
                        if (extX != 2) {
                            canWriteX = false;
                            break;
                        }
                        break block6;
                    }
                    if (!canWriteX || matrix[y = missY + dirY[missPos] * (extY - 2)][x = missX + dirX[missPos] * (extX - 2)] != 0) continue;
                    matrix[y][x] = border[offset + 2];
                }
            } else if (offset == 2 && matrix[missY][missX] == 0) {
                matrix[missY][missX] = border[4];
            }
        }
    }

    private void writeNewPosition(byte[][] matrix, int index, int nextDir, int newPos1, int offset, int xdir, int ydir, byte[] border) {
        int x;
        int y;
        int[] dirX = DIRX;
        int[] dirY = DIRY;
        boolean canWrite = true;
        for (int ext = 1; ext < offset; ++ext) {
            y = ydir + dirY[newPos1] * ext;
            x = xdir + dirX[newPos1] * ext;
            if (matrix[y][x] == border[ext + 2]) continue;
            canWrite = false;
            break;
        }
        if (canWrite && matrix[y = ydir + dirY[newPos1] * offset][x = xdir + dirX[newPos1] * offset] == 0 && this.canWriteInDir(index, nextDir, newPos1)) {
            matrix[y][x] = border[offset + 2];
        }
    }

    private void writeNewPositionWithNoRestriction(byte[][] matrix, int newPos1, int offset, int xdir, int ydir, byte[] border) {
        int x;
        int y;
        int[] dirX = DIRX;
        int[] dirY = DIRY;
        boolean canWrite = true;
        for (int ext = 1; ext < offset; ++ext) {
            y = ydir + dirY[newPos1] * ext;
            x = xdir + dirX[newPos1] * ext;
            if (matrix[y][x] == border[ext + 2]) continue;
            canWrite = false;
            break;
        }
        if (canWrite && matrix[y = ydir + dirY[newPos1] * offset][x = xdir + dirX[newPos1] * offset] == 0) {
            matrix[y][x] = border[offset + 2];
        }
    }

    private boolean canWriteInDir(int index, int nextDir, int newPos) {
        return (newPos - (index - 4) + 8) % 8 < (nextDir - (index - 4) + 8) % 8;
    }

    private void writeLayer(byte[][] matrix, int xdir, int ydir, byte[] border, int layer) {
        int[] dirX = DIRX;
        int[] dirY = DIRY;
        int offset = layer - 2;
        matrix[ydir - offset][xdir] = border[layer];
        matrix[ydir][xdir] = border[1];
        byte lastDir = this.codeFreeman[this.codeFreeman.length - 1];
        for (int i = 0; i < this.codeFreeman.length; ++i) {
            int missY;
            int missX;
            int missY2;
            int missX2;
            int newPos3;
            int newPos2;
            int newPos1;
            byte index = this.codeFreeman[i];
            byte nextDir = i == this.codeFreeman.length - 1 ? this.codeFreeman[0] : this.codeFreeman[i + 1];
            matrix[ydir += dirY[index]][xdir += dirX[index]] = border[1];
            int change = this.changeDir(lastDir, index);
            if (change == -2) {
                newPos1 = (index - 1 + 8) % 8;
                this.writeNewPosition(matrix, index, nextDir, newPos1, offset, xdir, ydir, border);
            } else if (change == -1 || change == 0) {
                if (index % 2 == 0) {
                    newPos1 = (index - 2 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos1, offset, xdir, ydir, border);
                } else {
                    newPos1 = (index - 1 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos1, offset, xdir, ydir, border);
                    newPos2 = (index - 3 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos2, offset, xdir, ydir, border);
                }
            } else if (change == 1) {
                if (index % 2 == 0) {
                    newPos1 = (index - 2 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos1, offset, xdir, ydir, border);
                } else {
                    newPos1 = (index - 1 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos1, offset, xdir, ydir, border);
                    newPos2 = (index - 3 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos2, offset, xdir, ydir, border);
                    if (this.changeDir(index, nextDir) >= 0) {
                        newPos3 = (index - 2 + 8) % 8;
                        missX2 = xdir + dirX[newPos3];
                        missY2 = ydir + dirY[newPos3];
                        this.writeTurnPosition(matrix, missX2, missY2, newPos3, offset, border);
                    }
                }
            } else if (change == 2) {
                if (index % 2 == 0) {
                    newPos1 = (index - 2 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos1, offset, xdir, ydir, border);
                    newPos2 = (index - 4 + 8) % 8;
                    missX = xdir + dirX[newPos2];
                    missY = ydir + dirY[newPos2];
                    this.writeNewPosition(matrix, index, nextDir, newPos1, offset, missX, missY, border);
                    int newPos32 = (lastDir - 1 + 8) % 8;
                    int missX22 = missX + dirX[newPos32];
                    int missY22 = missY + dirY[newPos32];
                    this.writeTurnPosition(matrix, missX22, missY22, newPos32, offset, border);
                } else {
                    newPos1 = (index - 1 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos1, offset, xdir, ydir, border);
                    newPos2 = (index - 3 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos2, offset, xdir, ydir, border);
                    newPos3 = (index - 2 + 8) % 8;
                    missX2 = xdir + dirX[newPos3];
                    missY2 = ydir + dirY[newPos3];
                    this.writeTurnPosition(matrix, missX2, missY2, newPos3, offset, border);
                }
            } else if (change == 3 || change == 4 || change == -4) {
                int newPos5;
                int missY23;
                int missX23;
                int newPos4;
                if (index % 2 == 0) {
                    newPos1 = (index - 2 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos1, offset, xdir, ydir, border);
                    newPos2 = (index - 4 + 8) % 8;
                    missX = xdir + dirX[newPos2];
                    missY = ydir + dirY[newPos2];
                    this.writeNewPositionWithNoRestriction(matrix, newPos1, offset, missX, missY, border);
                    if (change == 3) {
                        int missX24 = missX + dirX[lastDir];
                        int missY24 = missY + dirY[lastDir];
                        this.writeTurnPosition(matrix, missX24, missY24, lastDir, offset, border);
                    } else {
                        this.writeNewPositionWithNoRestriction(matrix, newPos2, offset, missX, missY, border);
                        int newPos6 = (newPos2 - 2 + 8) % 8;
                        this.writeNewPositionWithNoRestriction(matrix, newPos6, offset, missX, missY, border);
                        newPos4 = (newPos2 - 1 + 8) % 8;
                        missX23 = missX + dirX[newPos4];
                        missY23 = missY + dirY[newPos4];
                        this.writeTurnPosition(matrix, missX23, missY23, newPos4, offset, border);
                        newPos5 = (newPos2 + 1 + 8) % 8;
                        missX23 = missX + dirX[newPos5];
                        missY23 = missY + dirY[newPos5];
                        this.writeTurnPosition(matrix, missX23, missY23, newPos5, offset, border);
                    }
                } else {
                    newPos1 = (index - 1 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos1, offset, xdir, ydir, border);
                    newPos2 = (index - 3 + 8) % 8;
                    this.writeNewPosition(matrix, index, nextDir, newPos2, offset, xdir, ydir, border);
                    newPos3 = (index - 2 + 8) % 8;
                    missX2 = xdir + dirX[newPos3];
                    missY2 = ydir + dirY[newPos3];
                    this.writeTurnPosition(matrix, missX2, missY2, newPos3, offset, border);
                    newPos4 = (index - 4 + 8) % 8;
                    missX23 = xdir + dirX[newPos4];
                    missY23 = ydir + dirY[newPos4];
                    if (change == 4 || change == -4) {
                        int newPos6 = (newPos4 - 1 + 8) % 8;
                        this.writeNewPositionWithNoRestriction(matrix, newPos6, offset, missX23, missY23, border);
                        newPos6 = (newPos4 - 3 + 8) % 8;
                        this.writeNewPositionWithNoRestriction(matrix, newPos6, offset, missX23, missY23, border);
                    }
                    newPos5 = (newPos4 + 1 + 8) % 8;
                    this.writeNewPositionWithNoRestriction(matrix, newPos5, offset, missX23, missY23, border);
                    int missX3 = missX23 + dirX[newPos4];
                    int missY3 = missY23 + dirY[newPos4];
                    this.writeTurnPosition(matrix, missX3, missY3, newPos4, offset, border);
                    if (change == 4 || change == -4) {
                        int newPos7 = (newPos4 - 2 + 8) % 8;
                        missX3 = missX23 + dirX[newPos7];
                        missY3 = missY23 + dirY[newPos7];
                        this.writeTurnPosition(matrix, missX3, missY3, newPos7, offset, border);
                    }
                }
            }
            lastDir = index;
        }
    }

    public byte[][] dilate(int layer) {
        if (layer < 1) {
            return null;
        }
        Rectangle bound = this.getBounds();
        byte[][] matrix = new byte[bound.height + 2 * layer][bound.width + 2 * layer];
        byte[] border = new byte[layer + 3];
        for (int i = 0; i < border.length; ++i) {
            border[i] = (byte)i;
        }
        int xdir = this.coordx - bound.x + layer;
        int ydir = layer;
        for (int k = 3; k < layer + 3; ++k) {
            this.writeLayer(matrix, xdir, ydir, border, k);
        }
        return matrix;
    }

    public static Contour getContourFromChainListCoord(ArrayList<ChainPoint> chain) {
        byte[] val = new byte[chain.size()];
        ChainPoint last = chain.get(0);
        for (int j = 1; j < chain.size(); ++j) {
            ChainPoint pt = chain.get(j);
            val[j - 1] = Contour.getDirFromTwoCoord(last, pt);
            last = pt;
        }
        ChainPoint first = chain.get(0);
        val[val.length - 1] = Contour.getDirFromTwoCoord(chain.get(chain.size() - 1), first);
        return new Contour(first.x, first.y, val, 50, null);
    }

    public static byte getDirFromTwoCoord(ChainPoint last, ChainPoint next) {
        int x = next.x - last.x;
        int y = next.y - last.y;
        if (x == 1) {
            if (y == 1) {
                return 7;
            }
            if (y == -1) {
                return 1;
            }
            return 0;
        }
        if (x == -1) {
            if (y == 1) {
                return 5;
            }
            if (y == -1) {
                return 3;
            }
            return 4;
        }
        if (y == 1) {
            return 6;
        }
        return 2;
    }
}

