/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class AngleToolGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(AngleToolGraphic.class.getResource("/icon/22x22/draw-angle.png"));
    public static final Measurement ANGLE = new Measurement("Angle", true);
    public static final Measurement COMPLEMENTARY_ANGLE = new Measurement("Compl. Angle", true, true, false);
    Point2D ptA;
    Point2D ptO;
    Point2D ptB;
    boolean lineColinear;
    boolean lineOAvalid;
    boolean lineOBvalid;
    double angleDeg;

    public AngleToolGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(3, paintColor, lineThickness, labelVisible);
        this.init();
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Angle measure";
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        this.updateTool();
        Shape newShape = null;
        Path2D.Double path = new Path2D.Double(1, 2);
        if (this.lineOAvalid) {
            path.append(new Line2D.Double(this.ptA, this.ptO), false);
        }
        if (this.lineOBvalid) {
            path.append(new Line2D.Double(this.ptO, this.ptB), false);
        }
        if (this.lineOAvalid && this.lineOBvalid && !this.lineColinear) {
            newShape = new AbstractDragGraphic.AdvancedShape(2);
            AbstractDragGraphic.AdvancedShape aShape = newShape;
            aShape.addShape(path);
            double startingAngle = GeomUtil.getAngleDeg((Point2D)this.ptO, (Point2D)this.ptA);
            double radius = 32.0;
            Rectangle2D.Double arcAngleBounds = new Rectangle2D.Double(this.ptO.getX() - radius, this.ptO.getY() - radius, 2.0 * radius, 2.0 * radius);
            Arc2D.Double arcAngle = new Arc2D.Double(arcAngleBounds, startingAngle, this.angleDeg, 0);
            double rMax = Math.min(this.ptO.distance(this.ptA), this.ptO.distance(this.ptB)) * 2.0 / 3.0;
            double scalingMin = radius / rMax;
            aShape.addInvShape((Shape)arcAngle, this.ptO, scalingMin, true);
        } else if (path.getCurrentPoint() != null) {
            newShape = path;
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.isShapeValid() && (adapter = imageElement.getMeasurementAdapter()) != null) {
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            if (ANGLE.isComputed() || COMPLEMENTARY_ANGLE.isComputed()) {
                double positiveAngle = Math.abs(this.angleDeg);
                if (ANGLE.isComputed() && (!drawOnLabel || ANGLE.isGraphicLabel())) {
                    measVal.add(new MeasureItem(ANGLE, positiveAngle, "deg"));
                }
                if (COMPLEMENTARY_ANGLE.isComputed() && (!drawOnLabel || COMPLEMENTARY_ANGLE.isGraphicLabel())) {
                    measVal.add(new MeasureItem(COMPLEMENTARY_ANGLE, 180.0 - positiveAngle, "deg"));
                }
            }
            return measVal;
        }
        return null;
    }

    @Override
    public boolean isShapeValid() {
        this.updateTool();
        return this.lineOAvalid && this.lineOBvalid;
    }

    protected void init() {
        this.ptA = this.getHandlePoint(0);
        this.ptO = this.getHandlePoint(1);
        this.ptB = this.getHandlePoint(2);
        this.lineColinear = false;
        this.lineOBvalid = false;
        this.lineOAvalid = false;
        this.angleDeg = 0.0;
    }

    protected void updateTool() {
        this.init();
        this.lineOAvalid = this.ptA != null && this.ptO != null && !this.ptO.equals(this.ptA);
        boolean bl = this.lineOBvalid = this.ptB != null && this.ptO != null && !this.ptO.equals(this.ptB);
        if (this.lineOAvalid && this.lineOBvalid) {
            this.angleDeg = GeomUtil.getSmallestRotationAngleDeg((double)GeomUtil.getAngleDeg((Point2D)this.ptA, (Point2D)this.ptO, (Point2D)this.ptB));
            this.lineColinear = GeomUtil.lineColinear((Point2D)this.ptO, (Point2D)this.ptA, (Point2D)this.ptO, (Point2D)this.ptB);
        }
    }
}

