/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;

public abstract class AbstractDragGraphicArea
extends AbstractDragGraphic {
    public static final Measurement IMAGE_MEAN = new Measurement("Mean", false, true, true);
    public static final Measurement IMAGE_MIN = new Measurement("Min", false, true, false);
    public static final Measurement IMAGE_MAX = new Measurement("Max", false, true, false);
    public static final Measurement IMAGE_STD = new Measurement("StDev", false, true, false);

    public AbstractDragGraphicArea(int handlePointTotalNumber) {
        this(handlePointTotalNumber, Color.YELLOW, 1.0f, true);
    }

    public AbstractDragGraphicArea(int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible) {
        this(handlePointTotalNumber, paintColor, lineThickness, labelVisible, false);
    }

    public AbstractDragGraphicArea(int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible, boolean filled) {
        this(null, handlePointTotalNumber, paintColor, lineThickness, labelVisible, filled);
    }

    public AbstractDragGraphicArea(List<Point2D> handlePointList, int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible, boolean filled) {
        super(handlePointList, handlePointTotalNumber, paintColor, lineThickness, labelVisible, filled);
    }

    @Override
    public Area getArea(AffineTransform transform) {
        if (this.shape == null) {
            return new Area();
        }
        Area area = super.getArea(transform);
        area.add(new Area(this.shape));
        return area;
    }

    public List<MeasureItem> getImageStatistics(ImageElement imageElement, boolean releaseEvent) {
        if (imageElement != null && this.isShapeValid()) {
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>(5);
            if (IMAGE_MIN.isComputed() || IMAGE_MAX.isComputed() || IMAGE_MEAN.isComputed() || IMAGE_STD.isComputed()) {
                Double suv;
                Double val;
                String unit;
                Double min = null;
                Double max = null;
                Double stdv = null;
                Double mean = null;
                if (releaseEvent) {
                    PlanarImage image = imageElement.getImage();
                    try {
                        int band;
                        ArrayList<Integer> pList = this.getValueFromArea(image);
                        if (pList != null && pList.size() > 0 && (band = image.getSampleModel().getNumBands()) == 1) {
                            double v;
                            Float slope = (Float)imageElement.getTagValue(TagW.RescaleSlope);
                            Float intercept = (Float)imageElement.getTagValue(TagW.RescaleIntercept);
                            if (slope != null || intercept != null) {
                                slope = Float.valueOf(slope == null ? 1.0f : slope.floatValue());
                                intercept = Float.valueOf(intercept == null ? 0.0f : intercept.floatValue());
                            }
                            min = Double.MAX_VALUE;
                            max = -1.7976931348623157E308;
                            double sum = 0.0;
                            for (Integer val2 : pList) {
                                v = val2.doubleValue();
                                if (slope != null) {
                                    v = v * (double)slope.floatValue() + (double)intercept.floatValue();
                                }
                                if (v < min) {
                                    min = v;
                                }
                                if (v > max) {
                                    max = v;
                                }
                                sum += v;
                            }
                            mean = sum / (double)pList.size();
                            stdv = 0.0;
                            for (Integer val2 : pList) {
                                v = val2.doubleValue();
                                if (slope != null) {
                                    v = v * (double)slope.floatValue() + (double)intercept.floatValue();
                                }
                                if (v < min) {
                                    min = v;
                                }
                                if (v > max) {
                                    max = v;
                                }
                                stdv = stdv + (v - mean) * (v - mean);
                            }
                            stdv = Math.sqrt(stdv / ((double)pList.size() - 1.0));
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                }
                String string = unit = imageElement.getPixelValueUnit() == null ? "" : imageElement.getPixelValueUnit();
                if (IMAGE_MIN.isComputed()) {
                    val = releaseEvent || IMAGE_MIN.isQuickComputing() ? min : null;
                    measVal.add(new MeasureItem(IMAGE_MIN, val, unit));
                }
                if (IMAGE_MAX.isComputed()) {
                    val = releaseEvent || IMAGE_MAX.isQuickComputing() ? max : null;
                    measVal.add(new MeasureItem(IMAGE_MAX, val, unit));
                }
                if (IMAGE_STD.isComputed()) {
                    val = releaseEvent || IMAGE_STD.isQuickComputing() ? stdv : null;
                    measVal.add(new MeasureItem(IMAGE_STD, val, unit));
                }
                if (IMAGE_MEAN.isComputed()) {
                    val = releaseEvent || IMAGE_MEAN.isQuickComputing() ? mean : null;
                    measVal.add(new MeasureItem(IMAGE_MEAN, val, unit));
                }
                if ((suv = (Double)imageElement.getTagValue(TagW.SuvFactor)) != null) {
                    unit = "SUV (bw)";
                    if (IMAGE_MIN.isComputed()) {
                        Double val3 = releaseEvent || IMAGE_MIN.isQuickComputing() ? (min == null ? null : Double.valueOf(min * suv)) : null;
                        measVal.add(new MeasureItem(IMAGE_MIN, val3, unit));
                    }
                    if (IMAGE_MAX.isComputed()) {
                        Double val4 = releaseEvent || IMAGE_MAX.isQuickComputing() ? (max == null ? null : Double.valueOf(max * suv)) : null;
                        measVal.add(new MeasureItem(IMAGE_MAX, val4, unit));
                    }
                    if (IMAGE_MEAN.isComputed()) {
                        Double val5 = releaseEvent || IMAGE_MEAN.isQuickComputing() ? (mean == null ? null : Double.valueOf(mean * suv)) : null;
                        measVal.add(new MeasureItem(IMAGE_MEAN, val5, unit));
                    }
                }
            }
            return measVal;
        }
        return null;
    }

    protected ArrayList<Integer> getValueFromArea(PlanarImage imageData) {
        RectIter it;
        if (imageData == null || this.shape == null) {
            return null;
        }
        Area shapeArea = new Area(this.shape);
        Rectangle bound = shapeArea.getBounds();
        bound = imageData.getBounds().intersection(bound);
        if (bound.width == 0 || bound.height == 0) {
            return null;
        }
        try {
            it = RectIterFactory.create((RenderedImage)imageData, (Rectangle)bound);
        }
        catch (Exception ex) {
            it = null;
        }
        ArrayList<Integer> list = null;
        if (it != null) {
            int band = imageData.getSampleModel().getNumBands();
            list = new ArrayList<Integer>();
            int[] c = new int[]{0, 0, 0};
            it.startBands();
            it.startLines();
            int y = bound.y;
            while (!it.finishedLines()) {
                it.startPixels();
                int x = bound.x;
                while (!it.finishedPixels()) {
                    if (shapeArea.contains(x, y)) {
                        it.getPixel(c);
                        for (int i = 0; i < band; ++i) {
                            list.add(c[i]);
                        }
                    }
                    it.nextPixel();
                    ++x;
                }
                it.nextLine();
                ++y;
            }
        }
        return list;
    }
}

