/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.gui.Image2DViewer;
import org.weasis.core.api.gui.util.DecFormater;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.dockable.MeasureTool;
import org.weasis.core.ui.graphic.AbstractDragGraphicArea;
import org.weasis.core.ui.graphic.DragSequence;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.GraphicLabel;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.graphic.model.AbstractLayerModel;
import org.weasis.core.ui.graphic.model.GraphicsListener;
import org.weasis.core.ui.graphic.model.Tools;
import org.weasis.core.ui.util.MouseEventDouble;

public abstract class AbstractDragGraphic
implements Graphic {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractDragGraphic.class);
    public static final int UNDEFINED = -1;
    protected PropertyChangeSupport pcs;
    protected Shape shape;
    protected int handlePointTotalNumber;
    protected List<Point2D> handlePointList;
    protected int handleSize = 6;
    protected int selectionSize = 10;
    protected Paint colorPaint;
    protected float lineThickness;
    protected boolean filled;
    protected boolean labelVisible;
    protected GraphicLabel graphicLabel;
    protected boolean selected = false;
    private boolean resizingOrMoving = false;
    private int layerID = Tools.TEMPDRAGLAYER.getId();

    public AbstractDragGraphic(int handlePointTotalNumber) {
        this(handlePointTotalNumber, Color.YELLOW, 1.0f, true);
    }

    public AbstractDragGraphic(int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible) {
        this(handlePointTotalNumber, paintColor, lineThickness, labelVisible, false);
    }

    public AbstractDragGraphic(int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible, boolean filled) {
        this(null, handlePointTotalNumber, paintColor, lineThickness, labelVisible, filled);
    }

    public AbstractDragGraphic(List<Point2D> handlePointList, int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible, boolean filled) {
        if (paintColor == null) {
            paintColor = Color.YELLOW;
        }
        this.handlePointTotalNumber = handlePointTotalNumber;
        this.handlePointList = handlePointList == null ? new ArrayList(handlePointTotalNumber > 0 ? handlePointTotalNumber : 10) : handlePointList;
        this.colorPaint = paintColor;
        this.lineThickness = lineThickness;
        this.labelVisible = labelVisible;
        this.filled = filled;
        if (handlePointList != null) {
            this.updateShapeOnDrawing(null);
        }
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    public int getHandlePointTotalNumber() {
        return this.handlePointTotalNumber;
    }

    public Stroke getStroke(float lineThickness) {
        return new BasicStroke(lineThickness, 0, 1);
    }

    public Stroke getDashStroke(float lineThickness) {
        return new BasicStroke(lineThickness, 0, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    }

    public Paint getColorPaint() {
        return this.colorPaint;
    }

    public float getLineThickness() {
        return this.lineThickness;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public boolean isFilled() {
        return this.filled;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    @Override
    public GraphicLabel getGraphicLabel() {
        return this.graphicLabel;
    }

    @Override
    public String[] getLabel() {
        return this.graphicLabel != null ? this.graphicLabel.getLabels() : null;
    }

    public boolean isGraphicComplete() {
        return this.handlePointList.size() == this.handlePointTotalNumber;
    }

    public void addHandlePoint(Point2D handlePt) {
        this.handlePointList.add(handlePt);
    }

    public Point2D getHandlePoint(int index) {
        Point2D handlePoint = null;
        if (index >= 0 && index < this.handlePointList.size() && (handlePoint = this.handlePointList.get(index)) != null) {
            handlePoint = (Point2D)handlePoint.clone();
        }
        return handlePoint;
    }

    public List<Point2D> getHandlePointList() {
        ArrayList<Point2D> handlePointListcopy = new ArrayList<Point2D>(this.handlePointList.size());
        for (Point2D handlePt : this.handlePointList) {
            handlePointListcopy.add(handlePt != null ? (Point2D)handlePt.clone() : null);
        }
        return handlePointListcopy;
    }

    public void setHandlePoint(int index, Point2D newPoint) {
        if (index >= 0 && index <= this.handlePointList.size()) {
            if (index == this.handlePointList.size()) {
                this.handlePointList.add(newPoint);
            } else {
                this.handlePointList.set(index, newPoint);
            }
        }
    }

    public int getHandlePointListSize() {
        return this.handlePointList.size();
    }

    public String getDescription() {
        return "";
    }

    public void moveMouseOverHandlePoint(int handlePtIndex, MouseEventDouble event) {
        DefaultView2d graphPane = this.getDefaultView2d(event);
        if (graphPane != null) {
            Point2D handlePt = null;
            if (handlePtIndex >= 0 && handlePtIndex < this.handlePointList.size()) {
                handlePt = this.handlePointList.get(handlePtIndex);
            }
            if (handlePt != null) {
                Point mousePt = graphPane.getMouseCoordinatesFromImage(handlePt.getX(), handlePt.getY());
                if (event.getX() != mousePt.x || event.getY() != mousePt.y) {
                    try {
                        event.translatePoint(mousePt.x - event.getX(), mousePt.y - event.getY());
                        event.setImageCoordinates(handlePt);
                        SwingUtilities.convertPointToScreen(mousePt, graphPane);
                        new Robot().mouseMove(mousePt.x, mousePt.y);
                    }
                    catch (Exception doNothing) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public Area getArea(AffineTransform transform) {
        if (this.shape == null) {
            return new Area();
        }
        if (this.shape instanceof AdvancedShape) {
            return ((AdvancedShape)this.shape).getArea(transform);
        }
        double growingSize = Math.max(this.selectionSize, this.handleSize);
        growingSize = Math.max(growingSize, (double)this.lineThickness);
        BasicStroke boundingStroke = new BasicStroke((float)(growingSize /= GeomUtil.extractScalingFactor((AffineTransform)transform)), 1, 1);
        return new Area(boundingStroke.createStrokedShape(this.shape));
    }

    public Area getArea(MouseEvent mouseEvent) {
        AffineTransform transform = this.getAffineTransform(mouseEvent);
        return this.getArea(transform);
    }

    @Override
    public boolean intersects(Rectangle rectangle, AffineTransform transform) {
        return rectangle != null ? this.getArea(transform).intersects(rectangle) : false;
    }

    @Override
    public Rectangle getBounds(AffineTransform transform) {
        if (this.shape == null) {
            return null;
        }
        if (this.shape instanceof AdvancedShape) {
            ((AdvancedShape)this.shape).updateScalingFactor(transform);
        }
        Rectangle2D bounds = this.shape.getBounds2D();
        double growingSize = (double)this.lineThickness / 2.0;
        GeomUtil.growRectangle((Rectangle2D)bounds, (double)(growingSize /= GeomUtil.extractScalingFactor((AffineTransform)transform)));
        return bounds != null ? bounds.getBounds() : null;
    }

    public Rectangle getBounds(MouseEvent mouseEvent) {
        AffineTransform transform = this.getAffineTransform(mouseEvent);
        return this.getBounds(transform);
    }

    public Rectangle getRepaintBounds(Shape shape, AffineTransform transform) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof AdvancedShape) {
            ((AdvancedShape)shape).updateScalingFactor(transform);
        }
        Rectangle2D bounds = shape.getBounds2D();
        double growingSize = Math.max((double)this.handleSize * 1.5 / 2.0, (double)this.lineThickness / 2.0) + 2.0;
        GeomUtil.growRectangle((Rectangle2D)bounds, (double)(growingSize /= GeomUtil.extractScalingFactor((AffineTransform)transform)));
        return bounds != null ? bounds.getBounds() : null;
    }

    @Override
    public Rectangle getRepaintBounds(AffineTransform transform) {
        return this.getRepaintBounds(this.shape, transform);
    }

    public Rectangle getRepaintBounds(MouseEvent mouseEvent) {
        AffineTransform transform = this.getAffineTransform(mouseEvent);
        return this.getRepaintBounds(this.shape, transform);
    }

    @Override
    public Rectangle getTransformedBounds(Shape shape, AffineTransform transform) {
        Rectangle rectangle = this.getRepaintBounds(shape, transform);
        if (transform != null && rectangle != null) {
            rectangle = transform.createTransformedShape(rectangle).getBounds();
        }
        return rectangle;
    }

    @Override
    public Rectangle getTransformedBounds(GraphicLabel label, AffineTransform transform) {
        return label != null ? label.getTransformedBounds(transform).getBounds() : null;
    }

    public int getHandlePointIndex(MouseEventDouble mouseEvent) {
        Point2D mousePoint;
        int nearestHandlePtIndex = -1;
        Point2D point2D = mousePoint = mouseEvent != null ? mouseEvent.getImageCoordinates() : null;
        if (mousePoint != null && this.handlePointList.size() > 0) {
            double minHandleDistance = Double.MAX_VALUE;
            double maxHandleDistance = (double)this.handleSize * 1.5 / GeomUtil.extractScalingFactor((AffineTransform)this.getAffineTransform(mouseEvent));
            for (int index = 0; index < this.handlePointList.size(); ++index) {
                double handleDistance;
                Point2D handlePoint = this.handlePointList.get(index);
                double d = handleDistance = handlePoint != null ? mousePoint.distance(handlePoint) : Double.MAX_VALUE;
                if (!(handleDistance <= maxHandleDistance) || !(handleDistance < minHandleDistance)) continue;
                minHandleDistance = handleDistance;
                nearestHandlePtIndex = index;
            }
        }
        return nearestHandlePtIndex;
    }

    public List<Integer> getHandlePointIndexList(MouseEventDouble mouseEvent) {
        Point2D mousePoint;
        TreeMap<Double, Integer> indexByDistanceMap = null;
        Point2D point2D = mousePoint = mouseEvent != null ? mouseEvent.getImageCoordinates() : null;
        if (mousePoint != null && this.handlePointList.size() > 0) {
            double maxHandleDistance = (double)this.handleSize * 1.5 / GeomUtil.extractScalingFactor((AffineTransform)this.getAffineTransform(mouseEvent));
            for (int index = 0; index < this.handlePointList.size(); ++index) {
                double handleDistance;
                Point2D handlePoint = this.handlePointList.get(index);
                double d = handleDistance = handlePoint != null ? mousePoint.distance(handlePoint) : Double.MAX_VALUE;
                if (!(handleDistance <= maxHandleDistance)) continue;
                if (indexByDistanceMap == null) {
                    indexByDistanceMap = new TreeMap<Double, Integer>();
                }
                indexByDistanceMap.put(handleDistance, index);
            }
        }
        return indexByDistanceMap != null ? new ArrayList(indexByDistanceMap.values()) : null;
    }

    public boolean isOnGraphicLabel(MouseEventDouble mouseevent) {
        Area labelArea;
        if (mouseevent == null) {
            return false;
        }
        Point2D mousePoint = mouseevent.getImageCoordinates();
        AffineTransform transform = this.getAffineTransform(mouseevent);
        return transform != null && this.labelVisible && this.graphicLabel != null && (labelArea = this.graphicLabel.getArea(transform)) != null && labelArea.contains(mousePoint);
    }

    protected DefaultView2d getDefaultView2d(MouseEvent mouseevent) {
        if (mouseevent != null && mouseevent.getSource() instanceof DefaultView2d) {
            return (DefaultView2d)mouseevent.getSource();
        }
        return null;
    }

    protected AffineTransform getAffineTransform(MouseEvent mouseevent) {
        if (mouseevent != null && mouseevent.getSource() instanceof Image2DViewer) {
            return ((Image2DViewer)mouseevent.getSource()).getAffineTransform();
        }
        return null;
    }

    protected ImageElement getImageElement(MouseEvent mouseevent) {
        if (mouseevent != null && mouseevent.getSource() instanceof Image2DViewer) {
            return ((Image2DViewer)mouseevent.getSource()).getImage();
        }
        return null;
    }

    public void setShape(Shape newShape, MouseEvent mouseevent) {
        Shape oldShape = this.shape;
        this.shape = newShape;
        this.fireDrawingChanged(oldShape);
    }

    public void setLineThickness(float lineThickness) {
        if (this.lineThickness != lineThickness) {
            this.lineThickness = lineThickness;
            if (this.shape instanceof AdvancedShape) {
                for (AdvancedShape.BasicShape bs : ((AdvancedShape)this.shape).getShapeList()) {
                    bs.changelineThickness(lineThickness);
                }
            }
            this.fireDrawingChanged();
        }
    }

    public void setPaint(Color newPaintColor) {
        if (this.colorPaint == null || newPaintColor == null || !this.colorPaint.equals(newPaintColor)) {
            this.colorPaint = newPaintColor;
            this.fireDrawingChanged();
        }
    }

    public void setFilled(boolean newFilled) {
        if (this.filled != newFilled && this instanceof AbstractDragGraphicArea) {
            this.filled = newFilled;
            this.fireDrawingChanged();
        }
    }

    @Override
    public void setSelected(boolean newSelected) {
        if (this.selected != newSelected) {
            this.selected = newSelected;
            this.fireDrawingChanged();
            this.fireLabelChanged();
        }
    }

    public void setLabelVisible(boolean newLabelVisible) {
        if (this.labelVisible != newLabelVisible) {
            this.labelVisible = newLabelVisible;
            this.fireLabelChanged();
        }
    }

    @Override
    public void setLabel(String[] labels, DefaultView2d view2d) {
        if (this.shape != null) {
            Rectangle2D rect;
            if (this.shape instanceof AdvancedShape && ((AdvancedShape)this.shape).shapeList.size() > 0) {
                Shape generalPath = ((AdvancedShape)this.shape).shapeList.get((int)0).shape;
                rect = generalPath.getBounds2D();
            } else {
                rect = this.shape.getBounds2D();
            }
            double xPos = rect.getX() + rect.getWidth() + 3.0;
            double yPos = rect.getY() + rect.getHeight() * 0.5;
            this.setLabel(labels, view2d, new Point2D.Double(xPos, yPos));
        }
    }

    public final void setLabel(String[] labels, DefaultView2d view2d, Point2D pos) {
        GraphicLabel oldLabel;
        GraphicLabel graphicLabel = oldLabel = this.graphicLabel != null ? this.graphicLabel.clone() : null;
        if (labels == null || labels.length == 0) {
            this.graphicLabel = null;
            this.fireLabelChanged(oldLabel);
        } else if (pos == null) {
            this.setLabel(labels, view2d);
        } else {
            if (this.graphicLabel == null) {
                this.graphicLabel = new GraphicLabel();
            }
            this.graphicLabel.setLabel(view2d, pos.getX(), pos.getY(), labels);
            this.fireLabelChanged(oldLabel);
        }
    }

    public void moveLabel(double deltaX, double deltaY) {
        if (this.graphicLabel != null && (deltaX != 0.0 || deltaY != 0.0)) {
            GraphicLabel oldLabel = this.graphicLabel != null ? this.graphicLabel.clone() : null;
            this.graphicLabel.move(deltaX, deltaY);
            this.fireLabelChanged(oldLabel);
        }
    }

    @Override
    public void updateLabel(Object source, DefaultView2d view2d) {
        this.updateLabel(source, view2d, null);
    }

    public void updateLabel(Object source, DefaultView2d view2d, Point2D pos) {
        AbstractLayerModel model;
        boolean releasedEvent = false;
        ImageElement imageElement = null;
        if (source instanceof MouseEvent) {
            imageElement = this.getImageElement((MouseEvent)source);
            releasedEvent = ((MouseEvent)source).getID() == 502;
        } else if (source instanceof ImageElement) {
            imageElement = (ImageElement)source;
            releasedEvent = true;
        }
        MeasureTool measureToolListener = null;
        boolean isMultiSelection = false;
        AbstractLayerModel abstractLayerModel = model = view2d != null ? view2d.getLayerModel() : null;
        if (model != null) {
            ArrayList<Graphic> selectedGraphics = model.getSelectedGraphics();
            isMultiSelection = selectedGraphics != null && selectedGraphics.size() > 1;
            GraphicsListener[] gfxListeners = model.getGraphicSelectionListeners();
            if (gfxListeners != null) {
                for (GraphicsListener listener : gfxListeners) {
                    if (!(listener instanceof MeasureTool)) continue;
                    measureToolListener = (MeasureTool)listener;
                    break;
                }
            }
        }
        List<MeasureItem> measList = null;
        String[] labels = null;
        if (this.labelVisible || !isMultiSelection) {
            measList = this.getMeasurements(imageElement, releasedEvent, isMultiSelection);
        }
        if (this.labelVisible && measList != null && measList.size() > 0) {
            ArrayList<String> labelList = new ArrayList<String>(measList.size());
            for (MeasureItem item : measList) {
                Measurement measurement;
                if (item == null || (measurement = item.getMeasurement()) == null || !measurement.isGraphicLabel()) continue;
                StringBuilder sb = new StringBuilder();
                String name = measurement.getName();
                Double value = item.getValue();
                String unit = item.getUnit();
                if (name != null) {
                    sb.append(name).append(" : ");
                    if (value != null) {
                        sb.append(DecFormater.oneDecimalUngroup((double)value));
                        if (unit != null) {
                            sb.append(" ").append(unit);
                        }
                    }
                }
                labelList.add(sb.toString());
            }
            if (labelList.size() > 0) {
                labels = labelList.toArray(new String[labelList.size()]);
            }
        }
        this.setLabel(labels, view2d, pos);
        if (measureToolListener != null) {
            measureToolListener.updateMeasuredItems(isMultiSelection ? null : measList);
        }
    }

    @Override
    public void paint(Graphics2D g2d, AffineTransform transform) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        if (this.shape instanceof AdvancedShape) {
            ((AdvancedShape)this.shape).paint(g2d, transform);
        } else if (this.shape != null) {
            Shape drawingShape = transform == null ? this.shape : transform.createTransformedShape(this.shape);
            g2d.setPaint(this.colorPaint);
            g2d.setStroke(this.getStroke(this.lineThickness));
            g2d.draw(drawingShape);
            if (this.isFilled()) {
                g2d.fill(drawingShape);
            }
        }
        g2d.setStroke(oldStroke);
        g2d.setPaint(oldPaint);
        if (this.isSelected()) {
            this.paintHandles(g2d, transform);
        }
        this.paintLabel(g2d, transform);
    }

    protected boolean isResizingOrMoving() {
        return this.resizingOrMoving;
    }

    @Override
    public void paintLabel(Graphics2D g2d, AffineTransform transform) {
        if (this.labelVisible && this.graphicLabel != null) {
            this.graphicLabel.paint(g2d, transform, this.selected);
        }
    }

    protected void paintHandles(Graphics2D g2d, AffineTransform transform) {
        if (!this.isResizingOrMoving()) {
            double size = this.handleSize;
            double halfSize = size / 2.0;
            ArrayList<Point2D.Double> handlePts = new ArrayList<Point2D.Double>(this.handlePointList.size());
            for (Point2D pt : this.handlePointList) {
                if (pt == null) continue;
                handlePts.add(new Point2D.Double(pt.getX(), pt.getY()));
            }
            Point2D[] handlePtArray = handlePts.toArray(new Point2D.Double[handlePts.size()]);
            transform.transform(handlePtArray, 0, handlePtArray, 0, handlePtArray.length);
            Paint oldPaint = g2d.getPaint();
            Stroke oldStroke = g2d.getStroke();
            g2d.setPaint(Color.black);
            for (Point2D point : handlePtArray) {
                g2d.fill(new Rectangle2D.Double(point.getX() - halfSize, point.getY() - halfSize, size, size));
            }
            g2d.setPaint(Color.white);
            g2d.setStroke(new BasicStroke(1.0f));
            for (Point2D point : handlePtArray) {
                g2d.draw(new Rectangle2D.Double(point.getX() - halfSize, point.getY() - halfSize, size, size));
            }
            g2d.setPaint(oldPaint);
            g2d.setStroke(oldStroke);
        }
    }

    public boolean isShapeValid() {
        if (!this.isGraphicComplete()) {
            return false;
        }
        int lastPointIndex = this.handlePointList.size() - 1;
        while (lastPointIndex > 0) {
            Point2D checkPoint = this.handlePointList.get(lastPointIndex);
            ListIterator<Point2D> listIt = this.handlePointList.listIterator(lastPointIndex--);
            while (listIt.hasPrevious()) {
                if (checkPoint == null || !checkPoint.equals(listIt.previous())) continue;
                return false;
            }
        }
        return true;
    }

    protected final boolean isLastPointValid() {
        Point2D lastPt = this.handlePointList.size() > 0 ? this.handlePointList.get(this.handlePointList.size() - 1) : null;
        Point2D previousPt = this.handlePointList.size() > 1 ? this.handlePointList.get(this.handlePointList.size() - 2) : null;
        return lastPt == null || !lastPt.equals(previousPt);
    }

    public DragSequence createMoveDrag() {
        return new DefaultDragSequence();
    }

    public DragSequence createResizeDrag() {
        return this.createResizeDrag(0);
    }

    public DragSequence createResizeDrag(int i) {
        return new DefaultDragSequence(i);
    }

    public DragSequence createDragLabelSequence() {
        return new DragLabelSequence();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertychangelistener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        for (PropertyChangeListener listener : this.pcs.getPropertyChangeListeners()) {
            if (listener != propertychangelistener) continue;
            return;
        }
        this.pcs.addPropertyChangeListener(propertychangelistener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertychangelistener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertychangelistener);
        }
    }

    protected void firePropertyChange(String s, Object obj, Object obj1) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(s, obj, obj1);
        }
    }

    protected void firePropertyChange(String s, int i, int j) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(s, i, j);
        }
    }

    protected void firePropertyChange(String s, boolean flag, boolean flag1) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(s, flag, flag1);
        }
    }

    @Override
    public int getLayerID() {
        return this.layerID;
    }

    @Override
    public void setLayerID(int layerID) {
        this.layerID = layerID;
    }

    protected void fireDrawingChanged() {
        this.fireDrawingChanged(null);
    }

    protected void fireDrawingChanged(Shape oldShape) {
        this.firePropertyChange("bounds", oldShape, this.shape);
    }

    protected void fireLabelChanged() {
        this.fireLabelChanged(null);
    }

    protected void fireLabelChanged(GraphicLabel oldLabel) {
        this.firePropertyChange("graphicLabel", oldLabel, this.graphicLabel);
    }

    protected void fireMoveAction() {
        if (this.isGraphicComplete()) {
            this.firePropertyChange("move", null, this);
        }
    }

    @Override
    public void toFront() {
        if (this.isGraphicComplete()) {
            this.firePropertyChange("toFront", null, this);
        }
    }

    @Override
    public void toBack() {
        if (this.isGraphicComplete()) {
            this.firePropertyChange("toBack", null, this);
        }
    }

    @Override
    public void fireRemoveAction() {
        if (this.isGraphicComplete()) {
            this.firePropertyChange("remove", null, this);
        }
    }

    public void fireRemoveAndRepaintAction() {
        if (this.isGraphicComplete()) {
            this.firePropertyChange("remove.repaint", null, this);
        }
    }

    public String toString() {
        return this.getUIName();
    }

    public AbstractDragGraphic clone() {
        AbstractDragGraphic newGraphic = null;
        try {
            newGraphic = (AbstractDragGraphic)super.clone();
        }
        catch (CloneNotSupportedException clonenotsupportedexception) {
            return null;
        }
        newGraphic.pcs = null;
        newGraphic.shape = null;
        newGraphic.handlePointList = new ArrayList<Point2D>(this.handlePointTotalNumber > 0 ? this.handlePointTotalNumber : 10);
        newGraphic.graphicLabel = null;
        newGraphic.selected = false;
        return newGraphic;
    }

    @Override
    public Graphic deepCopy() {
        AbstractDragGraphic newGraphic = null;
        try {
            newGraphic = (AbstractDragGraphic)super.clone();
        }
        catch (CloneNotSupportedException clonenotsupportedexception) {
            return null;
        }
        newGraphic.pcs = null;
        newGraphic.shape = null;
        newGraphic.handlePointList = new ArrayList<Point2D>(this.handlePointList.size());
        for (Point2D p : this.handlePointList) {
            newGraphic.handlePointList.add(p != null ? (Point2D)p.clone() : null);
        }
        newGraphic.graphicLabel = null;
        newGraphic.selected = false;
        newGraphic.updateShapeOnDrawing(null);
        return newGraphic;
    }

    protected int moveAndResizeOnDrawing(int handlePointIndex, double deltaX, double deltaY, MouseEventDouble mouseEvent) {
        Point2D point;
        if (handlePointIndex == -1) {
            for (Point2D point2 : this.handlePointList) {
                if (point2 == null) continue;
                point2.setLocation(point2.getX() + deltaX, point2.getY() + deltaY);
            }
        } else if (handlePointIndex >= 0 && handlePointIndex < this.handlePointList.size() && (point = this.handlePointList.get(handlePointIndex)) != null) {
            point.setLocation(mouseEvent.getImageCoordinates());
        }
        return handlePointIndex;
    }

    protected abstract void updateShapeOnDrawing(MouseEventDouble var1);

    public class AdvancedShape
    implements Shape {
        protected List<BasicShape> shapeList;
        protected double scalingFactor = 1.0;

        public AdvancedShape(int initialShapeNumber) {
            this.shapeList = new ArrayList<BasicShape>(initialShapeNumber);
        }

        public List<BasicShape> getShapeList() {
            return this.shapeList;
        }

        void addShape(Shape shape) {
            this.addShape(shape, AbstractDragGraphic.this.getStroke(AbstractDragGraphic.this.lineThickness), false);
        }

        void addShape(Shape shape, Stroke stroke, boolean fixedLineWidth) {
            this.shapeList.add(new BasicShape(shape, stroke, fixedLineWidth));
        }

        void addInvShape(Shape shape, Point2D anchorPoint) {
            this.addInvShape(shape, anchorPoint, AbstractDragGraphic.this.getStroke(AbstractDragGraphic.this.lineThickness), false);
        }

        void addInvShape(Shape shape, Point2D anchorPoint, double scalingMin, boolean fixedLineWidth) {
            this.addInvShape(shape, anchorPoint, scalingMin, AbstractDragGraphic.this.getStroke(AbstractDragGraphic.this.lineThickness), fixedLineWidth);
        }

        void addInvShape(Shape shape, Point2D anchorPoint, double scalingMin, Stroke stroke, boolean fixedLineWidth) {
            this.shapeList.add(new InvariantShape(shape, stroke, anchorPoint, scalingMin, fixedLineWidth));
        }

        void addInvShape(Shape shape, Point2D anchorPoint, Stroke stroke, boolean fixedLineWidth) {
            this.shapeList.add(new InvariantShape(shape, stroke, anchorPoint, fixedLineWidth));
        }

        void updateScalingFactor(double scalingFactor) {
            if (scalingFactor == 0.0) {
                throw new IllegalArgumentException("scalingFactor cannot be zero");
            }
            this.scalingFactor = scalingFactor;
        }

        public void updateScalingFactor(AffineTransform transform) {
            this.updateScalingFactor(GeomUtil.extractScalingFactor((AffineTransform)transform));
        }

        public void paint(Graphics2D g2d, AffineTransform transform) {
            this.updateScalingFactor(transform);
            Paint oldPaint = g2d.getPaint();
            Stroke oldStroke = g2d.getStroke();
            g2d.setPaint(AbstractDragGraphic.this.getColorPaint());
            for (BasicShape item : this.shapeList) {
                Shape drawingShape = item.getRealShape();
                if (drawingShape == null) continue;
                if (transform != null) {
                    drawingShape = transform.createTransformedShape(drawingShape);
                }
                g2d.setStroke(item.stroke);
                g2d.draw(drawingShape);
                if (!AbstractDragGraphic.this.isFilled()) continue;
                g2d.fill(drawingShape);
            }
            g2d.setPaint(oldPaint);
            g2d.setStroke(oldStroke);
        }

        public Shape getGeneralShape() {
            if (this.shapeList.size() > 0 && this.shapeList.get(0) != null) {
                return this.shapeList.get(0).getRealShape();
            }
            return null;
        }

        @Override
        public Rectangle getBounds() {
            Rectangle rectangle = null;
            for (BasicShape item : this.shapeList) {
                Shape realShape = item.getRealShape();
                Rectangle bounds = realShape != null ? realShape.getBounds() : null;
                if (bounds == null) continue;
                if (rectangle == null) {
                    rectangle = bounds;
                    continue;
                }
                rectangle.add(bounds);
            }
            return rectangle;
        }

        @Override
        public Rectangle2D getBounds2D() {
            Rectangle2D rectangle = null;
            for (BasicShape item : this.shapeList) {
                Shape realShape = item.getRealShape();
                Rectangle2D bounds = realShape != null ? realShape.getBounds2D() : null;
                if (bounds == null) continue;
                if (rectangle == null) {
                    rectangle = bounds;
                    continue;
                }
                rectangle.add(bounds);
            }
            return rectangle;
        }

        @Override
        public boolean contains(double x, double y) {
            for (BasicShape item : this.shapeList) {
                Shape realShape = item.getRealShape();
                if (realShape == null || !realShape.contains(x, y)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Point2D p) {
            for (BasicShape item : this.shapeList) {
                Shape realShape = item.getRealShape();
                if (realShape == null || !realShape.contains(p)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            for (BasicShape item : this.shapeList) {
                Shape realShape = item.getRealShape();
                if (realShape == null || !realShape.contains(x, y, w, h)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Rectangle2D r) {
            for (BasicShape item : this.shapeList) {
                Shape realShape = item.getRealShape();
                if (realShape == null || !realShape.contains(r)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            for (BasicShape item : this.shapeList) {
                Shape realShape = item.getRealShape();
                if (realShape == null || !realShape.intersects(x, y, w, h)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(Rectangle2D r) {
            for (BasicShape item : this.shapeList) {
                Shape realShape = item.getRealShape();
                if (realShape == null || !realShape.intersects(r)) continue;
                return true;
            }
            return false;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            if (at != null) {
                this.updateScalingFactor(at);
            }
            return this.getFullPathShape().getPathIterator(at);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at, double flatness) {
            if (at != null) {
                this.updateScalingFactor(at);
            }
            return this.getFullPathShape().getPathIterator(at, flatness);
        }

        private Path2D getFullPathShape() {
            Path2D.Double pathShape = new Path2D.Double(1);
            for (BasicShape item : this.shapeList) {
                Shape realShape = item.getRealShape();
                if (realShape == null) continue;
                pathShape.append(realShape, false);
            }
            return pathShape;
        }

        public Area getArea(AffineTransform transform) {
            this.updateScalingFactor(transform);
            double growingSize = (double)AbstractDragGraphic.this.getHandleSize() * 2.0 / this.scalingFactor;
            BasicStroke boundingStroke = new BasicStroke((float)growingSize, 1, 1);
            Area pathBoundingArea = new Area();
            for (BasicShape item : this.shapeList) {
                Area strokedArea = null;
                try {
                    Shape realShape = item.getRealShape();
                    if (realShape != null) {
                        Shape strokedShape = boundingStroke.createStrokedShape(realShape);
                        strokedArea = new Area(strokedShape);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.err.println("This graphic is not drawable, it is deleted");
                    AbstractDragGraphic.this.fireRemoveAction();
                }
                if (strokedArea == null) continue;
                pathBoundingArea.add(new Area(strokedArea));
            }
            return pathBoundingArea;
        }

        class InvariantShape
        extends BasicShape {
            final Point2D anchorPoint;
            final double scalingMin;

            public InvariantShape(Shape shape, Stroke stroke, Point2D anchorPoint, boolean fixedLineWidth) {
                this(shape, stroke, anchorPoint, 0.0, fixedLineWidth);
            }

            public InvariantShape(Shape shape, Stroke stroke, Point2D anchorPoint, double scalingMin, boolean fixedLineWidth) {
                super(shape, stroke, fixedLineWidth);
                if (anchorPoint == null) {
                    throw new IllegalArgumentException();
                }
                if (scalingMin < 0.0) {
                    throw new IllegalArgumentException();
                }
                this.anchorPoint = (Point2D)anchorPoint.clone();
                this.scalingMin = scalingMin;
            }

            @Override
            public Shape getRealShape() {
                double scale = AdvancedShape.this.scalingFactor < this.scalingMin ? this.scalingMin : AdvancedShape.this.scalingFactor;
                return scale != 0.0 ? GeomUtil.getScaledShape((Shape)this.shape, (double)(1.0 / scale), (Point2D)this.anchorPoint) : null;
            }
        }

        public class BasicShape {
            final Shape shape;
            final boolean fixedLineWidth;
            Stroke stroke;

            public BasicShape(Shape shape, Stroke stroke, boolean fixedLineWidth) {
                if (shape == null || stroke == null) {
                    throw new IllegalArgumentException();
                }
                this.shape = shape;
                this.stroke = stroke;
                this.fixedLineWidth = fixedLineWidth;
            }

            public Shape getRealShape() {
                return this.shape;
            }

            public void changelineThickness(float width) {
                BasicStroke s;
                if (!this.fixedLineWidth && this.stroke instanceof BasicStroke && (s = (BasicStroke)this.stroke).getLineWidth() != width) {
                    this.stroke = new BasicStroke(width, s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), s.getDashArray(), s.getDashPhase());
                }
            }
        }
    }

    protected class DefaultDragSequence
    implements DragSequence {
        protected final Point2D lastPoint;
        protected int handlePointIndex;

        protected DefaultDragSequence() {
            this(-1);
        }

        protected DefaultDragSequence(int handlePointIndex) {
            this.handlePointIndex = handlePointIndex;
            this.lastPoint = new Point2D.Double();
        }

        @Override
        public void startDrag(MouseEventDouble mouseEvent) {
            AbstractDragGraphic.this.resizingOrMoving = true;
            this.lastPoint.setLocation(mouseEvent.getImageX(), mouseEvent.getImageY());
            if (!AbstractDragGraphic.this.isGraphicComplete()) {
                if (AbstractDragGraphic.this.handlePointList.isEmpty()) {
                    AbstractDragGraphic.this.handlePointList.add(mouseEvent.getImageCoordinates());
                }
                if (!AbstractDragGraphic.this.isGraphicComplete()) {
                    AbstractDragGraphic.this.handlePointList.add(mouseEvent.getImageCoordinates());
                }
                this.handlePointIndex = AbstractDragGraphic.this.handlePointList.size() - 1;
            }
        }

        @Override
        public void drag(MouseEventDouble mouseEvent) {
            double deltaX = mouseEvent.getImageX() - this.lastPoint.getX();
            double deltaY = mouseEvent.getImageY() - this.lastPoint.getY();
            if (deltaX != 0.0 || deltaY != 0.0) {
                this.lastPoint.setLocation(mouseEvent.getImageCoordinates());
                this.handlePointIndex = AbstractDragGraphic.this.moveAndResizeOnDrawing(this.handlePointIndex, deltaX, deltaY, mouseEvent);
                AbstractDragGraphic.this.updateShapeOnDrawing(mouseEvent);
                AbstractDragGraphic.this.resizingOrMoving = true;
            }
        }

        @Override
        public boolean completeDrag(MouseEventDouble mouseEvent) {
            if (mouseEvent != null) {
                if (!AbstractDragGraphic.this.isGraphicComplete()) {
                    if (AbstractDragGraphic.this.handlePointTotalNumber == -1 && mouseEvent.getClickCount() == 2) {
                        if (!AbstractDragGraphic.this.isLastPointValid()) {
                            AbstractDragGraphic.this.handlePointList.remove(AbstractDragGraphic.this.handlePointList.size() - 1);
                        }
                        AbstractDragGraphic.this.handlePointTotalNumber = AbstractDragGraphic.this.handlePointList.size();
                    } else if (AbstractDragGraphic.this.isLastPointValid()) {
                        AbstractDragGraphic.this.handlePointList.add(mouseEvent.getImageCoordinates());
                        this.handlePointIndex = AbstractDragGraphic.this.handlePointList.size() - 1;
                    }
                } else if (AbstractDragGraphic.this.shape != null && AbstractDragGraphic.this.isShapeValid()) {
                    AbstractDragGraphic.this.resizingOrMoving = false;
                    AbstractDragGraphic.this.shape = null;
                    AbstractDragGraphic.this.updateShapeOnDrawing(mouseEvent);
                    return true;
                }
            }
            return false;
        }
    }

    protected class DragLabelSequence
    implements DragSequence {
        protected final Point2D lastPoint = new Point2D.Double();

        protected DragLabelSequence() {
        }

        @Override
        public void startDrag(MouseEventDouble mouseEvent) {
            this.lastPoint.setLocation(mouseEvent.getImageX(), mouseEvent.getImageY());
        }

        @Override
        public void drag(MouseEventDouble mouseEvent) {
            double deltaX = mouseEvent.getImageX() - this.lastPoint.getX();
            double deltaY = mouseEvent.getImageY() - this.lastPoint.getY();
            if (deltaX != 0.0 || deltaY != 0.0) {
                this.lastPoint.setLocation(mouseEvent.getImageX(), mouseEvent.getImageY());
                AbstractDragGraphic.this.moveLabel(deltaX, deltaY);
            }
        }

        @Override
        public boolean completeDrag(MouseEventDouble mouseEvent) {
            return true;
        }
    }
}

