/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import org.osgi.service.prefs.Preferences;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.service.BundlePreferences;

public class MouseActions {
    public static final int SCROLL_MASK = 2;
    public static final String PREFERENCE_NODE = "mouse.action";
    public static final String P_MOUSE_LEFT = "mouse_left";
    public static final String P_MOUSE_MIDDLE = "mouse_middle";
    public static final String P_MOUSE_RIGHT = "mouse_right";
    public static final String P_MOUSE_WHEEL = "mouse_wheel";
    public static final String LEFT = "left";
    public static final String MIDDLE = "middle";
    public static final String RIGHT = "right";
    public static final String WHEEL = "wheel";
    private String left = ActionW.WINLEVEL.cmd();
    private String middle = ActionW.PAN.cmd();
    private String right = ActionW.CONTEXTMENU.cmd();
    private String wheel = ActionW.SCROLL_SERIES.cmd();
    private int activeButtons = 7170;

    public MouseActions(String left, String middle, String right, String wheel) {
        this.left = left;
        this.middle = middle;
        this.right = right;
        this.wheel = wheel;
    }

    public MouseActions(Preferences prefs) {
        this.applyPreferences(prefs);
    }

    public String getWheel() {
        return this.wheel;
    }

    public void setWheel(String wheel) {
        this.wheel = wheel;
    }

    public String toString() {
        return this.left + "/" + this.right + "/" + this.wheel;
    }

    public String getToolTips() {
        return "<html>Left: " + this.left + "<br>Right: " + this.right + "<br>Wheel: " + this.wheel + "</html>";
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public String getMiddle() {
        return this.middle;
    }

    public void setMiddle(String middle) {
        this.middle = middle;
    }

    public String getAction(String type) {
        if (LEFT.equals(type)) {
            return this.left;
        }
        if (MIDDLE.equals(type)) {
            return this.middle;
        }
        if (RIGHT.equals(type)) {
            return this.right;
        }
        if (WHEEL.equals(type)) {
            return this.wheel;
        }
        return null;
    }

    public int getActiveButtons() {
        return this.activeButtons;
    }

    public void setActiveButtons(int activeButtons) {
        this.activeButtons = activeButtons;
    }

    public void setAction(String type, String action) {
        if (LEFT.equals(type)) {
            this.setLeft(action);
        } else if (MIDDLE.equals(type)) {
            this.setMiddle(action);
        } else if (RIGHT.equals(type)) {
            this.setRight(action);
        } else if (WHEEL.equals(type)) {
            this.setWheel(action);
        }
    }

    public static void loadPreferences(Preferences prefs, boolean defaultValue) {
        if (prefs != null) {
            Preferences p = prefs.node(PREFERENCE_NODE);
            p.put(P_MOUSE_LEFT, defaultValue ? ActionW.WINLEVEL.cmd() : p.get(P_MOUSE_LEFT, ActionW.WINLEVEL.cmd()));
            p.put(P_MOUSE_MIDDLE, defaultValue ? ActionW.PAN.cmd() : p.get(P_MOUSE_MIDDLE, ActionW.PAN.cmd()));
            p.put(P_MOUSE_RIGHT, defaultValue ? ActionW.CONTEXTMENU.cmd() : p.get(P_MOUSE_RIGHT, ActionW.CONTEXTMENU.cmd()));
            p.put(P_MOUSE_WHEEL, defaultValue ? ActionW.ZOOM.cmd() : p.get(P_MOUSE_WHEEL, ActionW.ZOOM.cmd()));
        }
    }

    public void applyPreferences(Preferences prefs) {
        if (prefs != null) {
            Preferences p = prefs.node(PREFERENCE_NODE);
            this.left = p.get(P_MOUSE_LEFT, this.left);
            this.middle = p.get(P_MOUSE_MIDDLE, this.middle);
            this.right = p.get(P_MOUSE_RIGHT, this.right);
            this.wheel = p.get(P_MOUSE_WHEEL, this.wheel);
        }
    }

    public void savePreferences(Preferences prefs) {
        if (prefs != null) {
            Preferences p = prefs.node(PREFERENCE_NODE);
            BundlePreferences.putStringPreferences((Preferences)p, (String)P_MOUSE_LEFT, (String)this.left);
            BundlePreferences.putStringPreferences((Preferences)p, (String)P_MOUSE_MIDDLE, (String)this.middle);
            BundlePreferences.putStringPreferences((Preferences)p, (String)P_MOUSE_RIGHT, (String)this.right);
            BundlePreferences.putStringPreferences((Preferences)p, (String)P_MOUSE_WHEEL, (String)this.wheel);
        }
    }
}

