/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.ui.docking.PluginTool;
import org.weasis.core.ui.editor.SeriesViewer;
import org.weasis.core.ui.util.WtoolBar;

public abstract class MimeSystemAppViewer
implements SeriesViewer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeSystemAppViewer.class);

    @Override
    public void close() {
    }

    public List<MediaSeries> getOpenSeries() {
        return null;
    }

    public static void startAssociatedProgramFromLinux(File file) {
        if (file != null) {
            try {
                String cmd = String.format("xdg-open %s", file.getAbsolutePath());
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e1) {
                LOGGER.error("Cannot open {} with the default system application", (Object)file.getName());
            }
        }
    }

    public static void startAssociatedProgramFromWinCMD(String file) {
        try {
            Runtime.getRuntime().exec("cmd /c \"" + file + '\"');
        }
        catch (IOException e) {
            LOGGER.error("Cannot open {} with the default system application", (Object)file);
            e.printStackTrace();
        }
    }

    public static void startAssociatedProgramFromDesktop(Desktop desktop, File file) {
        if (file != null) {
            try {
                desktop.open(file);
            }
            catch (IOException e1) {
                LOGGER.error("Cannot open {} with the default system application", (Object)file.getName());
            }
        }
    }

    public void removeSeries(MediaSeries sequence) {
    }

    @Override
    public JMenu fillSelectedPluginMenu(JMenu menu) {
        return null;
    }

    @Override
    public WtoolBar[] getToolBar() {
        return null;
    }

    @Override
    public WtoolBar getStatusBar() {
        return null;
    }

    @Override
    public PluginTool[] getToolPanel() {
        return null;
    }

    @Override
    public void setSelected(boolean selected) {
    }

    @Override
    public MediaSeriesGroup getGroupID() {
        return null;
    }
}

