/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.ColorQuantizerOpImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.UnpackedImageData;

public class OctTreeOpImage
extends ColorQuantizerOpImage {
    private int treeSize;
    private int maxTreeDepth = 8;
    private int[] squares = new int[(this.maxColorNum << 1) + 1];

    public OctTreeOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n, int n2, ROI rOI, int n3, int n4) {
        super(renderedImage, map, imageLayout, n, rOI, n3, n4);
        for (int i = -this.maxColorNum; i <= this.maxColorNum; ++i) {
            this.squares[i + this.maxColorNum] = i * i;
        }
        this.colorMap = null;
        this.treeSize = n2;
    }

    protected synchronized void train() {
        Cube cube = new Cube(this.getSourceImage(0), this.maxColorNum);
        cube.constructTree();
        cube.reduction();
        cube.assignment();
        this.colorMap = new LookupTableJAI(cube.colormap);
        this.setProperty("LUT", this.colorMap);
        this.setProperty("JAI.LookupTable", this.colorMap);
    }

    class Cube {
        PlanarImage source;
        int max_colors;
        byte[][] colormap = new byte[3][];
        Node root;
        int depth;
        int colors;
        int nodes;

        Cube(PlanarImage planarImage, int n) {
            this.source = planarImage;
            this.max_colors = n;
            int n2 = n;
            this.depth = 0;
            while (n2 != 0) {
                n2 >>>= 1;
                ++this.depth;
            }
            if (this.depth > OctTreeOpImage.this.maxTreeDepth) {
                this.depth = OctTreeOpImage.this.maxTreeDepth;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        void constructTree() {
            if (OctTreeOpImage.this.roi == null) {
                OctTreeOpImage.this.roi = new ROIShape(this.source.getBounds());
            }
            int n = this.source.getMinTileX();
            int n2 = this.source.getMaxTileX();
            int n3 = this.source.getMinTileY();
            int n4 = this.source.getMaxTileY();
            int n5 = this.source.getMinX();
            int n6 = this.source.getMinY();
            for (int i = n3; i <= n4; ++i) {
                for (int j = n; j <= n2; ++j) {
                    Rectangle rectangle = this.source.getTileRect(j, i);
                    if (!OctTreeOpImage.this.roi.intersects(rectangle)) continue;
                    if (OctTreeOpImage.this.checkForSkippedTiles && rectangle.x >= n5 && rectangle.y >= n6) {
                        int n7 = (OctTreeOpImage.this.xPeriod - (rectangle.x - n5) % OctTreeOpImage.this.xPeriod) % OctTreeOpImage.this.xPeriod;
                        int n8 = (OctTreeOpImage.this.yPeriod - (rectangle.y - n6) % OctTreeOpImage.this.yPeriod) % OctTreeOpImage.this.yPeriod;
                        if (n7 >= rectangle.width || n8 >= rectangle.height) continue;
                    }
                    this.constructTree(this.source.getData(rectangle));
                }
            }
        }

        private void constructTree(Raster raster) {
            LinkedList linkedList;
            if (!OctTreeOpImage.this.isInitialized) {
                OctTreeOpImage.this.srcPA = new PixelAccessor(OctTreeOpImage.this.getSourceImage(0));
                OctTreeOpImage.this.srcSampleType = OctTreeOpImage.this.srcPA.sampleType == -1 ? 0 : OctTreeOpImage.this.srcPA.sampleType;
                OctTreeOpImage.this.isInitialized = true;
            }
            Rectangle rectangle = OctTreeOpImage.this.getSourceImage(0).getBounds().intersection(raster.getBounds());
            if (OctTreeOpImage.this.roi == null) {
                linkedList = new LinkedList();
                linkedList.addLast(rectangle);
            } else {
                linkedList = OctTreeOpImage.this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (linkedList == null) {
                    return;
                }
            }
            ListIterator listIterator = linkedList.listIterator(0);
            int n = raster.getMinX();
            int n2 = raster.getMinY();
            while (listIterator.hasNext()) {
                Rectangle rectangle2 = rectangle.intersection((Rectangle)listIterator.next());
                int n3 = rectangle2.x;
                int n4 = rectangle2.y;
                rectangle2.x = ColorQuantizerOpImage.startPosition(n3, n, OctTreeOpImage.this.xPeriod);
                rectangle2.y = ColorQuantizerOpImage.startPosition(n4, n2, OctTreeOpImage.this.yPeriod);
                rectangle2.width = n3 + rectangle2.width - rectangle2.x;
                rectangle2.height = n4 + rectangle2.height - rectangle2.y;
                if (rectangle2.isEmpty()) continue;
                UnpackedImageData unpackedImageData = OctTreeOpImage.this.srcPA.getPixels(raster, rectangle2, OctTreeOpImage.this.srcSampleType, false);
                switch (unpackedImageData.type) {
                    case 0: {
                        this.constructTreeByte(unpackedImageData);
                    }
                }
            }
        }

        private void constructTreeByte(UnpackedImageData unpackedImageData) {
            Rectangle rectangle = unpackedImageData.rect;
            byte[][] byArray = unpackedImageData.getByteData();
            int n = unpackedImageData.lineStride;
            int n2 = unpackedImageData.pixelStride;
            byte[] byArray2 = byArray[0];
            byte[] byArray3 = byArray[1];
            byte[] byArray4 = byArray[2];
            int n3 = n * OctTreeOpImage.this.yPeriod;
            int n4 = n2 * OctTreeOpImage.this.xPeriod;
            int n5 = rectangle.height * n;
            for (int i = 0; i < n5; i += n3) {
                int n6 = i + rectangle.width * n2;
                for (int j = i; j < n6; j += n4) {
                    int n7 = byArray2[j + unpackedImageData.bandOffsets[0]] & 0xFF;
                    int n8 = byArray3[j + unpackedImageData.bandOffsets[1]] & 0xFF;
                    int n9 = byArray4[j + unpackedImageData.bandOffsets[2]] & 0xFF;
                    if (this.nodes > OctTreeOpImage.this.treeSize) {
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    for (int k = 1; k <= this.depth; ++k) {
                        int n10 = (n7 > node.mid_red ? 1 : 0) | (n8 > node.mid_green ? 1 : 0) << 1 | (n9 > node.mid_blue ? 1 : 0) << 2;
                        node = node.child[n10] == null ? new Node(node, n10, k) : node.child[n10];
                        ++node.number_pixels;
                    }
                    ++node.unique;
                    node.total_red += n7;
                    node.total_green += n8;
                    node.total_blue += n9;
                }
            }
        }

        void reduction() {
            int n = (this.source.getWidth() + OctTreeOpImage.this.xPeriod - 1) / OctTreeOpImage.this.xPeriod * (this.source.getHeight() + OctTreeOpImage.this.yPeriod - 1) / OctTreeOpImage.this.yPeriod;
            int n2 = Math.max(1, n / (this.max_colors * 8));
            while (this.colors > this.max_colors) {
                this.colors = 0;
                n2 = this.root.reduce(n2, Integer.MAX_VALUE);
            }
        }

        void assignment() {
            this.colormap = new byte[3][this.colors];
            this.colors = 0;
            this.root.colormap();
        }

        class Node {
            Cube cube;
            Node parent;
            Node[] child;
            int nchild;
            int id;
            int level;
            int mid_red;
            int mid_green;
            int mid_blue;
            int number_pixels;
            int unique;
            int total_red;
            int total_green;
            int total_blue;
            int color_number;

            Node(Cube cube2) {
                this.cube = cube2;
                this.parent = this;
                this.child = new Node[8];
                this.id = 0;
                this.level = 0;
                this.number_pixels = Integer.MAX_VALUE;
                this.mid_red = ((Cube)Cube.this).OctTreeOpImage.this.maxColorNum + 1 >> 1;
                this.mid_green = ((Cube)Cube.this).OctTreeOpImage.this.maxColorNum + 1 >> 1;
                this.mid_blue = ((Cube)Cube.this).OctTreeOpImage.this.maxColorNum + 1 >> 1;
            }

            Node(Node node, int n, int n2) {
                this.cube = node.cube;
                this.parent = node;
                this.child = new Node[8];
                this.id = n;
                this.level = n2;
                ++this.cube.nodes;
                if (n2 == this.cube.depth) {
                    ++this.cube.colors;
                }
                ++node.nchild;
                node.child[n] = this;
                int n3 = 1 << OctTreeOpImage.this.maxTreeDepth - n2 >> 1;
                this.mid_red = node.mid_red + ((n & 1) > 0 ? n3 : -n3);
                this.mid_green = node.mid_green + ((n & 2) > 0 ? n3 : -n3);
                this.mid_blue = node.mid_blue + ((n & 4) > 0 ? n3 : -n3);
            }

            void pruneChild() {
                --this.parent.nchild;
                this.parent.unique += this.unique;
                this.parent.total_red += this.total_red;
                this.parent.total_green += this.total_green;
                this.parent.total_blue += this.total_blue;
                this.parent.child[this.id] = null;
                --this.cube.nodes;
                this.cube = null;
                this.parent = null;
            }

            void pruneLevel() {
                if (this.nchild != 0) {
                    for (int i = 0; i < 8; ++i) {
                        if (this.child[i] == null) continue;
                        this.child[i].pruneLevel();
                    }
                }
                if (this.level == this.cube.depth) {
                    this.pruneChild();
                }
            }

            int reduce(int n, int n2) {
                if (this.nchild != 0) {
                    for (int i = 0; i < 8; ++i) {
                        if (this.child[i] == null) continue;
                        n2 = this.child[i].reduce(n, n2);
                    }
                }
                if (this.number_pixels <= n) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0) {
                        ++this.cube.colors;
                    }
                    if (this.number_pixels < n2) {
                        n2 = this.number_pixels;
                    }
                }
                return n2;
            }

            void colormap() {
                if (this.nchild != 0) {
                    for (int i = 0; i < 8; ++i) {
                        if (this.child[i] == null) continue;
                        this.child[i].colormap();
                    }
                }
                if (this.unique != 0) {
                    this.cube.colormap[0][this.cube.colors] = (byte)((this.total_red + (this.unique >> 1)) / this.unique);
                    this.cube.colormap[1][this.cube.colors] = (byte)((this.total_green + (this.unique >> 1)) / this.unique);
                    this.cube.colormap[2][this.cube.colors] = (byte)((this.total_blue + (this.unique >> 1)) / this.unique);
                    this.color_number = this.cube.colors++;
                }
            }
        }
    }
}

