/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

class HistogramHash {
    int capacity;
    int[] colors;
    int[] counts;
    int size;
    int hashsize;
    boolean packed = false;
    int[] newColors;
    int[] newCounts;

    public HistogramHash(int n) {
        this.capacity = n;
        this.hashsize = n * 4 / 3;
        this.colors = new int[this.hashsize];
        this.counts = new int[this.hashsize];
    }

    void init() {
        this.size = 0;
        this.packed = false;
        for (int i = 0; i < this.hashsize; ++i) {
            this.colors[i] = -1;
            this.counts[i] = 0;
        }
    }

    boolean insert(int n) {
        int n2 = this.hashCode(n);
        if (this.colors[n2] == -1) {
            this.colors[n2] = n;
            int n3 = n2;
            this.counts[n3] = this.counts[n3] + 1;
            ++this.size;
            return this.size <= this.capacity;
        }
        if (this.colors[n2] == n) {
            int n4 = n2;
            this.counts[n4] = this.counts[n4] + 1;
            return this.size <= this.capacity;
        }
        for (int i = n2 + 1; i != n2; ++i) {
            if (this.colors[i %= this.hashsize] == -1) {
                this.colors[i] = n;
                int n5 = i;
                this.counts[n5] = this.counts[n5] + 1;
                ++this.size;
                return this.size <= this.capacity;
            }
            if (this.colors[i] != n) continue;
            int n6 = i;
            this.counts[n6] = this.counts[n6] + 1;
            return this.size <= this.capacity;
        }
        return this.size <= this.capacity;
    }

    boolean isFull() {
        return this.size > this.capacity;
    }

    void put(int n, int n2) {
        int n3 = this.hashCode(n);
        if (this.colors[n3] == -1) {
            this.colors[n3] = n;
            this.counts[n3] = n2;
            ++this.size;
            return;
        }
        if (this.colors[n3] == n) {
            this.counts[n3] = n2;
            return;
        }
        for (int i = n3 + 1; i != n3; ++i) {
            if (this.colors[i %= this.hashsize] == -1) {
                this.colors[i] = n;
                this.counts[i] = n2;
                ++this.size;
                return;
            }
            if (this.colors[i] != n) continue;
            this.counts[i] = n2;
            return;
        }
    }

    int get(int n) {
        int n2 = this.hashCode(n);
        if (this.colors[n2] == n) {
            return this.counts[n2];
        }
        for (int i = n2 + 1; i != n2; ++i) {
            if (this.colors[i %= this.hashsize] != n) continue;
            return this.counts[i];
        }
        return -1;
    }

    int[] getCounts() {
        if (!this.packed) {
            this.pack();
        }
        return this.newCounts;
    }

    int[] getColors() {
        if (!this.packed) {
            this.pack();
        }
        return this.newColors;
    }

    void pack() {
        this.newColors = new int[this.capacity];
        this.newCounts = new int[this.capacity];
        int n = 0;
        for (int i = 0; i < this.hashsize; ++i) {
            if (this.colors[i] == -1) continue;
            this.newColors[n] = this.colors[i];
            this.newCounts[n] = this.counts[i];
            ++n;
        }
        this.packed = true;
    }

    int hashCode(int n) {
        return ((n >> 16) * 33023 + (n >> 8 & 0xFF) * 30013 + (n & 0xFF) * 27011) % this.hashsize;
    }
}

