/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AbsoluteOpImage
extends PointOpImage {
    public AbsoluteOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        if (rasterAccessor2.isBinary()) {
            byte[] byArray = rasterAccessor2.getBinaryDataArray();
            System.arraycopy(rasterAccessor.getBinaryDataArray(), 0, byArray, 0, byArray.length);
            rasterAccessor2.copyBinaryDataToRaster();
            return;
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getByteDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getByteDataArrays());
                break;
            }
            case 2: {
                this.shortAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getShortDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getShortDataArrays());
                break;
            }
            case 1: {
                this.ushortAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getShortDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getShortDataArrays());
                break;
            }
            case 3: {
                this.intAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getIntDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getIntDataArrays());
                break;
            }
            case 4: {
                this.floatAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getFloatDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getFloatDataArrays());
                break;
            }
            case 5: {
                this.doubleAbsolute(rasterAccessor2.getNumBands(), rasterAccessor2.getWidth(), rasterAccessor2.getHeight(), rasterAccessor.getScanlineStride(), rasterAccessor.getPixelStride(), rasterAccessor.getBandOffsets(), rasterAccessor.getDoubleDataArrays(), rasterAccessor2.getScanlineStride(), rasterAccessor2.getPixelStride(), rasterAccessor2.getBandOffsets(), rasterAccessor2.getDoubleDataArrays());
            }
        }
        if (rasterAccessor2.needsClamping()) {
            rasterAccessor2.clampDataArrays();
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void byteAbsolute(int n, int n2, int n3, int n4, int n5, int[] nArray, byte[][] byArray, int n6, int n7, int[] nArray2, byte[][] byArray2) {
        for (int i = 0; i < n; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n2; ++k) {
                    byArray4[n11] = byArray3[n10];
                    n10 += n5;
                    n11 += n7;
                }
                n8 += n4;
                n9 += n6;
            }
        }
    }

    private void shortAbsolute(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2) {
        for (int i = 0; i < n; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n2; ++k) {
                    short s = sArray3[n10];
                    sArray4[n11] = s != Short.MIN_VALUE && (s & Short.MIN_VALUE) != 0 ? (short)(-sArray3[n10]) : sArray3[n10];
                    n10 += n5;
                    n11 += n7;
                }
                n8 += n4;
                n9 += n6;
            }
        }
    }

    private void ushortAbsolute(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2) {
        for (int i = 0; i < n; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n2; ++k) {
                    sArray4[n11] = sArray3[n10];
                    n10 += n5;
                    n11 += n7;
                }
                n8 += n4;
                n9 += n6;
            }
        }
    }

    private void intAbsolute(int n, int n2, int n3, int n4, int n5, int[] nArray, int[][] nArray2, int n6, int n7, int[] nArray3, int[][] nArray4) {
        for (int i = 0; i < n; ++i) {
            int[] nArray5 = nArray2[i];
            int[] nArray6 = nArray4[i];
            int n8 = nArray[i];
            int n9 = nArray3[i];
            for (int j = 0; j < n3; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n2; ++k) {
                    int n12 = nArray5[n10];
                    nArray6[n11] = n12 != Integer.MIN_VALUE && (n12 & Integer.MIN_VALUE) != 0 ? -nArray5[n10] : nArray5[n10];
                    n10 += n5;
                    n11 += n7;
                }
                n8 += n4;
                n9 += n6;
            }
        }
    }

    private void floatAbsolute(int n, int n2, int n3, int n4, int n5, int[] nArray, float[][] fArray, int n6, int n7, int[] nArray2, float[][] fArray2) {
        for (int i = 0; i < n; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n2; ++k) {
                    fArray4[n11] = fArray3[n10] <= 0.0f ? 0.0f - fArray3[n10] : fArray3[n10];
                    n10 += n5;
                    n11 += n7;
                }
                n8 += n4;
                n9 += n6;
            }
        }
    }

    private void doubleAbsolute(int n, int n2, int n3, int n4, int n5, int[] nArray, double[][] dArray, int n6, int n7, int[] nArray2, double[][] dArray2) {
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n3; ++j) {
                int n10 = n8;
                int n11 = n9;
                for (int k = 0; k < n2; ++k) {
                    dArray4[n11] = dArray3[n10] <= 0.0 ? 0.0 - dArray3[n10] : dArray3[n10];
                    n10 += n5;
                    n11 += n7;
                }
                n8 += n4;
                n9 += n6;
            }
        }
    }
}

