/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import com.sun.medialib.mlib.mediaLibImageColormap;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;

final class MlibOrderedDitherOpImage
extends PointOpImage {
    private static final int DMASK_SCALE_EXPONENT = 16;
    protected mediaLibImageColormap mlibColormap;
    protected int[][] dmask;
    protected int dmaskWidth;
    protected int dmaskHeight;
    protected int dmaskScale;

    static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, ColorCube colorCube) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout(renderedImage) : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (colorCube.getNumBands() == 1 && colorCube.getNumEntries() == 2 && !ImageUtil.isBinary(imageLayout2.getSampleModel(renderedImage))) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
            colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        if ((imageLayout == null || !imageLayout2.isValid(512)) && renderedImage.getSampleModel().getDataType() == 0 && imageLayout2.getSampleModel(null).getDataType() == 0 && colorCube.getDataType() == 0 && colorCube.getNumBands() == 3 && ((colorModel = renderedImage.getColorModel()) == null || colorModel != null && colorModel.getColorSpace().isCS_sRGB())) {
            int n = colorCube.getNumEntries();
            byte[][] byArray = new byte[3][256];
            for (int i = 0; i < 3; ++i) {
                int n2;
                byte[] byArray2 = byArray[i];
                byte[] byArray3 = colorCube.getByteData(i);
                int n3 = colorCube.getOffset(i);
                int n4 = n3 + n;
                for (n2 = 0; n2 < n3; ++n2) {
                    byArray2[n2] = 0;
                }
                for (n2 = n3; n2 < n4; ++n2) {
                    byArray2[n2] = byArray3[n2 - n3];
                }
                for (n2 = n4; n2 < 256; ++n2) {
                    byArray2[n2] = -1;
                }
            }
            imageLayout2.setColorModel(new IndexColorModel(8, 256, byArray[0], byArray[1], byArray[2]));
        }
        return imageLayout2;
    }

    public MlibOrderedDitherOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, ColorCube colorCube, KernelJAI[] kernelJAIArray) {
        super(renderedImage, MlibOrderedDitherOpImage.layoutHelper(imageLayout, renderedImage, colorCube), map, true);
        this.mlibColormap = Image.ColorDitherInit(colorCube.getDimension(), 1, ImageUtil.isBinary(this.sampleModel) ? 0 : 1, colorCube.getNumBands(), colorCube.getNumEntries(), colorCube.getOffset(), colorCube.getByteData());
        this.dmaskWidth = kernelJAIArray[0].getWidth();
        this.dmaskHeight = kernelJAIArray[0].getHeight();
        this.dmaskScale = 65536;
        int n = kernelJAIArray.length;
        this.dmask = new int[n][];
        for (int i = 0; i < n; ++i) {
            KernelJAI kernelJAI = kernelJAIArray[i];
            if (kernelJAI.getWidth() != this.dmaskWidth || kernelJAI.getHeight() != this.dmaskHeight) {
                throw new IllegalArgumentException(JaiI18N.getString("MlibOrderedDitherOpImage0"));
            }
            float[] fArray = kernelJAIArray[i].getKernelData();
            int n2 = fArray.length;
            this.dmask[i] = new int[n2];
            int[] nArray = this.dmask[i];
            for (int j = 0; j < n2; ++j) {
                nArray[j] = (int)(fArray[j] * (float)this.dmaskScale);
            }
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        int n2;
        Raster raster = rasterArray[0];
        if (ImageUtil.isBinary(writableRaster.getSampleModel())) {
            n2 = MediaLibAccessor.findCompatibleTag(rasterArray, raster);
            n = writableRaster.getSampleModel().getDataType() | 0x100 | 0;
        } else {
            n2 = n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        }
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(rasterArray[0], rectangle, n2, false);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n, true);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        Image.ColorOrderedDitherMxN(mediaLibImageArray2[0], mediaLibImageArray[0], this.dmask, this.dmaskWidth, this.dmaskHeight, 16, this.mlibColormap);
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

