/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;
import javax.imageio.stream.ImageInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.weasis.core.api.Messages;

public class FileUtil {
    private static final double BASE = 1024.0;
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    private static final DecimalFormat df = new DecimalFormat("#.##");

    public static void safeClose(Closeable object) {
        try {
            if (object != null) {
                object.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void safeClose(ImageInputStream stream) {
        try {
            if (stream != null) {
                stream.flush();
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final void deleteDirectoryContents(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileUtil.deleteDirectoryContents(f);
                    continue;
                }
                try {
                    f.delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static void safeClose(XMLStreamWriter writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public static void safeClose(XMLStreamReader xmler) {
        try {
            if (xmler != null) {
                xmler.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public static boolean isWriteable(File file) {
        if (file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
        } else {
            try {
                String parentDir = file.getParent();
                if (parentDir != null) {
                    File outputDir = new File(file.getParent());
                    if (!outputDir.exists()) {
                        outputDir.mkdirs();
                    } else if (!outputDir.isDirectory()) {
                        outputDir.mkdirs();
                    }
                }
                file.createNewFile();
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return true;
    }

    public static String nameWithoutExtension(String fn) {
        if (fn == null) {
            return null;
        }
        int i = fn.lastIndexOf(46);
        if (i > 0) {
            return fn.substring(0, i);
        }
        return fn;
    }

    public static int writeFile(URL url, File outFilename) {
        FileOutputStream outputStream;
        InputStream input;
        try {
            input = url.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        try {
            outputStream = new FileOutputStream(outFilename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
        return FileUtil.writeFile(input, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeFile(InputStream inputStream, OutputStream out) {
        if (inputStream == null && out == null) {
            return 0;
        }
        try {
            int offset;
            byte[] buf = new byte[4096];
            while ((offset = inputStream.read(buf)) > 0) {
                out.write(buf, 0, offset);
            }
            int n = -1;
            return n;
        }
        catch (InterruptedIOException e) {
            int n = e.bytesTransferred;
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            FileUtil.safeClose(inputStream);
            FileUtil.safeClose(out);
        }
    }

    public static String formatSize(double size) {
        if (size >= 1.073741824E9) {
            return df.format(size / 1.073741824E9) + Messages.getString("FileUtil.gb");
        }
        if (size >= 1048576.0) {
            return df.format(size / 1048576.0) + Messages.getString("FileUtil.mb");
        }
        if (size >= 1024.0) {
            return df.format(size / 1024.0) + Messages.getString("FileUtil.kb");
        }
        return (int)size + Messages.getString("FileUtil.bytes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nioWriteFile(FileInputStream inputStream, FileOutputStream out) {
        if (inputStream == null && out == null) {
            return false;
        }
        try {
            FileChannel fci = inputStream.getChannel();
            FileChannel fco = out.getChannel();
            fco.transferFrom(fci, 0L, fci.size());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtil.safeClose(inputStream);
            FileUtil.safeClose(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nioWriteFile(InputStream in, OutputStream out, int bufferSize) {
        if (in == null && out == null) {
            return false;
        }
        try {
            ReadableByteChannel readChannel = Channels.newChannel(in);
            WritableByteChannel writeChannel = Channels.newChannel(out);
            ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
            while (readChannel.read(buffer) != -1) {
                buffer.flip();
                writeChannel.write(buffer);
                buffer.clear();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtil.safeClose(in);
            FileUtil.safeClose(out);
        }
    }
}

