/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.service;

import java.util.Properties;

public class WProperties
extends Properties {
    public void putIntProperty(String key, int value) {
        if (this.isValid(key, value)) {
            this.put(key, String.valueOf(value));
        }
    }

    public int getIntProperty(String key, int def) {
        String value;
        int result = def;
        if (this.isKeyValid(key) && (value = this.getProperty(key)) != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    public void putLongProperty(String key, long value) {
        if (this.isValid(key, value)) {
            this.put(key, String.valueOf(value));
        }
    }

    public long getLongProperty(String key, long def) {
        String value;
        long result = def;
        if (this.isKeyValid(key) && (value = this.getProperty(key)) != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    public void putBooleanProperty(String key, boolean value) {
        if (this.isValid(key, value)) {
            this.put(key, String.valueOf(value));
        }
    }

    public boolean getBooleanProperty(String key, boolean def) {
        String value;
        boolean result = def;
        if (this.isKeyValid(key) && (value = this.getProperty(key)) != null) {
            if (value.equalsIgnoreCase("true")) {
                result = true;
            } else if (value.equalsIgnoreCase("false")) {
                result = false;
            }
        }
        return result;
    }

    public void putFloatProperty(String key, float value) {
        if (this.isValid(key, Float.valueOf(value))) {
            this.put(key, String.valueOf(value));
        }
    }

    public float getFloatProperty(String key, float def) {
        String value;
        float result = def;
        if (this.isKeyValid(key) && (value = this.getProperty(key)) != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    public void putDoubleProperty(String key, double value) {
        if (this.isValid(key, value)) {
            this.put(key, String.valueOf(value));
        }
    }

    public double getDoubleProperty(String key, double def) {
        String value;
        double result = def;
        if (this.isKeyValid(key) && (value = this.getProperty(key)) != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean isValid(String key, Object value) {
        return key != null && value != null;
    }

    private boolean isKeyValid(String key) {
        return key != null;
    }
}

