/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.media.data.Codec;
import org.weasis.core.api.service.WProperties;
import org.weasis.core.api.util.FileUtil;

public class BundleTools {
    public static final List<Codec> CODEC_PLUGINS;
    private static final File propsFile;
    public static final WProperties SYSTEM_PREFERENCES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Codec getCodec(String mimeType, String preferredCodec) {
        Codec codec = null;
        List<Codec> list = CODEC_PLUGINS;
        synchronized (list) {
            for (Codec c : CODEC_PLUGINS) {
                if (!c.isMimeTypeSupported(mimeType)) continue;
                if (c.getCodecName().equals(preferredCodec)) {
                    codec = c;
                    break;
                }
                if (codec != null) continue;
                codec = c;
            }
            return codec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveSystemPreferences() {
        if (propsFile.canRead()) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(propsFile);
                SYSTEM_PREFERENCES.store(fout, null);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                FileUtil.safeClose(fout);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        FileUtil.safeClose(fout);
                        throw throwable;
                    }
                }
                FileUtil.safeClose(fout);
            }
            FileUtil.safeClose(fout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        block13: {
            block12: {
                CODEC_PLUGINS = Collections.synchronizedList(new ArrayList());
                String user = System.getProperty("weasis.user", null);
                if (user == null) {
                    propsFile = new File(AbstractProperties.WEASIS_PATH, "weasis.properties");
                } else {
                    File dir = new File(AbstractProperties.WEASIS_PATH + File.separator + "preferences" + File.separator + user);
                    try {
                        dir.mkdirs();
                    }
                    catch (Exception e) {
                        dir = new File(AbstractProperties.WEASIS_PATH);
                        e.printStackTrace();
                    }
                    propsFile = new File(dir, "weasis.properties");
                }
                SYSTEM_PREFERENCES = new WProperties();
                if (!propsFile.canRead()) break block12;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(propsFile);
                    SYSTEM_PREFERENCES.load(fis);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    FileUtil.safeClose(fis);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            FileUtil.safeClose(fis);
                            throw throwable;
                        }
                    }
                    FileUtil.safeClose(fis);
                }
                FileUtil.safeClose(fis);
                break block13;
            }
            try {
                propsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

