/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.media.data;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.media.jai.PlanarImage;
import javax.swing.SwingUtilities;
import org.weasis.core.api.Messages;
import org.weasis.core.api.explorer.ObservableEvent;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.MediaSeriesGroupNode;
import org.weasis.core.api.media.data.SeriesImporter;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.media.data.Thumbnail;

public abstract class Series<E extends MediaElement>
extends MediaSeriesGroupNode
implements MediaSeries<E> {
    private static final Random RANDOM = new Random();
    public static DataFlavor sequenceDataFlavor;
    private final DataFlavor[] flavors = new DataFlavor[]{sequenceDataFlavor};
    private PropertyChangeSupport propertyChange = null;
    protected final List<E> medias;
    protected SeriesImporter seriesLoader;
    private double fileSize;

    public Series(TagW tagID, Object identifier, TagW displayTag) {
        this(tagID, identifier, displayTag, null);
    }

    public Series(TagW tagID, Object identifier, TagW displayTag, int initialCapacity) {
        this(tagID, identifier, displayTag, new ArrayList(initialCapacity));
    }

    public Series(TagW tagID, Object identifier, TagW displayTag, List<E> list) {
        super(tagID, identifier, displayTag);
        if (list == null) {
            list = new ArrayList();
            this.fileSize = 0.0;
        }
        this.medias = Collections.synchronizedList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Comparator<E> comparator) {
        List<E> list = this.medias;
        synchronized (list) {
            Collections.sort(this.medias, comparator);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public void add(E media) {
        this.medias.add(media);
    }

    @Override
    public void add(int index, E media) {
        this.medias.add(index, media);
    }

    @Override
    public void addAll(Collection<? extends E> c) {
        this.medias.addAll(c);
    }

    @Override
    public void addAll(int index, Collection<? extends E> c) {
        this.medias.addAll(index, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E getMedia(MediaSeries.MEDIA_POSITION position) {
        List<E> list = this.medias;
        synchronized (list) {
            int size = this.medias.size();
            if (size == 0) {
                return null;
            }
            int pos = 0;
            if (MediaSeries.MEDIA_POSITION.FIRST.equals((Object)position)) {
                pos = 0;
            } else if (MediaSeries.MEDIA_POSITION.MIDDLE.equals((Object)position)) {
                pos = size / 2;
            } else if (MediaSeries.MEDIA_POSITION.LAST.equals((Object)position)) {
                pos = size - 1;
            } else if (MediaSeries.MEDIA_POSITION.RANDOM.equals((Object)position)) {
                pos = RANDOM.nextInt(size);
            }
            return (E)((MediaElement)this.medias.get(pos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getImageIndex(E source) {
        if (source == null) {
            return -1;
        }
        List<E> list = this.medias;
        synchronized (list) {
            for (int i = 0; i < this.medias.size(); ++i) {
                if (this.medias.get(i) != source) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final List<E> getMedias() {
        return this.medias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E getMedia(int index) {
        List<E> list = this.medias;
        synchronized (list) {
            if (index >= 0 && index < this.medias.size()) {
                return (E)((MediaElement)this.medias.get(index));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<E> list = this.medias;
        synchronized (list) {
            for (MediaElement media : this.medias) {
                media.dispose();
            }
        }
        this.medias.clear();
        Thumbnail thumb = (Thumbnail)this.getTagValue(TagW.Thumbnail);
        if (thumb != null) {
            thumb.dispose();
        }
        if (this.propertyChange != null) {
            PropertyChangeListener[] listeners;
            for (PropertyChangeListener propertyChangeListener : listeners = this.propertyChange.getPropertyChangeListeners()) {
                this.propertyChange.removePropertyChangeListener(propertyChangeListener);
            }
        }
        this.seriesLoader = null;
    }

    @Override
    public SeriesImporter getSeriesLoader() {
        return this.seriesLoader;
    }

    @Override
    public void setSeriesLoader(SeriesImporter seriesLoader) {
        this.seriesLoader = seriesLoader;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return sequenceDataFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (sequenceDataFlavor.equals(flavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertychangelistener) {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        this.propertyChange.addPropertyChangeListener(propertychangelistener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertychangelistener) {
        if (this.propertyChange != null) {
            this.propertyChange.removePropertyChangeListener(propertychangelistener);
        }
    }

    public void firePropertyChange(final ObservableEvent event) {
        if (this.propertyChange != null) {
            if (event == null) {
                throw new NullPointerException();
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.propertyChange.firePropertyChange(event);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Series.this.propertyChange.firePropertyChange(event);
                    }
                });
            }
        }
    }

    @Override
    public int size() {
        return this.medias.size();
    }

    @Override
    public boolean isOpen() {
        Boolean open = (Boolean)this.getTagValue(TagW.SeriesOpen);
        return open == null ? false : open;
    }

    @Override
    public String getToolTips() {
        ImageElement image;
        PlanarImage img;
        StringBuffer toolTips = new StringBuffer();
        toolTips.append("<html>");
        Object media = this.getMedia(MediaSeries.MEDIA_POSITION.MIDDLE);
        if (media instanceof ImageElement && (img = (image = (ImageElement)media).getImage()) != null) {
            toolTips.append(Messages.getString("Series.img_size") + img.getWidth() + "x" + img.getHeight());
        }
        toolTips.append("</html>");
        return toolTips.toString();
    }

    protected void addToolTipsElement(StringBuffer toolTips, String title, TagW tag) {
        Object tagValue = this.getTagValue(tag);
        toolTips.append(title);
        toolTips.append(tagValue == null ? "" : tagValue);
        toolTips.append("<br>");
    }

    @Override
    public void setOpen(boolean open) {
        if (this.isOpen() != open) {
            this.setTag(TagW.SeriesOpen, open);
            Thumbnail thumb = (Thumbnail)this.getTagValue(TagW.Thumbnail);
            if (thumb != null) {
                thumb.repaint();
            }
        }
    }

    @Override
    public boolean isSelected() {
        Boolean selected = (Boolean)this.getTagValue(TagW.SeriesSelected);
        return selected == null ? false : selected;
    }

    @Override
    public void setSelected(boolean selected, int selectedImage) {
        if (this.isSelected() != selected) {
            this.setTag(TagW.SeriesSelected, selected);
            Thumbnail thumb = (Thumbnail)this.getTagValue(TagW.Thumbnail);
            if (thumb != null) {
                thumb.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLoaders() {
        List<E> list = this.medias;
        synchronized (list) {
            for (int i = 0; i < this.medias.size(); ++i) {
                MediaElement media = (MediaElement)this.medias.get(i);
                if (media.getMediaReader() == null) continue;
                media.getMediaReader().reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMediaContains(TagW tag, Object val) {
        if (val != null) {
            List<E> list = this.medias;
            synchronized (list) {
                for (int i = 0; i < this.medias.size(); ++i) {
                    Object val2 = ((MediaElement)this.medias.get(i)).getTagValue(tag);
                    if (!val.equals(val2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getNearestIndex(double location) {
        return -1;
    }

    public synchronized void setFileSize(double size) {
        this.fileSize = size;
    }

    @Override
    public synchronized double getFileSize() {
        return this.fileSize;
    }

    static {
        try {
            sequenceDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + Series.class.getName(), null, Series.class.getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

