/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.media.data;

import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.image.util.ImageToolkit;
import org.weasis.core.api.image.util.Unit;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaReader;
import org.weasis.core.api.media.data.SoftHashMap;
import org.weasis.core.api.media.data.TagW;

public class ImageElement
extends MediaElement<PlanarImage> {
    private static final Logger logger = LoggerFactory.getLogger(ImageElement.class);
    public static final ExecutorService IMAGE_LOADER = Executors.newFixedThreadPool(1);
    private static final SoftHashMap<ImageElement, PlanarImage> mCache = new SoftHashMap<ImageElement, PlanarImage>(){

        public Reference<? extends PlanarImage> getReference(ImageElement key) {
            return (Reference)this.hash.get(key);
        }

        @Override
        public void removeElement(Reference<? extends PlanarImage> soft) {
            ImageElement key = (ImageElement)this.reverseLookup.remove(soft);
            if (key != null) {
                this.hash.remove(key);
                MediaReader reader = key.getMediaReader();
                key.setTag(TagW.ImageCache, false);
                if (reader != null) {
                    reader.close();
                }
            }
        }
    };
    protected boolean readable = true;
    protected double pixelSizeX = 1.0;
    protected double pixelSizeY = 1.0;
    protected Unit pixelSpacingUnit = Unit.PIXEL;
    protected String pixelSizeCalibrationDescription = null;
    protected String pixelValueUnit = null;
    protected float maxValue;
    protected float minValue;

    public ImageElement(MediaReader<PlanarImage> mediaIO, Object key) {
        super(mediaIO, key);
    }

    public void findMinMaxValues(RenderedImage img) throws OutOfMemoryError {
        if (img != null && this.minValue == 0.0f && this.maxValue == 0.0f) {
            int datatype = img.getSampleModel().getDataType();
            if (datatype == 0) {
                this.minValue = 0.0f;
                this.maxValue = 255.0f;
            } else {
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(img);
                RenderedOp dst = JAI.create((String)"extrema", (ParameterBlock)pb, (RenderingHints)ImageToolkit.NOCACHE_HINT);
                double[][] extrema = (double[][])dst.getProperty("extrema");
                double min = Double.MAX_VALUE;
                double max = -1.7976931348623157E308;
                int numBands = dst.getSampleModel().getNumBands();
                for (int i = 0; i < numBands; ++i) {
                    min = Math.min(min, extrema[0][i]);
                    max = Math.max(max, extrema[1][i]);
                }
                this.minValue = (int)min;
                this.maxValue = (int)max;
            }
        }
    }

    protected boolean isGrayImage(RenderedImage source) {
        return source.getSampleModel().getNumBands() <= 1 && !(source.getColorModel() instanceof IndexColorModel);
    }

    public float getPixelWindow(float window) {
        return window;
    }

    public float getPixelLevel(float level) {
        return level;
    }

    public float getDefaultWindow() {
        return this.maxValue - this.minValue;
    }

    public float getDefaultLevel() {
        return this.minValue + (this.maxValue - this.minValue) / 2.0f;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public int getRescaleWidth(int width) {
        return (int)Math.ceil((double)width * this.getRescaleX() - 0.5);
    }

    public int getRescaleHeight(int height) {
        return (int)Math.ceil((double)height * this.getRescaleY() - 0.5);
    }

    public double getRescaleX() {
        return this.pixelSizeX <= this.pixelSizeY ? 1.0 : this.pixelSizeX / this.pixelSizeY;
    }

    public double getRescaleY() {
        return this.pixelSizeY <= this.pixelSizeX ? 1.0 : this.pixelSizeY / this.pixelSizeX;
    }

    public double getPixelSize() {
        return this.pixelSizeX <= this.pixelSizeY ? this.pixelSizeX : this.pixelSizeY;
    }

    public void setPixelSize(double pixelSize) {
        if (this.pixelSizeX == this.pixelSizeY) {
            this.pixelSizeX = pixelSize;
            this.pixelSizeY = pixelSize;
        } else if (this.pixelSizeX < this.pixelSizeY) {
            this.pixelSizeX = pixelSize;
            this.pixelSizeY = this.pixelSizeY / this.pixelSizeX * pixelSize;
        } else {
            this.pixelSizeX = this.pixelSizeX / this.pixelSizeY * pixelSize;
            this.pixelSizeY = pixelSize;
        }
    }

    public void setPixelValueUnit(String pixelValueUnit) {
        this.pixelValueUnit = pixelValueUnit;
    }

    public Unit getPixelSpacingUnit() {
        return this.pixelSpacingUnit;
    }

    public void setPixelSpacingUnit(Unit pixelSpacingUnit) {
        this.pixelSpacingUnit = pixelSpacingUnit;
    }

    public String getPixelValueUnit() {
        return this.pixelValueUnit;
    }

    public String getPixelSizeCalibrationDescription() {
        return this.pixelSizeCalibrationDescription;
    }

    public MeasurementsAdapter getMeasurementAdapter() {
        return new MeasurementsAdapter(this.getPixelSize(), 0, 0, false, 0, this.pixelSpacingUnit.getAbbreviation());
    }

    public boolean isImageInCache() {
        return mCache.get(this) != null;
    }

    public void removeImageFromCache() {
        SoftReference img = ImageElement.mCache.hash.get(this);
        if (img != null) {
            mCache.removeElement(img);
        }
    }

    public boolean hasSameSize(ImageElement image) {
        if (image != null) {
            PlanarImage img = this.getImage();
            PlanarImage img2 = image.getImage();
            if (img != null && img2 != null && this.getRescaleWidth(img.getWidth()) == image.getRescaleWidth(img2.getWidth()) && this.getRescaleHeight(img.getHeight()) == image.getRescaleHeight(img2.getHeight())) {
                return true;
            }
        }
        return false;
    }

    protected PlanarImage loadImage() throws Exception {
        return this.mediaIO.getMediaFragment(this);
    }

    public synchronized PlanarImage getImage() {
        PlanarImage cacheImage;
        try {
            cacheImage = this.startImageLoading();
        }
        catch (OutOfMemoryError e1) {
            logger.warn("Out of MemoryError: {}", (Object)this.getMediaURI());
            mCache.expungeStaleEntries();
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cacheImage = this.startImageLoading();
        }
        return cacheImage;
    }

    private PlanarImage startImageLoading() throws OutOfMemoryError {
        PlanarImage cacheImage = mCache.get(this);
        if (cacheImage == null && this.readable && this.setAsLoading()) {
            logger.debug("Asking for reading image: {}", (Object)this);
            Load ref = new Load();
            Future<PlanarImage> future = IMAGE_LOADER.submit(ref);
            PlanarImage img = null;
            try {
                img = future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                future.cancel(true);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof OutOfMemoryError) {
                    this.setAsLoaded();
                    throw new OutOfMemoryError();
                }
                this.readable = false;
                logger.error("Cannot read pixel data!: {}", (Object)this.getMediaURI());
                e.printStackTrace();
            }
            if (img != null) {
                this.readable = true;
                mCache.put(this, img);
                cacheImage = img;
                this.setTag(TagW.ImageCache, true);
            }
            this.setAsLoaded();
        }
        return cacheImage;
    }

    public boolean isReadable() {
        return this.readable;
    }

    @Override
    public void dispose() {
    }

    class Load
    implements Callable<PlanarImage> {
        Load() {
        }

        @Override
        public PlanarImage call() throws Exception {
            PlanarImage img = ImageElement.this.loadImage();
            ImageElement.this.findMinMaxValues((RenderedImage)img);
            return img;
        }
    }
}

