/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.util;

import org.weasis.core.api.Messages;

public class BasicHist {
    public static final String[] STATISTICS_LIST = new String[]{Messages.getString("BasicHist.pix"), Messages.getString("BasicHist.min"), Messages.getString("BasicHist.max"), Messages.getString("BasicHist.mean"), Messages.getString("BasicHist.median"), Messages.getString("BasicHist.thresh"), Messages.getString("BasicHist.std"), Messages.getString("BasicHist.skew"), Messages.getString("BasicHist.kurtosis"), Messages.getString("BasicHist.entropy")};
    private int[] bins;
    private int numBins;
    private double lo;
    private double hi;
    private double range;

    public BasicHist(int numBins, double lo, double hi) {
        this.numBins = numBins;
        this.bins = new int[numBins];
        this.lo = lo;
        this.hi = hi;
        this.range = hi - lo;
    }

    public boolean add(double x) {
        if (x >= this.lo && x <= this.hi) {
            int bin;
            double val = x - this.lo;
            int n = bin = (int)((double)this.numBins * (val / this.range - 1.0E-8));
            this.bins[n] = this.bins[n] + 1;
            return true;
        }
        return false;
    }

    public void add(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            int bin;
            if (!(x[i] >= this.lo) || !(x[i] <= this.hi)) continue;
            double val = x[i] - this.lo;
            int n = bin = (int)((double)this.numBins * (val / this.range));
            this.bins[n] = this.bins[n] + 1;
        }
    }

    public void add(Object[] obj) {
        if (obj != null && obj.length > 1 && obj[0] instanceof Number) {
            for (int i = 0; i < obj.length; ++i) {
                int bin;
                double val = ((Number)obj[i]).doubleValue();
                if (!(val >= this.lo) || !(val <= this.hi)) continue;
                int n = bin = (int)((double)(this.numBins - 1) * ((val -= this.lo) / this.range));
                this.bins[n] = this.bins[n] + 1;
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.numBins; ++i) {
            this.bins[i] = 0;
        }
    }

    public int[] getBins() {
        return this.bins;
    }

    public Integer[] getIntegerBins() {
        Integer[] vals = new Integer[this.numBins];
        for (int i = 0; i < this.numBins; ++i) {
            vals[i] = this.bins[i];
        }
        return vals;
    }

    public double getRange() {
        return this.range;
    }

    public double getHi() {
        return this.hi;
    }

    public double getLo() {
        return this.lo;
    }

    public int[] getCummulative() {
        int[] cml = new int[this.numBins];
        int sum = 0;
        for (int j = 0; j < this.numBins; ++j) {
            cml[j] = sum += this.bins[j];
        }
        return cml;
    }

    public static double[] getStatistics(int[] bins, double treshRatio, int offset) {
        double[] stat = new double[STATISTICS_LIST.length];
        if (bins != null && bins.length > 1) {
            stat[1] = Double.MAX_VALUE;
            stat[2] = -1.7976931348623157E308;
            for (int i = 0; i < bins.length; ++i) {
                double val = bins[i];
                if (val != 0.0 && (double)i < stat[1]) {
                    stat[1] = i;
                }
                if (val != 0.0 && (double)i > stat[2]) {
                    stat[2] = i;
                }
                stat[0] = stat[0] + val;
                stat[3] = stat[3] + val * (double)(i + offset);
            }
            stat[1] = stat[1] + (double)offset;
            stat[2] = stat[2] + (double)offset;
            stat[3] = stat[3] / stat[0];
            stat[4] = BasicHist.medianBin(bins, (int)stat[0] / 2) + (double)offset;
            stat[5] = treshRatio;
            double m2 = 0.0;
            for (int i = 0; i < bins.length; ++i) {
                double factor = bins[i];
                double val = (double)(i + offset) - stat[3];
                m2 += factor * Math.pow(val, 2.0);
                stat[7] = stat[7] + factor * Math.pow(val, 3.0);
                stat[8] = stat[8] + factor * Math.pow(val, 4.0);
            }
            double variance = m2 / (stat[0] - 1.0);
            stat[6] = Math.sqrt(variance);
            if (bins.length > 3 && variance > 1.0E-19) {
                stat[7] = stat[0] * stat[7] / ((stat[0] - 1.0) * (stat[0] - 2.0) * stat[6] * variance);
                stat[8] = (stat[0] * (stat[0] + 1.0) * stat[8] - 3.0 * m2 * m2 * (stat[0] - 1.0)) / ((stat[0] - 1.0) * (stat[0] - 2.0) * (stat[0] - 3.0) * variance * variance);
            } else {
                stat[7] = 0.0;
                stat[8] = 0.0;
            }
            stat[9] = BasicHist.getEntropy(bins, stat[0]);
        }
        return stat;
    }

    public static double getEntropy(int[] data, double nbPixels) {
        double H = 0.0;
        if (data == null || data.length < 1) {
            return 0.0;
        }
        double log2 = Math.log(2.0);
        for (int b = 0; b < data.length; ++b) {
            double p = (double)data[b] / nbPixels;
            if (p == 0.0) continue;
            H -= p * (Math.log(p) / log2);
        }
        return H;
    }

    public static double medianBin(int[] bin, int halfEntries) {
        if (bin == null || bin.length < 1) {
            return 0.0;
        }
        int sum_bin_entries = 0;
        int sum = 0;
        for (int i = 0; i < bin.length; ++i) {
            sum = sum_bin_entries + bin[i];
            if (sum >= halfEntries) {
                int dif = halfEntries - sum_bin_entries;
                double frac = 0.0;
                if (bin[i] > 0) {
                    frac = (double)dif / (double)bin[i];
                }
                return (double)i + frac;
            }
            sum_bin_entries = sum;
        }
        return 0.0;
    }
}

