/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.op;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.UnpackedImageData;

public class ThresholdToBinOpImage
extends PointOpImage {
    private double min;
    private double max;
    private boolean inverse = false;
    private static byte[] byteTable = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};

    public ThresholdToBinOpImage(RenderedImage source, Map map, ImageLayout layout, double min, double max) {
        super(source, layout, map, true);
        this.min = min;
        this.max = max;
        if (min > max) {
            this.inverse = true;
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        switch (sources[0].getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(sources[0], dest, destRect);
                break;
            }
            case 2: {
                this.shortLoop(sources[0], dest, destRect);
                break;
            }
            case 1: {
                this.unsignedShortLoop(sources[0], dest, destRect);
                break;
            }
            case 3: {
                this.intLoop(sources[0], dest, destRect);
                break;
            }
            case 4: {
                this.floatLoop(sources[0], dest, destRect);
                break;
            }
            case 5: {
                this.doubleLoop(sources[0], dest, destRect);
                break;
            }
            default: {
                String className = ((Object)((Object)this)).getClass().getName();
                throw new RuntimeException(className + " does not implement computeRect" + " for int/short/float/double data");
            }
        }
    }

    private void byteLoop(Raster source, WritableRaster dest, Rectangle destRect) {
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels((Raster)dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 0, false);
        int srcOffset = srcImD.bandOffsets[0];
        byte[] srcData = ((byte[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        for (int h = 0; h < destRect.height; ++h) {
            int b = ind0;
            int s = srcOffset;
            while (b < ind0 + destRect.width) {
                int pixel = srcData[s] & 0xFF;
                if (this.inverse) {
                    if ((double)pixel > this.min || (double)pixel < this.max) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                } else if ((double)pixel >= this.min && (double)pixel <= this.max) {
                    int n = offset + (b >> 3);
                    pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                }
                ++b;
                s += pixelStride;
            }
            offset += pid.lineStride;
            srcOffset += srcImD.lineStride;
        }
        pa.setPackedPixels(pid);
    }

    private void shortLoop(Raster source, WritableRaster dest, Rectangle destRect) {
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels((Raster)dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 2, false);
        int srcOffset = srcImD.bandOffsets[0];
        short[] srcData = ((short[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        for (int h = 0; h < destRect.height; ++h) {
            int b = ind0;
            int s = srcOffset;
            while (b < ind0 + destRect.width) {
                short pixel = srcData[s];
                if (this.inverse) {
                    if ((double)pixel > this.min || (double)pixel < this.max) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                } else if ((double)pixel >= this.min && (double)pixel <= this.max) {
                    int n = offset + (b >> 3);
                    pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                }
                ++b;
                s += pixelStride;
            }
            offset += pid.lineStride;
            srcOffset += srcImD.lineStride;
        }
        pa.setPackedPixels(pid);
    }

    private void unsignedShortLoop(Raster source, WritableRaster dest, Rectangle destRect) {
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels((Raster)dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 1, false);
        int srcOffset = srcImD.bandOffsets[0];
        short[] srcData = ((short[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        for (int h = 0; h < destRect.height; ++h) {
            int b = ind0;
            int s = srcOffset;
            while (b < ind0 + destRect.width) {
                int pixel = srcData[s] & 0xFFFF;
                if (this.inverse) {
                    if ((double)pixel > this.min || (double)pixel < this.max) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                } else if ((double)pixel >= this.min && (double)pixel <= this.max) {
                    int n = offset + (b >> 3);
                    pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                }
                ++b;
                s += pixelStride;
            }
            offset += pid.lineStride;
            srcOffset += srcImD.lineStride;
        }
        pa.setPackedPixels(pid);
    }

    private void intLoop(Raster source, WritableRaster dest, Rectangle destRect) {
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels((Raster)dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 3, false);
        int srcOffset = srcImD.bandOffsets[0];
        int[] srcData = ((int[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        for (int h = 0; h < destRect.height; ++h) {
            int b = ind0;
            int s = srcOffset;
            while (b < ind0 + destRect.width) {
                int pixel = srcData[s];
                if (this.inverse) {
                    if ((double)pixel > this.min || (double)pixel < this.max) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                } else if ((double)pixel >= this.min && (double)pixel <= this.max) {
                    int n = offset + (b >> 3);
                    pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                }
                ++b;
                s += pixelStride;
            }
            offset += pid.lineStride;
            srcOffset += srcImD.lineStride;
        }
        pa.setPackedPixels(pid);
    }

    private void floatLoop(Raster source, WritableRaster dest, Rectangle destRect) {
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels((Raster)dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 4, false);
        int srcOffset = srcImD.bandOffsets[0];
        float[] srcData = ((float[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        for (int h = 0; h < destRect.height; ++h) {
            int b = ind0;
            int s = srcOffset;
            while (b < ind0 + destRect.width) {
                float pixel = srcData[s];
                if (this.inverse) {
                    if ((double)pixel > this.min || (double)pixel < this.max) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                } else if ((double)pixel >= this.min && (double)pixel <= this.max) {
                    int n = offset + (b >> 3);
                    pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                }
                ++b;
                s += pixelStride;
            }
            offset += pid.lineStride;
            srcOffset += srcImD.lineStride;
        }
        pa.setPackedPixels(pid);
    }

    private void doubleLoop(Raster source, WritableRaster dest, Rectangle destRect) {
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        PixelAccessor pa = new PixelAccessor(dest.getSampleModel(), null);
        PackedImageData pid = pa.getPackedPixels((Raster)dest, destRect, true, false);
        int offset = pid.offset;
        PixelAccessor srcPa = new PixelAccessor(source.getSampleModel(), null);
        UnpackedImageData srcImD = srcPa.getPixels(source, srcRect, 5, false);
        int srcOffset = srcImD.bandOffsets[0];
        double[] srcData = ((double[][])srcImD.data)[0];
        int pixelStride = srcImD.pixelStride;
        int ind0 = pid.bitOffset;
        for (int h = 0; h < destRect.height; ++h) {
            int b = ind0;
            int s = srcOffset;
            while (b < ind0 + destRect.width) {
                double pixel = srcData[s];
                if (this.inverse) {
                    if (pixel > this.min || pixel < this.max) {
                        int n = offset + (b >> 3);
                        pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                    }
                } else if (pixel >= this.min && pixel <= this.max) {
                    int n = offset + (b >> 3);
                    pid.data[n] = (byte)(pid.data[n] | byteTable[b % 8]);
                }
                ++b;
                s += pixelStride;
            }
            offset += pid.lineStride;
            srcOffset += srcImD.lineStride;
        }
        pa.setPackedPixels(pid);
    }
}

