/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.ImageOperation;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.image.AbstractOperation;
import org.weasis.core.api.image.util.KernelData;

public class FilterOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterOperation.class);
    public static final String name = Messages.getString("FilterOperation.title");

    @Override
    public String getOperationName() {
        return name;
    }

    @Override
    public RenderedImage getRenderedImage(RenderedImage source, ImageOperation imageOperation) {
        KernelData kernel = (KernelData)imageOperation.getActionValue(ActionW.FILTER.cmd());
        if (kernel == null) {
            this.result = source;
            LOGGER.warn("Cannot apply \"{}\" because a parameter is null", (Object)name);
        } else if (kernel.equals(KernelData.NONE)) {
            this.result = source;
        } else {
            ParameterBlock paramBlock = new ParameterBlock();
            paramBlock.addSource(source);
            paramBlock.add(kernel.getKernelJAI());
            this.result = JAI.create((String)"convolve", (ParameterBlock)paramBlock, null);
        }
        return this.result;
    }
}

