/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class TableHeaderRenderer
extends JLabel
implements TableCellRenderer {
    public TableHeaderRenderer() {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(10);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            Color fgColor = null;
            Color bgColor = null;
            if (hasFocus) {
                fgColor = UIManager.getColor("TableHeader.focusCellForeground");
                bgColor = UIManager.getColor("TableHeader.focusCellBackground");
            }
            if (fgColor == null) {
                fgColor = header.getForeground();
            }
            if (bgColor == null) {
                bgColor = header.getBackground();
            }
            this.setForeground(fgColor);
            this.setBackground(bgColor);
            this.setFont(header.getFont());
        }
        String val = value == null || value == "" ? " " : value.toString();
        this.setText(val);
        this.setToolTipText(val);
        Border border = null;
        if (hasFocus) {
            border = UIManager.getBorder("TableHeader.focusCellBorder");
        }
        if (border == null) {
            border = UIManager.getBorder("TableHeader.cellBorder");
        }
        this.setBorder(border);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

