/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.Color;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.JSliderW;
import org.weasis.core.api.gui.util.SliderChangeListener;

public abstract class SliderCineListener
extends SliderChangeListener {
    private final TIME time;
    private final SpinnerNumberModel speedModel;

    public SliderCineListener(ActionW action, int min, int max, int value, int speed, TIME time, double mouseSensivity) {
        this(action, min, max, value, speed, time);
        this.setMouseSensivity(mouseSensivity);
    }

    public SliderCineListener(ActionW action, int min, int max, int value, int speed, TIME time) {
        super(action, min, max, value);
        this.time = time;
        this.speedModel = new SpinnerNumberModel(speed, 1, 60, 1);
        this.speedModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderCineListener.this.setSpeed((Integer)((SpinnerNumberModel)e.getSource()).getValue());
            }
        });
    }

    public abstract void start();

    public abstract void stop();

    public int getSpeed() {
        return (Integer)this.speedModel.getValue();
    }

    @Override
    public void updateSliderProoperties(JSliderW slider) {
        JPanel panel = (JPanel)slider.getParent();
        int rate = this.getCurrentCineRate();
        StringBuffer buffer = new StringBuffer(Messages.getString("SliderCineListener.img"));
        buffer.append(this.getValueToDisplay());
        if (!slider.isDisplayOnlyValue() && panel != null && panel.getBorder() instanceof TitledBorder) {
            if (rate > 0) {
                buffer.append(Messages.getString("SliderCineListener.cine"));
                buffer.append(rate);
                if (TIME.second.equals((Object)this.time)) {
                    buffer.append(Messages.getString("SliderCineListener.fps"));
                } else if (TIME.minute.equals((Object)this.time)) {
                    buffer.append(Messages.getString("SliderCineListener.fpm"));
                } else if (TIME.hour.equals((Object)this.time)) {
                    buffer.append(Messages.getString("SliderCineListener.fph"));
                }
            }
            ((TitledBorder)panel.getBorder()).setTitleColor(rate > 0 && rate < this.getSpeed() - 1 ? Color.red : UIManager.getColor("TitledBorder.titleColor"));
            ((TitledBorder)panel.getBorder()).setTitle(buffer.toString());
            panel.repaint();
        } else {
            slider.setToolTipText(buffer.toString());
        }
    }

    public int getCurrentCineRate() {
        return 0;
    }

    public void setSpeed(int speed) {
        this.speedModel.setValue(speed);
    }

    public SpinnerNumberModel getSpeedModel() {
        return this.speedModel;
    }

    public static enum TIME {
        second,
        minute,
        hour;

    }
}

