/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.pref;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.dcm4che2.imageio.ImageReaderFactory;
import org.weasis.core.api.gui.util.AbstractItemDialogPage;
import org.weasis.dicom.codec.pref.DicomPrefManager;

public class DicomPrefView
extends AbstractItemDialogPage {
    private final JPanel panel = new JPanel();
    private final JComboBox comboBox;

    public DicomPrefView() {
        this.setTitle("DICOM");
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.panel.setBorder(new TitledBorder(null, "Image Reader", 4, 2, null, null));
        JLabel j2kLabel = new JLabel("JPEG2000:");
        GridBagConstraints gbc_j2kLabel = new GridBagConstraints();
        gbc_j2kLabel.insets = new Insets(0, 0, 5, 5);
        gbc_j2kLabel.anchor = 17;
        gbc_j2kLabel.gridx = 0;
        gbc_j2kLabel.gridy = 0;
        this.panel.add((Component)j2kLabel, gbc_j2kLabel);
        this.comboBox = new JComboBox<Object>(this.getJpeg2000ReaderClassName().toArray());
        GridBagConstraints gbc_comboBox = new GridBagConstraints();
        gbc_comboBox.anchor = 17;
        gbc_comboBox.insets = new Insets(0, 2, 5, 5);
        gbc_comboBox.gridx = 1;
        gbc_comboBox.gridy = 0;
        this.panel.add((Component)this.comboBox, gbc_comboBox);
        GridBagConstraints gbc_lblstrut = new GridBagConstraints();
        gbc_lblstrut.insets = new Insets(0, 0, 5, 0);
        gbc_lblstrut.anchor = 17;
        gbc_lblstrut.fill = 2;
        gbc_lblstrut.weightx = 1.0;
        gbc_lblstrut.gridx = 2;
        gbc_lblstrut.gridy = 0;
        this.panel.add(Box.createHorizontalStrut(2), gbc_lblstrut);
        String j2kReader = DicomPrefManager.getInstance().getJ2kReader();
        if (j2kReader != null) {
            for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                Decoder dec = (Decoder)this.comboBox.getItemAt(i);
                if (!j2kReader.equals(dec.getReader())) continue;
                this.comboBox.setSelectedItem(dec);
                break;
            }
        }
    }

    public void closeAdditionalWindow() {
        Decoder reader = (Decoder)this.comboBox.getSelectedItem();
        if (reader != null) {
            DicomPrefManager.getInstance().setJ2kReader(reader.getReader());
        }
    }

    public void resetoDefaultValues() {
    }

    public List<Decoder> getJpeg2000ReaderClassName() {
        ImageReaderFactory factory = ImageReaderFactory.getInstance();
        String[] decoders = factory.getProperty("jpeg2000").split(",");
        String[] decoderNames = factory.getProperty("jpeg2000.title").split(",");
        ArrayList<Decoder> list = new ArrayList<Decoder>();
        if (decoders.length == decoderNames.length) {
            for (int i = 0; i < decoders.length; ++i) {
                Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("jpeg2000");
                while (it.hasNext()) {
                    ImageReader r = it.next();
                    if (!decoders[i].equals(r.getClass().getName())) continue;
                    list.add(new Decoder(decoderNames[i], decoders[i]));
                }
            }
        }
        return list;
    }

    static class Decoder {
        private final String name;
        private final String reader;

        public Decoder(String name, String reader) {
            this.name = name;
            this.reader = reader;
        }

        public String getName() {
            return this.name;
        }

        public String getReader() {
            return this.reader;
        }

        public String toString() {
            return this.name;
        }
    }
}

