/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.geometry;

import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.weasis.dicom.codec.geometry.GeometryOfSlice;
import org.weasis.dicom.codec.geometry.SpectroscopyVolumeLocalization;

public abstract class LocalizerPoster {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/geometry/LocalizerPoster.java,v 1.17 2009/11/14 14:10:50 dclunie Exp $";
    protected Vector3d localizerRow;
    protected Vector3d localizerColumn;
    protected Vector3d localizerNormal;
    protected Point3d localizerTLHC;
    protected Tuple3d localizerVoxelSpacing;
    protected double[] localizerVoxelSpacingArray;
    protected Tuple3d localizerDimensions;
    protected double[] localizerDimensionsArray;
    protected Matrix3d rotateIntoLocalizerSpace;
    private final double[] tmpArray3 = new double[3];

    LocalizerPoster() {
    }

    public static void validateDirectionCosines(Vector3d row, Vector3d column) throws IllegalArgumentException {
        if (Math.abs(row.lengthSquared() - 1.0) > 0.001) {
            throw new IllegalArgumentException("Row not a unit vector");
        }
        if (Math.abs(column.lengthSquared() - 1.0) > 0.001) {
            throw new IllegalArgumentException("Column not a unit vector");
        }
        if (row.dot(column) > 0.001) {
            throw new IllegalArgumentException("Row and column vectors are not orthogonal");
        }
    }

    public static void validateDirectionCosines(Vector3d row, Vector3d column, Vector3d normal) throws IllegalArgumentException {
        if (Math.abs(row.lengthSquared() - 1.0) > 0.001) {
            throw new IllegalArgumentException("Row not a unit vector");
        }
        if (Math.abs(column.lengthSquared() - 1.0) > 0.001) {
            throw new IllegalArgumentException("Column not a unit vector");
        }
        if (Math.abs(normal.lengthSquared() - 1.0) > 0.001) {
            throw new IllegalArgumentException("Normal not a unit vector");
        }
        if (row.dot(column) > 0.001) {
            throw new IllegalArgumentException("Row and column vectors are not orthogonal = " + row.dot(column));
        }
        if (row.dot(normal) > 0.001) {
            throw new IllegalArgumentException("Row and normal vectors are not orthogonal = " + row.dot(normal));
        }
        if (column.dot(normal) > 0.001) {
            throw new IllegalArgumentException("Column and normal vectors are not orthogonal = " + column.dot(normal));
        }
    }

    public static Point3d[] getCornersOfSourceRectangleInSourceSpace(GeometryOfSlice g) {
        return LocalizerPoster.getCornersOfSourceRectangleInSourceSpace(g.getRow(), g.getColumn(), g.getTLHC(), g.getVoxelSpacing(), g.getDimensions());
    }

    public static Point3d[] getCornersOfSourceRectangleInSourceSpace(Vector3d row, Vector3d column, Point3d originalTLHC, Tuple3d voxelSpacing, Tuple3d dimensions) {
        LocalizerPoster.validateDirectionCosines(row, column);
        double[] spacingArray = new double[3];
        voxelSpacing.get(spacingArray);
        double[] dimensionsArray = new double[3];
        dimensions.get(dimensionsArray);
        Vector3d distanceAlongRow = new Vector3d(row);
        distanceAlongRow.scale(dimensionsArray[1] * spacingArray[1]);
        Vector3d distanceAlongColumn = new Vector3d(column);
        distanceAlongColumn.scale(dimensionsArray[0] * spacingArray[0]);
        Point3d tlhc = new Point3d(originalTLHC);
        Point3d trhc = new Point3d(tlhc);
        trhc.add((Tuple3d)distanceAlongRow);
        Point3d blhc = new Point3d(tlhc);
        blhc.add((Tuple3d)distanceAlongColumn);
        Point3d brhc = new Point3d(tlhc);
        brhc.add((Tuple3d)distanceAlongRow);
        brhc.add((Tuple3d)distanceAlongColumn);
        Point3d[] corners = new Point3d[]{tlhc, trhc, brhc, blhc};
        return corners;
    }

    public static Point3d[] getCornersOfSourceCubeInSourceSpace(Vector3d row, Vector3d column, Point3d originalTLHC, Tuple3d voxelSpacing, double sliceThickness, Tuple3d dimensions) {
        LocalizerPoster.validateDirectionCosines(row, column);
        Vector3d normal = new Vector3d();
        normal.cross(row, column);
        double[] spacingArray = new double[3];
        voxelSpacing.get(spacingArray);
        double[] dimensionsArray = new double[3];
        dimensions.get(dimensionsArray);
        Vector3d distanceAlongRow = new Vector3d(row);
        distanceAlongRow.scale(dimensionsArray[1] * spacingArray[1]);
        Vector3d distanceAlongColumn = new Vector3d(column);
        distanceAlongColumn.scale(dimensionsArray[0] * spacingArray[0]);
        Vector3d distanceAlongNormal = new Vector3d(normal);
        distanceAlongNormal.scale(dimensionsArray[2] / 2.0 * sliceThickness);
        Point3d tlhcT = new Point3d(originalTLHC);
        tlhcT.add((Tuple3d)distanceAlongNormal);
        Point3d trhcT = new Point3d(tlhcT);
        trhcT.add((Tuple3d)distanceAlongRow);
        Point3d blhcT = new Point3d(tlhcT);
        blhcT.add((Tuple3d)distanceAlongColumn);
        Point3d brhcT = new Point3d(tlhcT);
        brhcT.add((Tuple3d)distanceAlongRow);
        brhcT.add((Tuple3d)distanceAlongColumn);
        Point3d tlhcB = new Point3d(originalTLHC);
        tlhcB.sub((Tuple3d)distanceAlongNormal);
        Point3d trhcB = new Point3d(tlhcB);
        trhcB.add((Tuple3d)distanceAlongRow);
        Point3d blhcB = new Point3d(tlhcB);
        blhcB.add((Tuple3d)distanceAlongColumn);
        Point3d brhcB = new Point3d(tlhcB);
        brhcB.add((Tuple3d)distanceAlongRow);
        brhcB.add((Tuple3d)distanceAlongColumn);
        Point3d[] corners = new Point3d[]{tlhcT, trhcT, brhcT, blhcT, tlhcB, trhcB, brhcB, blhcB};
        return corners;
    }

    public static Point3d[] getIntersectionOfRectanglesInXYPlane(Point3d[] rect1, Point3d[] rect2) {
        Point3d[] newPoints = new Point3d[4];
        double[] array1 = new double[3];
        double[] array2 = new double[3];
        rect1[0].get(array1);
        rect2[0].get(array2);
        double x = array1[0] > array2[0] ? array1[0] : array2[0];
        double y = array1[1] > array2[1] ? array1[1] : array2[1];
        newPoints[0] = new Point3d(x, y, 0.0);
        rect1[1].get(array1);
        rect2[1].get(array2);
        x = array1[0] < array2[0] ? array1[0] : array2[0];
        y = array1[1] > array2[1] ? array1[1] : array2[1];
        newPoints[1] = new Point3d(x, y, 0.0);
        rect1[2].get(array1);
        rect2[2].get(array2);
        x = array1[0] < array2[0] ? array1[0] : array2[0];
        y = array1[1] < array2[1] ? array1[1] : array2[1];
        newPoints[2] = new Point3d(x, y, 0.0);
        rect1[3].get(array1);
        rect2[3].get(array2);
        x = array1[0] > array2[0] ? array1[0] : array2[0];
        y = array1[1] < array2[1] ? array1[1] : array2[1];
        newPoints[3] = new Point3d(x, y, 0.0);
        return newPoints;
    }

    public static Rectangle getBoundsOfContainedRectangle(Point3d[] containedRectangle, Point3d[] wholeRectangle, Rectangle boundsOfWholeRectangle) {
        Rectangle boundsOfContainedRectangle = new Rectangle();
        double[] wholeTLHC = new double[3];
        wholeRectangle[0].get(wholeTLHC);
        double[] wholeBRHC = new double[3];
        wholeRectangle[2].get(wholeBRHC);
        double wholeHeight = wholeBRHC[1] - wholeTLHC[1];
        double wholeWidth = wholeBRHC[0] - wholeTLHC[0];
        double[] containedTLHC = new double[3];
        containedRectangle[0].get(containedTLHC);
        double[] containedBRHC = new double[3];
        containedRectangle[2].get(containedBRHC);
        double containedHeight = containedBRHC[1] - containedTLHC[1];
        double containedWidth = containedBRHC[0] - containedTLHC[0];
        boundsOfContainedRectangle.height = (int)(containedHeight / wholeHeight * (double)boundsOfWholeRectangle.height);
        boundsOfContainedRectangle.width = (int)(containedWidth / wholeWidth * (double)boundsOfWholeRectangle.width);
        boundsOfContainedRectangle.x = (int)((containedTLHC[0] - wholeTLHC[0]) / wholeHeight * (double)boundsOfWholeRectangle.width);
        boundsOfContainedRectangle.y = (int)((containedTLHC[1] - wholeTLHC[1]) / wholeWidth * (double)boundsOfWholeRectangle.height);
        return boundsOfContainedRectangle;
    }

    public static Point3d[] transformPointsFromSourceSpaceIntoSpecifiedSpace(Point3d[] points, Point3d tlhc, Vector3d row, Vector3d column) {
        Vector3d normal = new Vector3d();
        normal.cross(row, column);
        normal.normalize();
        Matrix3d rotation = new Matrix3d();
        rotation.setRow(0, row);
        rotation.setRow(1, column);
        rotation.setRow(2, normal);
        Point3d[] newPoints = new Point3d[points.length];
        for (int i = 0; i < points.length; ++i) {
            Point3d newPoint = new Point3d(points[i]);
            newPoint.sub((Tuple3d)tlhc);
            rotation.transform((Tuple3d)newPoint);
            newPoints[i] = newPoint;
        }
        return newPoints;
    }

    public static Point3d transformPointFromSourceSpaceIntoSpecifiedSpace(Point3d point, Point3d tlhc, Vector3d row, Vector3d column) {
        Vector3d normal = new Vector3d();
        normal.cross(row, column);
        normal.normalize();
        Matrix3d rotation = new Matrix3d();
        rotation.setRow(0, row);
        rotation.setRow(1, column);
        rotation.setRow(2, normal);
        Point3d newPoint = new Point3d(point);
        newPoint.sub((Tuple3d)tlhc);
        rotation.transform((Tuple3d)newPoint);
        return newPoint;
    }

    protected Point3d transformPointFromSourceSpaceIntoLocalizerSpace(Point3d point) {
        Point3d newPoint = new Point3d(point);
        newPoint.sub((Tuple3d)this.localizerTLHC);
        this.rotateIntoLocalizerSpace.transform((Tuple3d)newPoint);
        return newPoint;
    }

    protected Point2D.Double transformPointInLocalizerPlaneIntoImageSpace(Point3d point) {
        point.get(this.tmpArray3);
        double scaleSubPixelHeightOfColumn = (this.localizerDimensionsArray[0] - 1.0) / this.localizerDimensionsArray[0];
        double scaleSubPixelWidthOfRow = (this.localizerDimensionsArray[1] - 1.0) / this.localizerDimensionsArray[1];
        Point2D.Double location = new Point2D.Double(this.tmpArray3[0] / this.localizerVoxelSpacingArray[1] * scaleSubPixelHeightOfColumn + 0.5, this.tmpArray3[1] / this.localizerVoxelSpacingArray[0] * scaleSubPixelWidthOfRow + 0.5);
        return location;
    }

    protected Vector drawOutlineOnLocalizer(Vector corners) {
        Vector shapes = null;
        if (corners != null && corners.size() > 0) {
            Point3d[] cornersArray = new Point3d[corners.size()];
            shapes = this.drawOutlineOnLocalizer(corners.toArray(cornersArray));
        }
        return shapes;
    }

    protected Vector drawOutlineOnLocalizer(Point3d[] corners) {
        Vector<Line2D.Double> shapes = new Vector<Line2D.Double>();
        Point2D.Double firstPoint = null;
        Point2D.Double lastPoint = null;
        Point2D.Double thisPoint = null;
        for (int i = 0; i < corners.length; ++i) {
            lastPoint = thisPoint;
            thisPoint = this.transformPointInLocalizerPlaneIntoImageSpace(corners[i]);
            if (i == 0) {
                firstPoint = thisPoint;
                continue;
            }
            shapes.add(new Line2D.Double(lastPoint, thisPoint));
        }
        shapes.add(new Line2D.Double(thisPoint, firstPoint));
        return shapes;
    }

    protected Point3d intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(double[] a, double[] b) {
        double[] u = new double[3];
        u[1] = b[2] == a[2] ? a[1] : (b[1] - a[1]) / (b[2] - a[2]) * (0.0 - a[2]) + a[1];
        u[0] = b[1] == a[1] ? a[0] : (b[0] - a[0]) / (b[1] - a[1]) * (u[1] - a[1]) + a[0];
        u[2] = 0.0;
        return new Point3d(u);
    }

    protected Point3d intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(Point3d aP, Point3d bP) {
        double[] a = new double[3];
        aP.get(a);
        double[] b = new double[3];
        bP.get(b);
        return this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(a, b);
    }

    protected Vector drawLinesBetweenAnyPointsWhichIntersectPlaneWhereZIsZero(Point3d[] corners) {
        int size = corners.length;
        double[] thisArray = new double[3];
        double[] nextArray = new double[3];
        Vector<Point3d> intersections = new Vector<Point3d>();
        for (int i = 0; i < size; ++i) {
            int next = i == size - 1 ? 0 : i + 1;
            corners[i].get(thisArray);
            double thisZ = thisArray[2];
            corners[next].get(nextArray);
            double nextZ = nextArray[2];
            if (!(thisZ <= 0.0 && nextZ >= 0.0) && (!(thisZ >= 0.0) || !(nextZ <= 0.0))) continue;
            Point3d intersection = this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(thisArray, nextArray);
            intersections.add(intersection);
        }
        return intersections.size() > 0 ? this.drawOutlineOnLocalizer(intersections) : null;
    }

    protected static boolean classifyCornersIntoEdgeCrossingZPlane(Point3d startCorner, Point3d endCorner) {
        double[] startArray = new double[3];
        double[] endArray = new double[3];
        boolean classification = false;
        startCorner.get(startArray);
        double startZ = startArray[2];
        endCorner.get(endArray);
        double endZ = endArray[2];
        classification = startZ <= 0.0 && endZ >= 0.0 || startZ >= 0.0 && endZ <= 0.0;
        return classification;
    }

    protected Vector getIntersectionsOfCubeWithZPlane(Point3d[] corners) {
        Vector<Point3d> intersections = new Vector<Point3d>();
        if (LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[0], corners[1]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[2], corners[3]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[4], corners[5]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[6], corners[7])) {
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[0], corners[1]));
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[2], corners[3]));
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[6], corners[7]));
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[4], corners[5]));
        } else if (LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[0], corners[3]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[1], corners[2]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[4], corners[7]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[5], corners[6])) {
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[0], corners[3]));
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[1], corners[2]));
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[5], corners[6]));
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[4], corners[7]));
        } else if (LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[0], corners[4]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[1], corners[5]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[2], corners[6]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(corners[3], corners[7])) {
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[0], corners[4]));
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[1], corners[5]));
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[2], corners[6]));
            intersections.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(corners[3], corners[7]));
        }
        return intersections;
    }

    protected void doCommonConstructorStuff() {
        LocalizerPoster.validateDirectionCosines(this.localizerRow, this.localizerColumn);
        this.localizerNormal = new Vector3d();
        this.localizerNormal.cross(this.localizerRow, this.localizerColumn);
        this.localizerVoxelSpacingArray = new double[3];
        this.localizerVoxelSpacing.get(this.localizerVoxelSpacingArray);
        this.localizerDimensionsArray = new double[3];
        this.localizerDimensions.get(this.localizerDimensionsArray);
        this.rotateIntoLocalizerSpace = new Matrix3d();
        this.rotateIntoLocalizerSpace.setRow(0, this.localizerRow);
        this.rotateIntoLocalizerSpace.setRow(1, this.localizerColumn);
        this.rotateIntoLocalizerSpace.setRow(2, this.localizerNormal);
    }

    public void setLocalizerGeometry(Vector3d row, Vector3d column, Point3d tlhc, Tuple3d voxelSpacing, Tuple3d dimensions) {
        this.localizerRow = row;
        this.localizerColumn = column;
        this.localizerTLHC = tlhc;
        this.localizerVoxelSpacing = voxelSpacing;
        this.localizerDimensions = dimensions;
        this.doCommonConstructorStuff();
    }

    public void setLocalizerGeometry(GeometryOfSlice geometry) {
        this.localizerRow = geometry.getRow();
        this.localizerColumn = geometry.getColumn();
        this.localizerTLHC = geometry.getTLHC();
        this.localizerVoxelSpacing = geometry.getVoxelSpacing();
        this.localizerDimensions = geometry.getDimensions();
        this.doCommonConstructorStuff();
    }

    public abstract List<Point2D> getOutlineOnLocalizerForThisGeometry(Vector3d var1, Vector3d var2, Point3d var3, Tuple3d var4, double var5, Tuple3d var7);

    public final List<Point2D> getOutlineOnLocalizerForThisGeometry(GeometryOfSlice geometry) {
        return this.getOutlineOnLocalizerForThisGeometry(geometry.getRow(), geometry.getColumn(), geometry.getTLHC(), geometry.getVoxelSpacing(), geometry.getSliceThickness(), geometry.getDimensions());
    }

    private static Vector3d[] getOrthogonalVectors(double normalX, double normalY, double normalZ) {
        Vector3d normal = new Vector3d(normalX, normalY, normalZ);
        normal.normalize();
        Vector3d row = Math.abs(normalX) > 0.0 || Math.abs(normalY) > 0.0 ? new Vector3d(-normalY, normalX, 0.0) : new Vector3d(0.0, -normalZ, normalY);
        row.normalize();
        Vector3d column = new Vector3d();
        column.cross(normal, row);
        LocalizerPoster.validateDirectionCosines(row, column, normal);
        Vector3d[] vectors = new Vector3d[]{row, column, normal};
        return vectors;
    }

    public final Vector getOutlineOnLocalizerForThisVolumeLocalization(SpectroscopyVolumeLocalization spectroscopyVolumeLocalization) {
        Vector intersections = new Vector();
        if (spectroscopyVolumeLocalization != null) {
            int n = spectroscopyVolumeLocalization.getNumberOfSlabs();
            for (int j = 0; j < n; ++j) {
                double slabThickness = spectroscopyVolumeLocalization.getSlabThickness(j);
                double[] slabOrientation = spectroscopyVolumeLocalization.getSlabOrientation(j);
                double[] midSlabPosition = spectroscopyVolumeLocalization.getMidSlabPosition(j);
                Vector3d[] vectors = LocalizerPoster.getOrthogonalVectors(slabOrientation[0], slabOrientation[1], slabOrientation[2]);
                Vector3d row = vectors[0];
                Vector3d column = vectors[1];
                Vector3d voxelSpacing = new Vector3d(1.0, 1.0, 0.0);
                Vector3d dimensions = new Vector3d(100000.0, 100000.0, 1.0);
                Point3d midSlabPoint = new Point3d(midSlabPosition);
                Point3d tlhc = new Point3d(midSlabPoint);
                Vector3d distanceAlongRow = new Vector3d(row);
                distanceAlongRow.scale(50000.0);
                Vector3d distanceAlongColumn = new Vector3d(column);
                distanceAlongColumn.scale(50000.0);
                tlhc.sub((Tuple3d)distanceAlongRow);
                tlhc.sub((Tuple3d)distanceAlongColumn);
                Point3d[] corners = LocalizerPoster.getCornersOfSourceCubeInSourceSpace(row, column, tlhc, (Tuple3d)voxelSpacing, slabThickness, (Tuple3d)dimensions);
                for (int i = 0; i < 8; ++i) {
                    corners[i] = this.transformPointFromSourceSpaceIntoLocalizerSpace(corners[i]);
                }
                intersections.addAll(this.getIntersectionsOfCubeWithZPlane(corners));
            }
        }
        return intersections.size() > 0 ? this.drawOutlineOnLocalizer(intersections) : null;
    }
}

