/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.geometry;

import javax.media.jai.operator.TransposeDescriptor;
import javax.media.jai.operator.TransposeType;
import org.dcm4che2.data.DicomObject;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.TagW;
import org.weasis.dicom.codec.DicomImageElement;

public abstract class ImageOrientation {
    public static final String[] LABELS = new String[]{"UNKNOWN", "AXIAL", "SAGITTAL", "CORONAL", "OBLIQUE"};
    private static final double obliquityThresholdCosineValue = 0.8;

    public static final String getMajorAxisFromPatientRelativeDirectionCosine(double x, double y, double z) {
        String axis = null;
        String orientationX = x < 0.0 ? "R" : "L";
        String orientationY = y < 0.0 ? "A" : "P";
        String orientationZ = z < 0.0 ? "F" : "H";
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double absZ = Math.abs(z);
        if (absX > 0.8 && absX > absY && absX > absZ) {
            axis = orientationX;
        } else if (absY > 0.8 && absY > absX && absY > absZ) {
            axis = orientationY;
        } else if (absZ > 0.8 && absZ > absX && absZ > absY) {
            axis = orientationZ;
        }
        return axis;
    }

    public static final String makeImageOrientationLabelFromImageOrientationPatient(double rowX, double rowY, double rowZ, double colX, double colY, double colZ) {
        String label = null;
        String rowAxis = ImageOrientation.getMajorAxisFromPatientRelativeDirectionCosine(rowX, rowY, rowZ);
        String colAxis = ImageOrientation.getMajorAxisFromPatientRelativeDirectionCosine(colX, colY, colZ);
        if (rowAxis != null && colAxis != null) {
            if ((rowAxis.equals("R") || rowAxis.equals("L")) && (colAxis.equals("A") || colAxis.equals("P"))) {
                label = LABELS[1];
            } else if ((colAxis.equals("R") || colAxis.equals("L")) && (rowAxis.equals("A") || rowAxis.equals("P"))) {
                label = LABELS[1];
            } else if ((rowAxis.equals("R") || rowAxis.equals("L")) && (colAxis.equals("H") || colAxis.equals("F"))) {
                label = LABELS[3];
            } else if ((colAxis.equals("R") || colAxis.equals("L")) && (rowAxis.equals("H") || rowAxis.equals("F"))) {
                label = LABELS[3];
            } else if ((rowAxis.equals("A") || rowAxis.equals("P")) && (colAxis.equals("H") || colAxis.equals("F"))) {
                label = LABELS[2];
            } else if ((colAxis.equals("A") || colAxis.equals("P")) && (rowAxis.equals("H") || rowAxis.equals("F"))) {
                label = LABELS[2];
            }
        } else {
            label = LABELS[4];
        }
        return label;
    }

    public static final String makeImageOrientationLabelFromImageOrientationPatient(double[] v) {
        if (v == null || v.length < 6) {
            return null;
        }
        return ImageOrientation.makeImageOrientationLabelFromImageOrientationPatient(v[0], v[1], v[2], v[3], v[4], v[5]);
    }

    public static final String makePatientOrientationFromPatientRelativeDirectionCosine(double x, double y, double z) {
        StringBuffer buffer = new StringBuffer();
        String orientationX = x < 0.0 ? "R" : "L";
        String orientationY = y < 0.0 ? "A" : "P";
        String orientationZ = z < 0.0 ? "F" : "H";
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double absZ = Math.abs(z);
        for (int i = 0; i < 3; ++i) {
            if (absX > 1.0E-4 && absX > absY && absX > absZ) {
                buffer.append(orientationX);
                absX = 0.0;
                continue;
            }
            if (absY > 1.0E-4 && absY > absX && absY > absZ) {
                buffer.append(orientationY);
                absY = 0.0;
                continue;
            }
            if (!(absZ > 1.0E-4) || !(absZ > absX) || !(absZ > absY)) break;
            buffer.append(orientationZ);
            absZ = 0.0;
        }
        return buffer.toString();
    }

    public static final String makePatientOrientationFromImageOrientationPatient(double rowX, double rowY, double rowZ, double colX, double colY, double colZ) {
        return ImageOrientation.makePatientOrientationFromPatientRelativeDirectionCosine(rowX, rowY, rowZ) + "\\" + ImageOrientation.makePatientOrientationFromPatientRelativeDirectionCosine(colX, colY, colZ);
    }

    public static final TransposeType getAxialImageRotationCcw(DicomObject dcmObj) {
        if (dcmObj == null) {
            return null;
        }
        double[] v = dcmObj.getDoubles(2097207);
        if (v != null && v.length == 6) {
            String rowAxis = ImageOrientation.getMajorAxisFromPatientRelativeDirectionCosine(v[0], v[1], v[2]);
            String colAxis = ImageOrientation.getMajorAxisFromPatientRelativeDirectionCosine(v[3], v[4], v[5]);
            if (rowAxis.equals("A") && (colAxis.equals("L") || rowAxis.equals("R"))) {
                return TransposeDescriptor.ROTATE_270;
            }
            if ((rowAxis.equals("R") || rowAxis.equals("L")) && colAxis.equals("A")) {
                return TransposeDescriptor.ROTATE_180;
            }
            if (rowAxis.equals("P") && (colAxis.equals("L") || colAxis.equals("R"))) {
                return TransposeDescriptor.ROTATE_90;
            }
        }
        return null;
    }

    public static final TransposeType getImageRotationCcwFromSagittal(DicomObject dcmObj) {
        if (dcmObj == null) {
            return null;
        }
        double[] v = dcmObj.getDoubles(2097207);
        if (v != null && v.length == 6) {
            String rowAxis = ImageOrientation.getMajorAxisFromPatientRelativeDirectionCosine(v[0], v[1], v[2]);
            if (rowAxis.equals("A")) {
                return TransposeDescriptor.ROTATE_270;
            }
            if (rowAxis.equals("P")) {
                return TransposeDescriptor.ROTATE_90;
            }
        }
        return null;
    }

    public static final TransposeType getImageRotationCcwFromCoronal(DicomObject dcmObj) {
        if (dcmObj == null) {
            return null;
        }
        double[] v = dcmObj.getDoubles(2097207);
        if (v != null && v.length == 6) {
            String rowAxis = ImageOrientation.getMajorAxisFromPatientRelativeDirectionCosine(v[0], v[1], v[2]);
            String colAxis = ImageOrientation.getMajorAxisFromPatientRelativeDirectionCosine(v[3], v[4], v[5]);
            if (rowAxis.equals("R") && colAxis.equals("F") || rowAxis.equals("L") && colAxis.equals("H")) {
                return TransposeDescriptor.ROTATE_180;
            }
        }
        return null;
    }

    public static double[] computeNormalVectorOfPlan(double[] vector) {
        if (vector != null && vector.length == 6) {
            double[] norm = new double[]{vector[1] * vector[5] - vector[2] * vector[4], vector[2] * vector[3] - vector[0] * vector[5], vector[0] * vector[4] - vector[1] * vector[3]};
            return norm;
        }
        return null;
    }

    public static boolean hasSameOrientation(MediaSeries<DicomImageElement> series1, MediaSeries<DicomImageElement> series2) {
        if (series1 != null && series2 != null) {
            DicomImageElement image1 = (DicomImageElement)((Object)series1.getMedia(MediaSeries.MEDIA_POSITION.MIDDLE));
            DicomImageElement image2 = (DicomImageElement)((Object)series2.getMedia(MediaSeries.MEDIA_POSITION.MIDDLE));
            return ImageOrientation.hasSameOrientation(image1, image2);
        }
        return false;
    }

    public static boolean hasSameOrientation(DicomImageElement image1, DicomImageElement image2) {
        if (image1 != null && image2 != null) {
            double[] v1 = (double[])image1.getTagValue(TagW.ImageOrientationPatient);
            double[] v2 = (double[])image2.getTagValue(TagW.ImageOrientationPatient);
            if (v1 != null && v1.length == 6 && v2 != null && v2.length == 6) {
                double prod;
                String label1 = ImageOrientation.makeImageOrientationLabelFromImageOrientationPatient(v1[0], v1[1], v1[2], v1[3], v1[4], v1[5]);
                String label2 = ImageOrientation.makeImageOrientationLabelFromImageOrientationPatient(v2[0], v2[1], v2[2], v2[3], v2[4], v2[5]);
                if (label1 != null && !label1.equals(LABELS[4])) {
                    return label1.equals(label2);
                }
                double[] postion1 = ImageOrientation.computeNormalVectorOfPlan((double[])image1.getTagValue(TagW.ImageOrientationPatient));
                double[] postion2 = ImageOrientation.computeNormalVectorOfPlan((double[])image2.getTagValue(TagW.ImageOrientationPatient));
                if (postion1 != null && postion2 != null && (prod = postion1[0] * postion2[0] + postion1[1] * postion2[1] + postion1[2] * postion2[2]) > 0.95) {
                    return true;
                }
            }
        }
        return false;
    }
}

