/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import org.dcm4che2.data.VR;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.TagW;
import org.weasis.dicom.codec.TagDictionary;

public class DicomTag
extends TagW {
    private final VR vr;
    private final String vm;
    private final boolean retired;

    public DicomTag(int key, String name, VR vr, String vm, String format, boolean retired) {
        super(key, name, TagDictionary.getTagType(vr, vm));
        this.vr = vr;
        this.vm = vm;
        this.format = format;
        this.retired = retired;
    }

    public String getVm() {
        return this.vm;
    }

    public boolean isRetired() {
        return this.retired;
    }

    public String getFormattedText(MediaElement image) {
        TagW tag = image.getTagElement(this.id);
        if (tag == null) {
            return "";
        }
        return super.getFormattedText(image.getTagValue(tag));
    }

    public static String getFormattedTag(int key) {
        String tagVal = Integer.toHexString(key).toUpperCase();
        int cut = tagVal.length() - 4;
        String tag1 = tagVal.substring(0, cut);
        while (tag1.length() < 4) {
            tag1 = "0" + tag1;
        }
        return " (" + tag1 + "," + tagVal.substring(cut) + ")";
    }
}

