/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashtable<T> {
    private static final float HIGH_WATER_FACTOR = 0.4f;
    private static final float LOW_WATER_FACTOR = 0.0f;
    private static final int[] PRIMES = new int[]{7, 17, 37, 67, 131, 257, 521, 1031, 2053, 4099, 8209, 16411, 32771, 65537, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000003, Integer.MAX_VALUE};
    private int primeIndex;
    private int highWaterMark;
    private int lowWaterMark;
    private int count;
    private int[] keyList;
    private T[] values;
    private T value0;
    private volatile int[] sortedKeys;

    private static int primeIndex(int size) {
        for (int i = 0; i < PRIMES.length; ++i) {
            if (size >= PRIMES[i]) continue;
            return i;
        }
        return PRIMES.length - 1;
    }

    public IntHashtable() {
        this.initialize(3);
    }

    public IntHashtable(int initialSize) {
        this.initialize(IntHashtable.primeIndex((int)((float)initialSize / 0.4f)));
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void clear() {
        this.count = 0;
        Arrays.fill(this.keyList, 0);
        Arrays.fill(this.values, null);
        this.value0 = null;
        this.sortedKeys = null;
    }

    public void put(int key, T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (key == 0) {
            if (this.value0 == null) {
                ++this.count;
            }
            this.value0 = value;
            return;
        }
        this.sortedKeys = null;
        int index = this.find(key);
        if (this.values[index] == null) {
            ++this.count;
        }
        this.keyList[index] = key;
        this.values[index] = value;
        if (this.count > this.highWaterMark) {
            this.rehash();
        }
    }

    public T get(int key) {
        return key == 0 ? this.value0 : this.values[this.find(key)];
    }

    public Object remove(int key) {
        Object retval = null;
        if (key == 0) {
            if (this.value0 != null) {
                retval = this.value0;
                this.value0 = null;
                --this.count;
            }
        } else {
            int index = this.find(key);
            if (this.values[index] != null) {
                retval = this.values[index];
                this.sortedKeys = null;
                this.values[index] = null;
                --this.count;
                if (this.count < this.lowWaterMark) {
                    this.rehash();
                }
            }
        }
        return retval;
    }

    public boolean equals(Object that) {
        if (!(that instanceof IntHashtable)) {
            return false;
        }
        IntHashtable other = (IntHashtable)that;
        if (other.size() != this.count) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            T v = this.values[i];
            if (v == null || v.equals(other.get(this.keyList[i]))) continue;
            return false;
        }
        return this.equals(this.value0, other.value0);
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o1);
    }

    public int hashCode() {
        if (this.count == 0) {
            return 0;
        }
        int h = 0;
        for (int i = 0; i < this.values.length; ++i) {
            T v = this.values[i];
            if (v == null) continue;
            h += this.keyList[i] ^ v.hashCode();
        }
        if (this.value0 != null) {
            h = 37 * h + this.value0.hashCode();
        }
        return h;
    }

    public Object clone() throws CloneNotSupportedException {
        Object result = super.clone();
        this.values = (Object[])this.values.clone();
        this.keyList = (int[])this.keyList.clone();
        this.sortedKeys = this.sortedKeys != null ? (int[])this.sortedKeys.clone() : null;
        return result;
    }

    public boolean accept(Visitor visitor) {
        if (this.value0 != null && !visitor.visit(0, this.value0)) {
            return false;
        }
        for (int i = 0; i < this.keyList.length; ++i) {
            T v = this.values[i];
            if (v == null || visitor.visit(this.keyList[i], v)) continue;
            return false;
        }
        return true;
    }

    public Iterator<T> iterator(int start, int end) {
        return new Itr(start, end);
    }

    private void initialize(int primeIndex) {
        this.primeIndex = Math.min(Math.max(0, primeIndex), PRIMES.length - 1);
        int initialSize = PRIMES[primeIndex];
        this.values = new Object[initialSize];
        this.keyList = new int[initialSize];
        this.sortedKeys = null;
        this.count = 0;
        if (this.value0 != null) {
            ++this.count;
        }
        this.lowWaterMark = (int)((float)initialSize * 0.0f);
        this.highWaterMark = (int)((float)initialSize * 0.4f);
    }

    private void rehash() {
        T[] oldValues = this.values;
        int[] oldkeyList = this.keyList;
        int newPrimeIndex = this.primeIndex;
        if (this.count > this.highWaterMark) {
            ++newPrimeIndex;
        } else if (this.count < this.lowWaterMark) {
            newPrimeIndex -= 2;
        }
        this.initialize(newPrimeIndex);
        for (int i = oldkeyList.length - 1; i >= 0; --i) {
            T value = oldValues[i];
            if (value == null) continue;
            int key = oldkeyList[i];
            int index = this.find(key);
            this.keyList[index] = key;
            this.values[index] = value;
            ++this.count;
        }
    }

    private int find(int key) {
        int firstDeleted = -1;
        int i = (key ^ 0x4000000) % this.keyList.length;
        if (i < 0) {
            i = -i;
        }
        int d = 0;
        do {
            int hash;
            if ((hash = this.keyList[i]) == key) {
                return i;
            }
            if (this.values[i] == null) {
                if (hash == 0) {
                    return firstDeleted >= 0 ? firstDeleted : i;
                }
                if (firstDeleted < 0) {
                    firstDeleted = i;
                }
            }
            if (d != 0) continue;
            d = key % (this.keyList.length - 1);
            if (d < 0) {
                d = -d;
            }
            ++d;
        } while ((i = (i + d) % this.keyList.length) != firstDeleted);
        return i;
    }

    static /* synthetic */ int[] access$202(IntHashtable x0, int[] x1) {
        x0.sortedKeys = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Itr
    implements Iterator<T> {
        int endIndex;
        int index;
        T next;
        int[] itrSortedKeys;

        private Itr(int start, int end) {
            if (((long)start & 0xFFFFFFFFL) > ((long)end & 0xFFFFFFFFL)) {
                throw new IllegalArgumentException("start:" + start + ", end:" + end);
            }
            if (IntHashtable.this.isEmpty()) {
                return;
            }
            if (end == 0) {
                if (start == 0) {
                    this.next = IntHashtable.this.value0;
                }
                return;
            }
            if (IntHashtable.this.sortedKeys == null) {
                int[] tSortedKeys = new int[IntHashtable.this.keyList.length];
                System.arraycopy(IntHashtable.this.keyList, 0, tSortedKeys, 0, IntHashtable.this.keyList.length);
                Arrays.sort(tSortedKeys);
                IntHashtable.access$202(IntHashtable.this, tSortedKeys);
            }
            this.itrSortedKeys = IntHashtable.this.sortedKeys;
            this.endIndex = Arrays.binarySearch(this.itrSortedKeys, end);
            if (this.endIndex < 0) {
                this.endIndex = this.endIndex == -1 ? this.itrSortedKeys.length - 1 : -(this.endIndex + 1) - 1;
            }
            this.index = Arrays.binarySearch(this.itrSortedKeys, start != 0 ? start : 1);
            if (this.index < 0) {
                this.index = -(this.index + 1) % this.itrSortedKeys.length;
            }
            if (start == 0 && IntHashtable.this.value0 != null) {
                this.next = IntHashtable.this.value0;
                --this.index;
            } else if (this.index != this.incIndex(this.endIndex)) {
                while ((this.next = IntHashtable.this.get(this.itrSortedKeys[this.index])) == null && this.index != this.endIndex) {
                    this.index = this.incIndex(this.index);
                }
            }
        }

        private int incIndex(int index) {
            return (index + 1) % this.itrSortedKeys.length;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object v = this.next;
            this.next = null;
            while (this.next == null && this.index != this.endIndex) {
                this.index = this.incIndex(this.index);
                this.next = IntHashtable.this.get(this.itrSortedKeys[this.index]);
            }
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Visitor {
        public boolean visit(int var1, Object var2);
    }
}

