/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.imageio;

import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.dcm4che2.data.ConfigurationError;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.imageio.ImageReaderWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.dicom.codec.pref.DicomPrefManager;

public class ImageReaderFactory
extends ImageReaderWriterFactory {
    private static final Logger log = LoggerFactory.getLogger(ImageReaderFactory.class);
    private static final String CONFIG_KEY = "org.dcm4che2.imageio.ImageReaderFactory";
    private static final String DEF_CONFIG = "org/dcm4che2/imageio/ImageReaderFactory.properties";
    private static final ImageReaderFactory instance = new ImageReaderFactory();

    private ImageReaderFactory() {
        super(CONFIG_KEY, DEF_CONFIG);
    }

    public static final ImageReaderFactory getInstance() {
        return instance;
    }

    public ImageReader getReaderForTransferSyntax(String tsuid) {
        String s = this.config.getProperty(tsuid);
        if (s == null) {
            throw new UnsupportedOperationException("No Image Reader available for Transfer Syntax:" + tsuid);
        }
        int delim = s.indexOf(44);
        if (delim == -1) {
            throw new ConfigurationError("Missing ',' in " + tsuid + "=" + s);
        }
        if ("1.2.840.10008.1.2.4.90".equals(tsuid) || "1.2.840.10008.1.2.4.91".equals(tsuid)) {
            ImageReader r = this.getJpeg2000Reader(this.config.getProperty("jpeg2000"));
            if (s == null) {
                throw new UnsupportedOperationException("No JPEG2000 Reader available");
            }
            return r;
        }
        int delim2 = s.indexOf(44, delim + 1);
        String formatName = s.substring(0, delim);
        String className = s.substring(delim + 1, delim2 == -1 ? s.length() : delim2);
        Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName(formatName);
        while (it.hasNext()) {
            ImageReader r = it.next();
            if (className.equals(r.getClass().getName())) {
                log.debug("Found reader " + className + " for " + tsuid);
                return r;
            }
            log.debug("Skipping image reader " + r.getClass().getName());
        }
        if ("1.2.840.10008.1.2.4.50".equals(tsuid)) {
            String stdJpeg = "com.sun.imageio.plugins.jpeg.JPEGImageReader";
            Iterator<ImageReader> it2 = ImageIO.getImageReadersByFormatName("jpeg");
            while (it2.hasNext()) {
                ImageReader r = it2.next();
                if (!"com.sun.imageio.plugins.jpeg.JPEGImageReader".equals(r.getClass().getName())) continue;
                log.debug("Found reader com.sun.imageio.plugins.jpeg.JPEGImageReader for " + tsuid);
                return r;
            }
        }
        throw new ConfigurationError("No Image Reader of class " + className + " available for format:" + formatName);
    }

    public boolean needsImageTypeSpecifier(String tsuid) {
        String typeSpecifier = this.config.getProperty(tsuid + ".typeSpecifier");
        return "true".equalsIgnoreCase(typeSpecifier);
    }

    public String getProperty(String prop) {
        return this.config.getProperty(prop, "");
    }

    public ImageReader getJpeg2000Reader(String decoders) {
        String j2kReader = DicomPrefManager.getInstance().getJ2kReader();
        if (j2kReader != null) {
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("jpeg2000");
            while (it.hasNext()) {
                ImageReader r = it.next();
                if (!j2kReader.equals(r.getClass().getName())) continue;
                return r;
            }
        }
        if (decoders != null) {
            String[] list;
            HashMap<String, ImageReader> installedDecoders = new HashMap<String, ImageReader>(5);
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("jpeg2000");
            while (it.hasNext()) {
                ImageReader r = it.next();
                installedDecoders.put(r.getClass().getName(), r);
            }
            for (String d : list = decoders.split(",")) {
                ImageReader r = (ImageReader)installedDecoders.get(d.trim());
                if (r == null) continue;
                log.debug("Found jpeg2000 reader : {}", (Object)r.getClass().getName());
                return r;
            }
        }
        return null;
    }

    public void adjustDatasetForTransferSyntax(DicomObject ds, String tsuid) {
        if (ds.getInt(0x280002, 1) == 1) {
            return;
        }
        String s = this.config.getProperty(tsuid);
        if (s == null) {
            return;
        }
        int delim = s.indexOf(44);
        if (delim == -1) {
            return;
        }
        int delim2 = s.indexOf(44, delim + 1);
        if (delim2 == -1) {
            return;
        }
        int delim3 = s.indexOf(44, delim2 + 1);
        String planarConfig = s.substring(delim2 + 1, delim3 == -1 ? s.length() : delim3);
        if (planarConfig.length() != 0) {
            try {
                ds.putInt(2621446, VR.US, Integer.parseInt(planarConfig));
            }
            catch (NumberFormatException e) {
                throw new ConfigurationError("Illegal value for Planar Configuration: " + s);
            }
        }
        if (delim3 == -1) {
            return;
        }
        String pmi = s.substring(delim3 + 1);
        if (pmi.length() != 0) {
            ds.putString(2621444, VR.CS, pmi);
        }
    }
}

