/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.image;

import java.awt.color.ColorSpace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleYBRColorSpace
extends ColorSpace {
    private static final Logger log = LoggerFactory.getLogger(SimpleYBRColorSpace.class);
    private static final long serialVersionUID = 94133999660773774L;
    private static double[] TO_YBR_FULL = new double[]{0.299, 0.587, 0.114, 0.0, -0.1687, -0.3313, 0.5, 0.5, 0.5, -0.4187, -0.0813, 0.5};
    private static double[] TO_YBR_PARTIAL = new double[]{0.2568, 0.5041, 0.0979, 0.0625, -0.1482, -0.291, 0.4392, 0.5, 0.4392, -0.3678, -0.0714, 0.5};
    private static final double[] FROM_YBR_FULL = new double[]{1.0, -3.681999032610751E-5, 1.4019875769352639, -0.7009753784724688, 1.0, -0.34411328131331737, -0.7141038211151132, 0.5291085512142153, 1.0, 1.7719781167370596, -1.345834129159976E-4, -0.8859217666620718};
    private static final double[] FROM_YBR_PARTIAL = new double[]{1.1644154634373545, -9.503599204778129E-5, 1.5960018776303868, -0.8707293872840042, 1.1644154634373545, -0.39172456367367336, -0.8130133682767554, 0.5295929995103797, 1.1644154634373545, 2.017290682233469, -1.3527300480981362E-4, -1.0813536710791642};
    private final ColorSpace csRGB;
    private final double[] toYBR;
    private final double[] toRGB;

    public static ColorSpace createYBRFullColorSpace(ColorSpace rgbCS) {
        return new SimpleYBRColorSpace(rgbCS, TO_YBR_FULL, FROM_YBR_FULL);
    }

    public static ColorSpace createYBRPartialColorSpace(ColorSpace rgbCS) {
        return new SimpleYBRColorSpace(rgbCS, TO_YBR_PARTIAL, FROM_YBR_PARTIAL);
    }

    private SimpleYBRColorSpace(ColorSpace csRGB, double[] toYBR, double[] fromYBR) {
        super(3, 3);
        this.csRGB = csRGB;
        this.toYBR = toYBR;
        this.toRGB = fromYBR;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof SimpleYBRColorSpace;
    }

    public int hashCode() {
        return 1;
    }

    public float[] toRGB(float[] ybr) {
        float r = (float)Math.max(0.0, Math.min(1.0, this.toRGB[0] * (double)ybr[0] + this.toRGB[1] * (double)ybr[1] + this.toRGB[2] * (double)ybr[2] + this.toRGB[3]));
        float g = (float)Math.max(0.0, Math.min(1.0, this.toRGB[4] * (double)ybr[0] + this.toRGB[5] * (double)ybr[1] + this.toRGB[6] * (double)ybr[2] + this.toRGB[7]));
        float b = (float)Math.max(0.0, Math.min(1.0, this.toRGB[8] * (double)ybr[0] + this.toRGB[9] * (double)ybr[1] + this.toRGB[10] * (double)ybr[2] + this.toRGB[11]));
        return new float[]{r, g, b};
    }

    public float[] fromRGB(float[] rgb) {
        float y = (float)Math.max(0.0, Math.min(1.0, this.toYBR[0] * (double)rgb[0] + this.toYBR[1] * (double)rgb[1] + this.toYBR[2] * (double)rgb[2] + this.toYBR[3]));
        float cb = (float)Math.max(0.0, Math.min(1.0, this.toYBR[4] * (double)rgb[0] + this.toYBR[5] * (double)rgb[1] + this.toYBR[6] * (double)rgb[2] + this.toYBR[7]));
        float cr = (float)Math.max(0.0, Math.min(1.0, this.toYBR[8] * (double)rgb[0] + this.toYBR[9] * (double)rgb[1] + this.toYBR[10] * (double)rgb[2] + this.toYBR[11]));
        return new float[]{y, cb, cr};
    }

    public float[] toCIEXYZ(float[] colorvalue) {
        return this.csRGB.toCIEXYZ(this.toRGB(colorvalue));
    }

    public float[] fromCIEXYZ(float[] xyzvalue) {
        return this.fromRGB(this.csRGB.fromCIEXYZ(xyzvalue));
    }

    public static void main(String[] args) {
        SimpleYBRColorSpace.out("FROM_YBR_FULL", SimpleYBRColorSpace.fromYBR(TO_YBR_FULL));
        SimpleYBRColorSpace.out("FROM_YBR_PARTIAL", SimpleYBRColorSpace.fromYBR(TO_YBR_PARTIAL));
    }

    private static void out(String label, double[] a) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n    private static final double[] ");
        sb.append(label);
        sb.append(" = {");
        for (int i = 0; i < a.length; ++i) {
            if (i % 4 == 0) {
                sb.append("\n        ");
            }
            sb.append(a[i]);
            sb.append(", ");
        }
        sb.append("\n    };");
        log.info(sb.toString());
    }

    private static double[] fromYBR(double[] a) {
        double[] toRGB = new double[12];
        double det = a[0] * a[5] * a[10] + a[1] * a[6] * a[8] + a[2] * a[4] * a[9] - a[2] * a[5] * a[8] - a[1] * a[4] * a[10] - a[0] * a[6] * a[9];
        toRGB[0] = (a[5] * a[10] - a[6] * a[9]) / det;
        toRGB[1] = (a[2] * a[9] - a[1] * a[10]) / det;
        toRGB[2] = (a[1] * a[6] - a[2] * a[5]) / det;
        toRGB[3] = (a[2] * a[5] * a[11] + a[1] * a[7] * a[10] + a[3] * a[6] * a[9] - a[3] * a[5] * a[10] - a[1] * a[6] * a[11] - a[2] * a[7] * a[9]) / det;
        toRGB[4] = (a[6] * a[8] - a[4] * a[10]) / det;
        toRGB[5] = (a[0] * a[10] - a[2] * a[8]) / det;
        toRGB[6] = (a[2] * a[4] - a[0] * a[6]) / det;
        toRGB[7] = (a[2] * a[7] * a[8] + a[3] * a[4] * a[10] + a[0] * a[6] * a[11] - a[0] * a[7] * a[10] - a[3] * a[6] * a[8] - a[2] * a[4] * a[11]) / det;
        toRGB[8] = (a[4] * a[9] - a[5] * a[8]) / det;
        toRGB[9] = (a[1] * a[8] - a[0] * a[9]) / det;
        toRGB[10] = (a[0] * a[5] - a[1] * a[4]) / det;
        toRGB[11] = (a[3] * a[5] * a[8] + a[1] * a[4] * a[11] + a[0] * a[7] * a[9] - a[0] * a[5] * a[11] - a[1] * a[7] * a[8] - a[3] * a[4] * a[9]) / det;
        return toRGB;
    }
}

